/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BooleanPropertyGroup;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.RadioButtonCellEditor;
import lavesdk.gui.widgets.RadioButtonCellRenderer;

public class BooleanProperty
extends Property {
    private final BooleanPropertyGroup group;

    public BooleanProperty(String string, String string2) throws IllegalArgumentException {
        this(string, string2, null);
    }

    public BooleanProperty(String string, String string2, BooleanPropertyGroup booleanPropertyGroup) throws IllegalArgumentException {
        this(string, string2, false, booleanPropertyGroup);
    }

    public BooleanProperty(String string, String string2, boolean bl) {
        this(string, string2, bl, (BooleanPropertyGroup)null);
    }

    public BooleanProperty(String string, String string2, boolean bl, BooleanPropertyGroup booleanPropertyGroup) throws IllegalArgumentException {
        super(string, string2, bl, new Object[]{booleanPropertyGroup != null});
        this.group = booleanPropertyGroup;
        if (booleanPropertyGroup != null) {
            booleanPropertyGroup.add(this);
        }
    }

    @Override
    public Boolean getValue() {
        if (EDT.isExecutedInEDT()) {
            return (Boolean)this.value;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return (Boolean)BooleanProperty.this.value;
            }
        });
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (!(object instanceof Boolean) || object == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setValue((Boolean)object);
    }

    public void setValue(final boolean bl) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.value = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setValue"){

                @Override
                protected void execute() throws Throwable {
                    BooleanProperty.this.value = bl;
                }
            });
        }
    }

    @Override
    protected TableCellEditor createEditor(Object[] objectArray) {
        if (!((Boolean)objectArray[0]).booleanValue()) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            return new DefaultCellEditor(jCheckBox);
        }
        return new RadioButtonCellEditor();
    }

    @Override
    protected TableCellRenderer createRenderer(Object[] objectArray) {
        if (!((Boolean)objectArray[0]).booleanValue()) {
            return null;
        }
        return new RadioButtonCellRenderer();
    }

    @Override
    protected Class<?> getValueClass() {
        return Boolean.class;
    }

    @Override
    protected Object onEditStop(Object object) {
        if (this.group != null) {
            this.group.update(this);
        }
        return object;
    }
}

