/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.net.URL;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import lavesdk.algorithm.text.AnnotationImagesList;

public class AnnotationViewKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 1L;
    private final AnnotationViewFactory viewFactory;

    public AnnotationViewKit(AnnotationImagesList annotationImagesList) {
        this.viewFactory = new AnnotationViewFactory(annotationImagesList);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    private static class AnnotationViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private final AnnotationImagesList imagesList;

        public AnnotationViewFactory(AnnotationImagesList annotationImagesList) {
            this.imagesList = annotationImagesList;
        }

        @Override
        public View create(Element element) {
            HTML.Tag tag;
            AttributeSet attributeSet = element.getAttributes();
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag && (tag = (HTML.Tag)object) == HTML.Tag.IMG) {
                return new AnnotationImageView(element);
            }
            return super.create(element);
        }

        private class AnnotationImageView
        extends ImageView {
            public AnnotationImageView(Element element) {
                super(element);
            }

            @Override
            public URL getImageURL() {
                if (AnnotationViewFactory.this.imagesList == null) {
                    return null;
                }
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
                if (string == null) {
                    return null;
                }
                return AnnotationViewFactory.this.imagesList.get(string);
            }
        }
    }
}

