/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.gui.dialogs.OptionDialog;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;
import lavesdk.utils.FileUtils;

public class SolveExerciseDialog
extends OptionDialog {
    private static final long serialVersionUID = 1L;
    private static final int MAX_OPEN_WIDTH = 600;
    private static final int MAX_OPEN_HEIGHT = 500;

    public SolveExerciseDialog(PluginHost pluginHost, AlgorithmExercise<?> algorithmExercise, SolutionEntry<?>[] solutionEntryArray, String string, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(pluginHost, LanguageFile.getLabel(languageFile, "SOLVEEXERCISEDLG_TITLE", string2, "Solve Exercise"), languageFile, string2);
        if (algorithmExercise == null || solutionEntryArray == null) {
            throw new IllegalArgumentException("No valid arguments!");
        }
        super.setIconImage(Resources.getInstance().EXERCISE_SOLVE_ICON != null ? Resources.getInstance().EXERCISE_SOLVE_ICON.getImage() : null);
        this.northPanel.setLayout(new BorderLayout(5, 5));
        this.northPanel.add((Component)new JLabel(Resources.getInstance().QUESTION_ICON), "West");
        this.northPanel.add((Component)new JLabel(this.getExerciseText(algorithmExercise)), "Center");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        if (string != null && !string.isEmpty()) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JLabel("<html>" + string.replaceAll(FileUtils.LINESEPARATOR, "<br>") + "</html>"), gridBagConstraints);
        }
        for (SolutionEntry<?> solutionEntry : solutionEntryArray) {
            if (solutionEntry == null) continue;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 0, 2, 2);
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JLabel("<html>" + solutionEntry.getLabel() + "</html>"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 0);
            gridBagConstraints.fill = 2;
            jPanel.add((Component)solutionEntry.getComponent(), gridBagConstraints);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)jScrollPane, "Center");
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(new Dimension(Math.min(dimension.width, 600), Math.min(dimension.height, 500)));
    }

    @Override
    protected void doOk() {
    }

    private String getExerciseText(AlgorithmExercise<?> algorithmExercise) {
        return "<html>" + algorithmExercise.getText().replaceAll(FileUtils.LINESEPARATOR, "<br>") + "</html>";
    }

    public static class SolutionEntry<C extends Component> {
        private final String label;
        private final C component;

        public SolutionEntry(String string, C c) throws IllegalArgumentException {
            if (c == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.label = string != null ? string : "";
            this.component = c;
        }

        public final String getLabel() {
            return this.label;
        }

        public final C getComponent() {
            return this.component;
        }
    }
}

