/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public abstract class OptionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel mainNorthPanel;
    protected final JPanel northPanel;
    protected final JPanel centerPanel;
    private final PluginHost host;
    private boolean canceled;

    public OptionDialog(PluginHost pluginHost, String string, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        this(pluginHost, string, languageFile, string2, false);
    }

    public OptionDialog(PluginHost pluginHost, String string, LanguageFile languageFile, String string2, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.host = pluginHost;
        this.canceled = true;
        super.setTitle(string);
        if (bl) {
            super.setType(Window.Type.UTILITY);
        }
        super.setModal(true);
        super.setResizable(true);
        super.setIconImage(Resources.getInstance().EMPTY_IMAGE);
        super.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.northPanel = new JPanel(){
            private static final long serialVersionUID = 1L;
            private boolean hasSeparator = false;

            @Override
            protected void addImpl(Component component, Object object, int n) {
                super.addImpl(component, object, n);
                if (!this.hasSeparator) {
                    this.hasSeparator = true;
                    OptionDialog.this.mainNorthPanel.add((Component)new JSeparator(), "South");
                    OptionDialog.this.mainNorthPanel.setBackground(Color.white);
                    this.setBackground(Color.white);
                    this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                }
            }
        };
        this.mainNorthPanel = new JPanel(new BorderLayout());
        this.mainNorthPanel.add((Component)this.northPanel, "Center");
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(LanguageFile.getLabel(languageFile, "DLG_BTN_OK", string2, "Ok"));
        JButton jButton2 = new JButton(LanguageFile.getLabel(languageFile, "DLG_BTN_CANCEL", string2, "Cancel"));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add((Component)this.mainNorthPanel, "North");
        jPanel.add((Component)this.centerPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.pack();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.canceled = false;
                OptionDialog.this.doOk();
                OptionDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.canceled = true;
                OptionDialog.this.dispose();
            }
        });
    }

    @Override
    public final void pack() {
        super.pack();
        if (this.host == null) {
            super.setLocationRelativeTo(null);
        } else {
            this.host.adaptDialog(this);
        }
    }

    @Override
    public final void setModal(boolean bl) {
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    protected abstract void doOk();
}

