/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.text.Annotation;
import lavesdk.gui.widgets.AnnotationViewKit;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public class AnnotationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public AnnotationDialog(PluginHost pluginHost, Annotation annotation, LanguageFile languageFile, String string) throws IllegalArgumentException {
        if (annotation == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setTitle(LanguageFile.getLabel(languageFile, "ANNOTATIONDLG_TITLE", string, "Annotation"));
        this.setResizable(true);
        this.setIconImage(Resources.getInstance().EMPTY_IMAGE);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        container.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JEditorPane jEditorPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jEditorPane.setEditorKit(new AnnotationViewKit(annotation.getImagesList()));
        jEditorPane.setText(annotation.getText());
        jEditorPane.setEditable(false);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(LanguageFile.getLabel(languageFile, "DLG_BTN_QUIT", string, "Quit"));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        if (pluginHost == null) {
            this.setLocationRelativeTo(null);
        } else {
            pluginHost.adaptDialog(this);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationDialog.this.dispose();
            }
        });
    }
}

