/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.gui.dialogs.OptionDialog;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.MatrixEditor;
import lavesdk.gui.widgets.Symbol;
import lavesdk.language.LanguageFile;
import lavesdk.math.Matrix;
import lavesdk.math.NumericMatrix;
import lavesdk.resources.Resources;

public class AdjacencyMatrixDialog
extends OptionDialog {
    private static final long serialVersionUID = 1L;
    private final MatrixEditor<Float> matrixEditor;
    private final JCheckBox cbAllowZeroWeights;
    private final JCheckBox cbDirectedGraph;
    private Matrix<Float> adjacencyMatrix;
    private static final int DEF_MATRIXSIZE = 4;

    public AdjacencyMatrixDialog(PluginHost pluginHost, LanguageFile languageFile, String string) {
        this(pluginHost, languageFile, string, AllowedGraphType.BOTH);
    }

    public AdjacencyMatrixDialog(PluginHost pluginHost, LanguageFile languageFile, String string, AllowedGraphType allowedGraphType) throws IllegalArgumentException {
        super(pluginHost, LanguageFile.getLabel(languageFile, "ADJACENCYMATRIXDLG_TITLE", string, "Adjacency Matrix"), languageFile, string, true);
        if (allowedGraphType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.matrixEditor = new MatrixEditor<Float>(new MatrixEditor.FloatElementFormat());
        this.matrixEditor.addMask(new Mask((Object)Float.valueOf(Float.POSITIVE_INFINITY), Symbol.getPredefinedSymbol(Symbol.PredefinedSymbol.INFINITY)));
        this.cbAllowZeroWeights = new JCheckBox(LanguageFile.getLabel(languageFile, "ADJACENCYMATRIXDLG_ALLOWZEROWEIGHTS", string, "Allow zero-weight edges?"));
        this.cbDirectedGraph = new JCheckBox(LanguageFile.getLabel(languageFile, "DLG_CB_CREATEDIRECTEDGRAPH", string, "Create a directed graph?"));
        this.adjacencyMatrix = null;
        final JTextField jTextField = new JTextField("4");
        JButton jButton = new JButton(Resources.getInstance().REFRESH_ICON);
        this.cbDirectedGraph.setSelected(allowedGraphType == AllowedGraphType.DIRECTED_ONLY);
        this.cbDirectedGraph.setEnabled(allowedGraphType == AllowedGraphType.BOTH);
        this.northPanel.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.northPanel.add((Component)new JLabel("<html>" + LanguageFile.getLabel(languageFile, "ADJACENCYMATRIXDLG_DESCRIPTION", string, "Enter the number of vertices and create the adjacency matrix by selecting a field and enter a weight for the edge using the keyboard.") + "</html>"), "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.centerPanel.add((Component)new JLabel(LanguageFile.getLabel(languageFile, "ADJACENCYMATRIXDLG_NOV", string, "Number of vertices:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.centerPanel.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.centerPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.centerPanel.add((Component)this.cbAllowZeroWeights, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 2, 0);
        this.centerPanel.add((Component)new JLabel("<html><i>" + LanguageFile.getLabel(languageFile, "ADJACENCYMATRIXDLG_ALLOWZEROWEIGHTS_DESC", string, "Enable this option to allow zero-weight edges too.<br>In that case use \"-\" as the entry for \"no edge\" in the adjacency matrix.") + "</i></html>"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        this.centerPanel.add(this.matrixEditor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.centerPanel.add((Component)this.cbDirectedGraph, gridBagConstraints);
        this.updateAdjacencyMatrix(jTextField.getText());
        this.pack();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdjacencyMatrixDialog.this.updateAdjacencyMatrix(jTextField.getText());
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AdjacencyMatrixDialog.this.updateAdjacencyMatrix(jTextField.getText());
                }
            }
        });
    }

    public Matrix<Float> getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    public boolean getAllowZeroWeights() {
        return this.cbAllowZeroWeights.isSelected();
    }

    public boolean getDirectedGraphChecked() {
        return this.cbDirectedGraph.isSelected();
    }

    @Override
    protected void doOk() {
        this.adjacencyMatrix = this.matrixEditor.getMatrix();
    }

    private void updateAdjacencyMatrix(String string) {
        Integer n;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        if (n == null) {
            return;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(n);
        for (int i = 1; i <= n; ++i) {
            hashMap.put(i - 1, "" + i);
        }
        this.matrixEditor.setRowLabels(hashMap);
        this.matrixEditor.setColumnLabels(hashMap);
        Matrix<Float> matrix = this.matrixEditor.getMatrix();
        NumericMatrix<Float> numericMatrix = new NumericMatrix<Float>(n, n, Float.valueOf(0.0f));
        if (matrix != null) {
            Matrix.copy(matrix, numericMatrix);
        }
        this.matrixEditor.setMatrix(numericMatrix);
        this.pack();
    }
}

