/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui;

abstract class GuiAction<T>
implements Runnable {
    protected final String name;
    protected final boolean hasResult;
    private T result;
    private RuntimeException rtException;

    protected GuiAction(String string, boolean bl) {
        this.name = string;
        this.hasResult = bl;
        this.result = null;
        this.rtException = null;
    }

    @Override
    public final void run() {
        try {
            this.result = this.perform();
        }
        catch (RuntimeException runtimeException) {
            if (this.hasResult) {
                this.rtException = runtimeException;
            } else {
                this.handleCaughtThrowable(runtimeException);
            }
        }
        catch (Throwable throwable) {
            this.handleCaughtThrowable(throwable);
        }
    }

    protected abstract T perform() throws Throwable;

    final boolean hasResult() {
        return this.hasResult;
    }

    final T getResult() {
        return this.result;
    }

    final void reset() {
        this.result = null;
        this.rtException = null;
    }

    final RuntimeException getCaughtRuntimeException() {
        return this.rtException;
    }

    private void handleCaughtThrowable(Throwable throwable) {
        System.err.println("it is occurred an exception for the gui action \"" + (this.name != null ? this.name : "null") + "\" (" + throwable.getClass().getSimpleName() + ", \"" + throwable.getMessage() + "\")");
    }
}

