/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import lavesdk.gui.GuiAction;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;

public class EDT {
    private EDT() {
    }

    public static boolean isExecutedInEDT() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static void execute(GuiJob guiJob) throws RuntimeException {
        EDT.perform(guiJob);
    }

    public static <T> T execute(GuiRequest<T> guiRequest) throws RuntimeException {
        return EDT.perform(guiRequest);
    }

    private static <T> T perform(GuiAction<T> guiAction) throws RuntimeException {
        if (guiAction == null) {
            throw new IllegalArgumentException("Invalid action (action == null)! Cannot be executed in the EDT.");
        }
        if (EDT.isExecutedInEDT()) {
            guiAction.run();
        } else if (guiAction.hasResult()) {
            try {
                SwingUtilities.invokeAndWait(guiAction);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                guiAction.reset();
            }
        } else {
            SwingUtilities.invokeLater(guiAction);
        }
        if (guiAction.hasResult() && guiAction.getCaughtRuntimeException() != null) {
            throw guiAction.getCaughtRuntimeException();
        }
        T t = guiAction.getResult();
        guiAction.reset();
        return t;
    }
}

