/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.graphics;

import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import lavesdk.graphics.SplineIntersectionPoint;

public class CatmullRomSpline {
    private final Point2D.Float[] splinePoints;
    private final GeneralPath path;
    private static final int DEF_INTERPOLATION = 24;

    public CatmullRomSpline(List<Point> list) throws IllegalArgumentException {
        this(list, 24);
    }

    public CatmullRomSpline(Point[] pointArray) throws IllegalArgumentException {
        this(pointArray, 24);
    }

    public CatmullRomSpline(Point[] pointArray, int n) throws IllegalArgumentException {
        this(CatmullRomSpline.toPointList(pointArray), n);
    }

    public CatmullRomSpline(List<Point> list, int n) throws IllegalArgumentException {
        if (list == null || list.size() < 2 || n < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.splinePoints = new Point2D.Float[(list.size() - 1) * n + 1];
        if (list.size() >= 3) {
            float f = 1.0f / (float)n;
            for (int i = 0; i < list.size() - 1; ++i) {
                Point point = i == 0 ? list.get(i) : list.get(i - 1);
                Point point2 = list.get(i);
                Point point3 = list.get(i + 1);
                Point point4 = i + 2 == list.size() ? list.get(i + 1) : list.get(i + 2);
                CatmullRomSplineSegment catmullRomSplineSegment = new CatmullRomSplineSegment(point, point2, point3, point4);
                for (int j = 0; j <= n; ++j) {
                    this.splinePoints[i * n + j] = catmullRomSplineSegment.q((float)j * f);
                }
            }
        } else {
            this.splinePoints[0] = new Point2D.Float(list.get((int)0).x, list.get((int)0).y);
            this.splinePoints[1] = new Point2D.Float(list.get((int)1).x, list.get((int)1).y);
        }
        this.path = new GeneralPath();
        for (int i = 0; i < this.splinePoints.length; ++i) {
            Point2D.Float float_ = this.splinePoints[i];
            if (i == 0) {
                this.path.moveTo(float_.x, float_.y);
                continue;
            }
            this.path.lineTo(float_.x, float_.y);
        }
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public boolean contains(Point point) throws IllegalArgumentException {
        if (point == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.contains(point, 1);
    }

    public boolean contains(Point point, int n) throws IllegalArgumentException {
        if (point == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.contains(point.x, point.y, n);
    }

    public boolean contains(int n, int n2) {
        return this.contains(n, n2, 1);
    }

    public boolean contains(int n, int n2, int n3) {
        Point2D.Float float_ = this.splinePoints[0];
        for (int i = 1; i < this.splinePoints.length; ++i) {
            Point2D.Float float_2 = this.splinePoints[i];
            if (Math.abs(Line2D.ptSegDist(float_.x, float_.y, float_2.x, float_2.y, n, n2)) <= (double)n3) {
                return true;
            }
            float_ = float_2;
        }
        return false;
    }

    public Point2D.Float[] getPoints() {
        return this.splinePoints;
    }

    public SplineIntersectionPoint intersect(CatmullRomSpline catmullRomSpline) throws IllegalArgumentException {
        List<SplineIntersectionPoint> list = this.intersect(catmullRomSpline, true);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<SplineIntersectionPoint> intersectMulti(CatmullRomSpline catmullRomSpline) throws IllegalArgumentException {
        return this.intersect(catmullRomSpline, false);
    }

    private List<SplineIntersectionPoint> intersect(CatmullRomSpline catmullRomSpline, boolean bl) throws IllegalArgumentException {
        if (catmullRomSpline == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ArrayList<SplineIntersectionPoint> arrayList = new ArrayList<SplineIntersectionPoint>(bl ? 1 : 5);
        Point2D.Float float_ = this.splinePoints[0];
        for (int i = 1; i < this.splinePoints.length; ++i) {
            Point2D.Float float_2 = this.splinePoints[i];
            Point2D.Float float_3 = catmullRomSpline.splinePoints[0];
            for (int j = 1; j < catmullRomSpline.splinePoints.length; ++j) {
                Point2D.Float float_4 = catmullRomSpline.splinePoints[j];
                SplineIntersectionPoint splineIntersectionPoint = this.lineSegIntersection(float_, float_2, float_3, float_4, i, j, catmullRomSpline);
                if (splineIntersectionPoint != null) {
                    arrayList.add(splineIntersectionPoint);
                    if (bl) {
                        return arrayList;
                    }
                }
                float_3 = float_4;
            }
            float_ = float_2;
        }
        return arrayList;
    }

    private SplineIntersectionPoint lineSegIntersection(Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3, Point2D.Float float_4, int n, int n2, CatmullRomSpline catmullRomSpline) {
        Point2D.Float float_5 = new Point2D.Float(float_2.x - float_.x, float_2.y - float_.y);
        Point2D.Float float_6 = new Point2D.Float(float_4.x - float_3.x, float_4.y - float_3.y);
        Point2D.Float float_7 = new Point2D.Float(float_3.x - float_.x, float_3.y - float_.y);
        float f = float_5.x * float_6.y - float_5.y * float_6.x;
        if (f == 0.0f) {
            return null;
        }
        float f2 = (float_7.x * float_6.y - float_7.y * float_6.x) / f;
        float f3 = (float_7.x * float_5.y - float_7.y * float_5.x) / f;
        if (f2 >= 0.0f && f2 <= 1.0f && f3 >= 0.0f && f3 <= 1.0f) {
            return new SplineIntersectionPoint(this, catmullRomSpline, (int)(float_.x + f2 * float_5.x), (int)(float_.y + f2 * float_5.y), n, n2);
        }
        return null;
    }

    private static List<Point> toPointList(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ArrayList<Point> arrayList = new ArrayList<Point>(pointArray.length);
        for (Point point : pointArray) {
            arrayList.add(point);
        }
        return arrayList;
    }

    private class CatmullRomSplineSegment {
        private final Point p0;
        private final Point p1;
        private final Point p2;
        private final Point p3;

        public CatmullRomSplineSegment(Point point, Point point2, Point point3, Point point4) throws IllegalArgumentException {
            if (point == null || point2 == null | point3 == null || point4 == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.p0 = point;
            this.p1 = point2;
            this.p2 = point3;
            this.p3 = point4;
        }

        public Point2D.Float q(float f) {
            float f2 = f * f;
            float f3 = f * f * f;
            float f4 = 0.5f * ((float)(2 * this.p1.x) + (float)(this.p2.x - this.p0.x) * f + (float)(2 * this.p0.x - 5 * this.p1.x + 4 * this.p2.x - this.p3.x) * f2 + (float)(3 * this.p1.x - this.p0.x - 3 * this.p2.x + this.p3.x) * f3);
            float f5 = 0.5f * ((float)(2 * this.p1.y) + (float)(this.p2.y - this.p0.y) * f + (float)(2 * this.p0.y - 5 * this.p1.y + 4 * this.p2.y - this.p3.y) * f2 + (float)(3 * this.p1.y - this.p0.y - 3 * this.p2.y + this.p3.y) * f3);
            return new Point2D.Float(f4, f5);
        }
    }
}

