/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.configuration;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import lavesdk.serialization.Serializer;
import lavesdk.utils.FileUtils;

public class Configuration
extends Serializer {
    private static final long serialVersionUID = 1L;
    private static int nextID = 1;

    public Configuration() {
        super(nextID++, "configuration");
    }

    public final Color addColor(String string, Color color) throws IllegalArgumentException {
        return this.addData(string, color);
    }

    public final Color getColor(String string) {
        return this.getColor(string, null);
    }

    public final Color getColor(String string, Color color) {
        return this.getData(string, Color.class, color);
    }

    public final Point addPoint(String string, Point point) throws IllegalArgumentException {
        return this.addData(string, point);
    }

    public final Point getPoint(String string) {
        return this.getPoint(string, null);
    }

    public final Point getPoint(String string, Point point) {
        return this.getData(string, Point.class, point);
    }

    public final Rectangle addRectangle(String string, Rectangle rectangle) throws IllegalArgumentException {
        return this.addData(string, rectangle);
    }

    public final Rectangle getRectangle(String string) {
        return this.getRectangle(string, null);
    }

    public final Rectangle getRectangle(String string, Rectangle rectangle) {
        return this.getData(string, Rectangle.class, rectangle);
    }

    public final Configuration addConfiguration(String string, Configuration configuration) throws IllegalArgumentException {
        return this.addData(string, configuration);
    }

    public final Configuration getConfiguration(String string) {
        return this.getData(string, Configuration.class);
    }

    @Override
    public boolean areKeysOverrideable() {
        return true;
    }

    public static Configuration load(File file) throws NullPointerException {
        return Configuration.load(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration load(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!string.endsWith(".cfg")) {
            string = string + ".cfg";
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
            Configuration configuration = (Configuration)objectInputStream.readObject();
            return configuration;
        }
        catch (IOException | ClassCastException | ClassNotFoundException exception) {
            System.out.println("INFO: No configuration file! Empty configuration is loaded for " + string + ".");
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new Configuration();
    }

    public static void save(File file, Configuration configuration) throws NullPointerException, IllegalArgumentException, IOException {
        Configuration.save(file.getAbsolutePath(), configuration);
    }

    public static void save(String string, Configuration configuration) throws IllegalArgumentException, IOException {
        if (string == null || configuration == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!string.endsWith(".cfg")) {
            string = string + ".cfg";
        }
        File file = FileUtils.createFilePath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(configuration);
        objectOutputStream.flush();
        objectOutputStream.close();
        fileOutputStream.close();
    }
}

