/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.transitions;

import java.awt.Point;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.RTTransition;

public abstract class LinearPositionTransition
extends RTTransition<Point> {
    protected final Point source;
    protected final Point target;
    private final float xDiv;
    private final float yDiv;

    public LinearPositionTransition(AlgorithmRTE algorithmRTE, Point point, Point point2) throws IllegalArgumentException {
        this(algorithmRTE, 300L, 10, point, point2);
    }

    public LinearPositionTransition(AlgorithmRTE algorithmRTE, long l, int n, Point point, Point point2) throws IllegalArgumentException {
        super(algorithmRTE, l, n);
        if (point == null || point2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        float f = n;
        this.source = point;
        this.target = point2;
        this.xDiv = (float)(point2.x - point.x) / f;
        this.yDiv = (float)(point2.y - point.y) / f;
    }

    @Override
    protected Point runStep(int n) {
        return new Point(this.source.x + (int)((float)n * this.xDiv), this.source.y + (int)((float)n * this.yDiv));
    }
}

