/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.transitions;

import java.awt.Color;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.RTTransition;

public abstract class ColorTransition
extends RTTransition<Color> {
    protected final Color from;
    protected final Color to;
    private final float rDiv;
    private final float gDiv;
    private final float bDiv;

    public ColorTransition(AlgorithmRTE algorithmRTE, Color color, Color color2) throws IllegalArgumentException {
        this(algorithmRTE, 300L, 10, color, color2);
    }

    public ColorTransition(AlgorithmRTE algorithmRTE, long l, int n, Color color, Color color2) throws IllegalArgumentException {
        super(algorithmRTE, l, n);
        if (color == null || color2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        float f = (float)n - 1.0f;
        this.from = color;
        this.to = color2;
        this.rDiv = (float)(color2.getRed() - color.getRed()) / f;
        this.gDiv = (float)(color2.getGreen() - color.getGreen()) / f;
        this.bDiv = (float)(color2.getBlue() - color.getBlue()) / f;
    }

    @Override
    protected final Color runStep(int n) {
        int n2 = n - 1;
        return new Color((int)((float)this.from.getRed() + (float)n2 * this.rDiv), (int)((float)this.from.getGreen() + (float)n2 * this.gDiv), (int)((float)this.from.getBlue() + (float)n2 * this.bDiv));
    }
}

