/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.text;

import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.exceptions.InvalidLaTeXFormulaException;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class LaTeXFormula {
    private final AlgorithmStep step;
    private final String expression;
    private TeXIcon normal;
    private TeXIcon highlighted;
    private final String parameters;
    private final String[] paramValues;
    private static final String PARAM_DELIMITER = ",";

    LaTeXFormula(AlgorithmStep algorithmStep, String string, String string2) throws IllegalArgumentException, InvalidLaTeXFormulaException {
        if (algorithmStep == null || string == null || string2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.step = algorithmStep;
        this.expression = string;
        this.parameters = string2;
        this.paramValues = string2.length() > 0 ? string2.split(PARAM_DELIMITER) : new String[0];
        this.updateFormula();
    }

    public final AlgorithmStep getStep() {
        return this.step;
    }

    public final String getExpression() {
        return this.expression;
    }

    public final String getParameters() {
        return this.parameters;
    }

    public final int getParameterCount() {
        return this.paramValues.length;
    }

    public final String getStringParameter(int n) throws ArrayIndexOutOfBoundsException {
        return this.paramValues[n];
    }

    public final int getIntParameter(int n) throws ArrayIndexOutOfBoundsException {
        try {
            return new Integer(this.paramValues[n]);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public final float getFloatParameter(int n) throws ArrayIndexOutOfBoundsException {
        try {
            return new Float(this.paramValues[n]).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public final boolean getBooleanParameter(int n) throws ArrayIndexOutOfBoundsException {
        try {
            return new Boolean(this.paramValues[n]);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public final TeXIcon getNormal() {
        return this.normal;
    }

    public final TeXIcon getHighlighted() {
        return this.highlighted;
    }

    public String toString() {
        return this.expression;
    }

    void updateFormula() throws InvalidLaTeXFormulaException {
        try {
            AlgorithmText algorithmText = this.step.getParagraph().getParent();
            TeXFormula.TeXIconBuilder teXIconBuilder = new TeXFormula.TeXIconBuilder(new TeXFormula(this.expression));
            this.normal = teXIconBuilder.setStyle(0).setSize(algorithmText.getFontSize()).build();
            this.highlighted = teXIconBuilder.setType(2).build();
        }
        catch (ParseException parseException) {
            throw new InvalidLaTeXFormulaException(parseException.getMessage() + " (" + this.expression + ")");
        }
    }
}

