/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmTextListener;
import lavesdk.algorithm.text.exceptions.InvalidIdentifierException;

public class AlgorithmText {
    private final List<AlgorithmParagraph> paragraphs;
    private final Map<Integer, AlgorithmParagraph> paragraphsByID;
    private final List<AlgorithmStep> steps;
    private final Map<Integer, AlgorithmStep> stepsByID;
    private final List<AlgorithmTextListener> listeners;
    private int executingStepID;
    private float fontSize;
    private AlgorithmExercise<?> finalExercise;
    public static final float FONTSIZE = 12.0f;

    public AlgorithmText() {
        this(12.0f);
    }

    public AlgorithmText(float f) throws IllegalArgumentException {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.paragraphs = new ArrayList<AlgorithmParagraph>(5);
        this.paragraphsByID = new HashMap<Integer, AlgorithmParagraph>(5);
        this.steps = new ArrayList<AlgorithmStep>();
        this.stepsByID = new HashMap<Integer, AlgorithmStep>();
        this.listeners = new ArrayList<AlgorithmTextListener>(3);
        this.executingStepID = -1;
        this.fontSize = f;
        this.finalExercise = null;
    }

    public void addTextListener(AlgorithmTextListener algorithmTextListener) {
        if (algorithmTextListener == null || this.listeners.contains(algorithmTextListener)) {
            return;
        }
        this.listeners.add(algorithmTextListener);
    }

    public void removeTextListener(AlgorithmTextListener algorithmTextListener) {
        if (algorithmTextListener == null || !this.listeners.contains(algorithmTextListener)) {
            return;
        }
        this.listeners.remove(algorithmTextListener);
    }

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    public AlgorithmParagraph getParagraph(int n) throws IndexOutOfBoundsException {
        return this.paragraphs.get(n);
    }

    public AlgorithmParagraph getParagraphByID(int n) {
        return this.paragraphsByID.get(n);
    }

    public int getStepCount() {
        return this.steps.size();
    }

    public AlgorithmStep getStep(int n) throws IndexOutOfBoundsException {
        return this.steps.get(n);
    }

    public AlgorithmStep getStepByID(int n) {
        return this.stepsByID.get(n);
    }

    public int getExecutingStepID() {
        return this.executingStepID;
    }

    public void setExecutingStepID(int n) {
        this.executingStepID = n;
        this.fireExecutingStepChanged();
    }

    public int getFirstStepID() {
        return this.steps.size() > 0 ? this.steps.get(0).getID() : -1;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f) throws IllegalArgumentException {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.fontSize = f;
        for (AlgorithmStep algorithmStep : this.steps) {
            for (int i = 0; i < algorithmStep.getFormulaCount(); ++i) {
                algorithmStep.getFormula(i).updateFormula();
            }
        }
    }

    public AlgorithmExercise<?> getFinalExercise() {
        return this.finalExercise;
    }

    public void setFinalExercise(AlgorithmExercise<?> algorithmExercise) {
        this.finalExercise = algorithmExercise;
    }

    public AlgorithmText getBaseCopy() {
        AlgorithmText algorithmText = new AlgorithmText();
        for (AlgorithmParagraph object : this.paragraphs) {
            new AlgorithmParagraph(algorithmText, object.getName(), object.getID());
        }
        for (AlgorithmStep algorithmStep : this.steps) {
            new AlgorithmStep(algorithmText.getParagraphByID(algorithmStep.getParagraph().getID()), algorithmStep.getText(), algorithmStep.getID(), algorithmStep.getIndent());
        }
        return algorithmText;
    }

    void addParagraph(AlgorithmParagraph algorithmParagraph) throws InvalidIdentifierException {
        if (algorithmParagraph == null) {
            return;
        }
        if (this.paragraphsByID.containsKey(algorithmParagraph.getID())) {
            throw new InvalidIdentifierException("id of paragraph is already existing");
        }
        this.paragraphs.add(algorithmParagraph);
        this.paragraphsByID.put(algorithmParagraph.getID(), algorithmParagraph);
        this.fireStructureChanged();
    }

    void addStep(AlgorithmStep algorithmStep) throws InvalidIdentifierException {
        if (algorithmStep == null) {
            return;
        }
        if (this.stepsByID.containsKey(algorithmStep.getID())) {
            throw new InvalidIdentifierException("id of step is already existing");
        }
        this.steps.add(algorithmStep);
        this.stepsByID.put(algorithmStep.getID(), algorithmStep);
    }

    void fireStructureChanged() {
        for (AlgorithmTextListener algorithmTextListener : this.listeners) {
            algorithmTextListener.structureChanged();
        }
    }

    void fireExecutingStepChanged() {
        for (AlgorithmTextListener algorithmTextListener : this.listeners) {
            algorithmTextListener.executingStepChanged();
        }
    }
}

