/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.text;

import java.util.ArrayList;
import java.util.List;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.Annotation;
import lavesdk.algorithm.text.LaTeXFormula;
import lavesdk.algorithm.text.exceptions.InvalidIdentifierException;
import lavesdk.algorithm.text.exceptions.InvalidLaTeXFormulaException;
import lavesdk.utils.FileUtils;
import org.scilab.forge.jlatexmath.ParseException;

public class AlgorithmStep {
    private final AlgorithmParagraph paragraph;
    private final String text;
    private final List<LaTeXFormula> formulas;
    private final int id;
    private final int indent;
    private boolean hasBreakpoint;
    private AlgorithmExercise<?> exercise;
    private Annotation annotation;
    private final List<TextToken> textTokens;
    private static final String LATEX_FORMULA_FUNC = "_latex";
    private static final String LATEX_FORMULA_BEGIN = "{";
    private static final String LATEX_FORMULA_END = "}";
    private static final String LATEX_FUNC_PARAM_OPEN = "(";
    private static final String LATEX_FUNC_PARAM_CLOSE = ")";
    private static final String LATEX_TAG_BEGIN = "_lF(";
    private static final String LATEX_TAG_END = ")_";

    public AlgorithmStep(AlgorithmParagraph algorithmParagraph, String string, int n) throws IllegalArgumentException, InvalidIdentifierException, InvalidLaTeXFormulaException {
        this(algorithmParagraph, string, n, 0);
    }

    public AlgorithmStep(AlgorithmParagraph algorithmParagraph, String string, int n, int n2) throws IllegalArgumentException, InvalidIdentifierException, InvalidLaTeXFormulaException {
        if (algorithmParagraph == null || string == null || n < 1 || n2 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.paragraph = algorithmParagraph;
        this.text = string;
        this.formulas = new ArrayList<LaTeXFormula>(3);
        this.id = n;
        this.indent = n2;
        this.hasBreakpoint = false;
        this.exercise = null;
        this.annotation = null;
        this.textTokens = new ArrayList<TextToken>();
        algorithmParagraph.addStep(this);
        this.createTokenizedText();
    }

    public final AlgorithmParagraph getParagraph() {
        return this.paragraph;
    }

    public final String getText() {
        return this.text;
    }

    public final int getTextTokenCount() {
        return this.textTokens.size();
    }

    public final TextToken getTextToken(int n) throws IndexOutOfBoundsException {
        return this.textTokens.get(n);
    }

    public int getFormulaCount() {
        return this.formulas.size();
    }

    public LaTeXFormula getFormula(int n) throws IndexOutOfBoundsException {
        return this.formulas.get(n);
    }

    public final int getID() {
        return this.id;
    }

    public final int getIndent() {
        return this.indent;
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint;
    }

    public void setBreakpoint(boolean bl) {
        this.hasBreakpoint = bl;
    }

    public AlgorithmExercise<?> getExercise() {
        return this.exercise;
    }

    public void setExercise(AlgorithmExercise<?> algorithmExercise) {
        this.exercise = algorithmExercise;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public String toString() {
        return this.text;
    }

    private void createTokenizedText() throws InvalidLaTeXFormulaException {
        int n;
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        this.textTokens.clear();
        String string2 = this.parseFormulas(this.text).replaceAll(FileUtils.LINESEPARATOR, "\n");
        for (n = 0; n < string2.length(); ++n) {
            char c;
            char c2 = string2.charAt(n);
            char c3 = c = n < string2.length() - 1 ? (char)string2.charAt(n + 1) : (char)' ';
            if (c2 == '\n') {
                if (!string.isEmpty()) {
                    arrayList.add(string);
                }
                arrayList.add("\n");
                string = "";
                bl = false;
                continue;
            }
            if (Character.isWhitespace(c2) && !Character.isWhitespace(c) && bl) {
                arrayList.add(string + c2);
                string = "";
                bl = false;
                continue;
            }
            if (c2 == LATEX_TAG_BEGIN.charAt(0) && string2.indexOf(LATEX_TAG_BEGIN, n) >= 0) {
                int n2 = string2.indexOf(LATEX_TAG_END, n);
                if (n2 < 0) {
                    throw new ParseException("text \"" + string2 + "\" cannot be divided into token at position " + n + " (no valid latex tag)");
                }
                if (!string.isEmpty()) {
                    arrayList.add(string);
                }
                string = string2.substring(n, n2 + LATEX_TAG_END.length());
                arrayList.add(string);
                string = "";
                bl = false;
                n = n2 + LATEX_TAG_END.length() - 1;
                continue;
            }
            string = string + c2;
            bl = bl || !Character.isWhitespace(c2);
        }
        if (!string.isEmpty()) {
            arrayList.add(string);
        }
        for (String string3 : arrayList) {
            if (string3.contains("\n")) {
                this.textTokens.add(new TextToken(TextTokenType.LINEBREAK, null, null));
                continue;
            }
            if (string3.startsWith(LATEX_TAG_BEGIN) && string3.endsWith(LATEX_TAG_END)) {
                try {
                    n = new Integer(string3.substring(LATEX_TAG_BEGIN.length(), string3.length() - LATEX_TAG_END.length()));
                    this.textTokens.add(new TextToken(TextTokenType.FORMULA, null, this.getFormula(n)));
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    this.textTokens.add(new TextToken(TextTokenType.STRING, string3, null));
                }
                continue;
            }
            this.textTokens.add(new TextToken(TextTokenType.STRING, string3, null));
        }
    }

    private String parseFormulas(String string) throws InvalidLaTeXFormulaException {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = -1;
        this.formulas.clear();
        while ((n = stringBuilder.indexOf(LATEX_FORMULA_FUNC, n)) >= 0) {
            int n2 = stringBuilder.indexOf(LATEX_FORMULA_BEGIN, n + LATEX_FORMULA_FUNC.length());
            int n3 = stringBuilder.indexOf(LATEX_FORMULA_END, n);
            int n4 = n2 + LATEX_FORMULA_BEGIN.length();
            while ((n4 = stringBuilder.indexOf(LATEX_FORMULA_BEGIN, n4 + 1)) < n3 && n4 >= 0) {
                n3 = stringBuilder.indexOf(LATEX_FORMULA_END, n3 + 1);
            }
            if (n3 < 0) break;
            String string2 = stringBuilder.substring(n + LATEX_FORMULA_FUNC.length(), n2).trim();
            string2 = string2.startsWith(LATEX_FUNC_PARAM_OPEN) && string2.endsWith(LATEX_FUNC_PARAM_CLOSE) ? string2.substring(LATEX_FUNC_PARAM_OPEN.length(), string2.length() - LATEX_FUNC_PARAM_CLOSE.length()) : "";
            String string3 = stringBuilder.substring(n2 + LATEX_FORMULA_BEGIN.length(), n3 - LATEX_FORMULA_BEGIN.length() + 1);
            this.formulas.add(new LaTeXFormula(this, string3, string2));
            stringBuilder.replace(n, n3 + 1, LATEX_TAG_BEGIN + (this.formulas.size() - 1) + LATEX_TAG_END);
        }
        return stringBuilder.toString();
    }

    public class TextToken {
        public final TextTokenType type;
        public final String string;
        public final LaTeXFormula formula;

        private TextToken(TextTokenType textTokenType, String string, LaTeXFormula laTeXFormula) throws IllegalArgumentException {
            if (textTokenType == null || textTokenType == TextTokenType.STRING && string == null || textTokenType == TextTokenType.FORMULA && laTeXFormula == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.type = textTokenType;
            this.string = string;
            this.formula = laTeXFormula;
        }

        public String toString() {
            if (this.type == TextTokenType.STRING) {
                return this.string;
            }
            return this.formula.toString();
        }
    }

    public static enum TextTokenType {
        STRING,
        FORMULA,
        LINEBREAK;

    }
}

