/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.text;

import java.util.ArrayList;
import java.util.List;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.exceptions.InvalidIdentifierException;

public class AlgorithmParagraph {
    private final List<AlgorithmStep> steps;
    private final AlgorithmText parent;
    private final String name;
    private final int id;

    public AlgorithmParagraph(AlgorithmText algorithmText, String string, int n) throws IllegalArgumentException, InvalidIdentifierException {
        if (algorithmText == null || string == null || n < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.steps = new ArrayList<AlgorithmStep>(5);
        this.parent = algorithmText;
        this.name = string;
        this.id = n;
        algorithmText.addParagraph(this);
    }

    public final AlgorithmText getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public final int getID() {
        return this.id;
    }

    public int getStepCount() {
        return this.steps.size();
    }

    public AlgorithmStep getStep(int n) throws IndexOutOfBoundsException {
        return this.steps.get(n);
    }

    public String toString() {
        return this.name;
    }

    void addStep(AlgorithmStep algorithmStep) throws InvalidIdentifierException {
        if (algorithmStep == null || this.steps.contains(algorithmStep)) {
            return;
        }
        this.parent.addStep(algorithmStep);
        this.steps.add(algorithmStep);
        this.parent.fireStructureChanged();
    }
}

