/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import lavesdk.algorithm.plugin.views.renderers.VertexRenderer;
import lavesdk.math.graph.Vertex;

public class DefaultVertexRenderer<T extends Vertex>
implements VertexRenderer<T> {
    protected final Ellipse2D.Float circle = new Ellipse2D.Float();
    protected Color background = Color.white;
    protected Color foreground = Color.black;
    protected int xCenter = 0;
    protected int yCenter = 0;
    protected Font font = null;
    protected int edgeWidth = 1;
    protected Stroke edgeStroke = new BasicStroke(this.edgeWidth);

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
    }

    @Override
    public void draw(Graphics2D graphics2D, T t) {
        graphics2D.setColor(this.background);
        graphics2D.fill(this.circle);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.foreground);
        graphics2D.setStroke(this.edgeStroke);
        graphics2D.draw(this.circle);
        graphics2D.setStroke(stroke);
        if (this.font != null) {
            graphics2D.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawString(((Vertex)t).getCaption(), this.xCenter - fontMetrics.stringWidth(((Vertex)t).getCaption()) / 2 + 1, this.yCenter + fontMetrics.getAscent() / 2 + fontMetrics.getLeading());
    }

    @Override
    public void setPositionLeftTop(int n, int n2) {
        this.circle.x = n;
        this.circle.y = n2;
    }

    @Override
    public void setPositionCenter(int n, int n2) {
        this.xCenter = n;
        this.yCenter = n2;
    }

    @Override
    public void setDiameter(int n) {
        this.circle.width = this.circle.height = (float)n;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setEdgeWidth(int n) {
        if (n != this.edgeWidth) {
            this.edgeWidth = n;
            this.edgeStroke = new BasicStroke(this.edgeWidth);
        }
    }

    @Override
    public void setAttachmentPoint(int n, int n2) {
    }
}

