/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.Serializable;
import lavesdk.algorithm.plugin.views.renderers.EdgeRenderer;
import lavesdk.graphics.CatmullRomSpline;
import lavesdk.math.graph.Edge;

public class DefaultEdgeRenderer<T extends Edge>
implements EdgeRenderer<T> {
    protected boolean paintLabels;
    protected CatmullRomSpline spline;
    protected Color foreground;
    protected Font font;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected int labelX;
    protected int labelY;
    protected boolean drawArrow;
    protected int lineWidth;
    protected Stroke lineStroke;
    protected int arrowLength;

    public DefaultEdgeRenderer() {
        this(true);
    }

    public DefaultEdgeRenderer(boolean bl) {
        this.paintLabels = bl;
        this.spline = null;
        this.foreground = Color.black;
        this.font = null;
        this.x1 = 0;
        this.y1 = 0;
        this.x2 = 0;
        this.y2 = 0;
        this.labelX = 0;
        this.labelY = 0;
        this.drawArrow = false;
        this.lineWidth = 1;
        this.lineStroke = new BasicStroke(this.lineWidth);
        this.arrowLength = 5;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void draw(Graphics2D graphics2D, T t) {
        Serializable serializable;
        graphics2D.setColor(this.foreground);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.lineStroke);
        graphics2D.draw(this.spline.getPath());
        if (this.drawArrow) {
            serializable = this.spline.getPoints()[this.spline.getPoints().length / 2 - 1];
            Point2D.Float float_ = this.spline.getPoints()[this.spline.getPoints().length - 1];
            float f = float_.x - ((Point2D.Float)serializable).x;
            float f2 = float_.y - ((Point2D.Float)serializable).y;
            double d = Math.sqrt(f * f + f2 * f2);
            int n = (int)((double)f / d * (double)this.arrowLength);
            int n2 = (int)((double)f2 / d * (double)this.arrowLength);
            graphics2D.drawLine(this.x2, this.y2, this.x2 - n - n2, this.y2 - n2 + n);
            graphics2D.drawLine(this.x2, this.y2, this.x2 - n + n2, this.y2 - n2 - n);
        }
        if (this.paintLabels) {
            if (this.font != null) {
                graphics2D.setFont(this.font);
            }
            serializable = graphics2D.getFontMetrics();
            graphics2D.drawString(((Edge)t).toString(), this.y1 < this.y2 ? this.labelX - ((FontMetrics)serializable).stringWidth(((Edge)t).toString()) : this.labelX + 2, this.x1 < this.x2 ? this.labelY + ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getLeading() : this.labelY - 2);
        }
        graphics2D.setStroke(stroke);
    }

    @Override
    public void setFirstPosition(int n, int n2) {
        this.x1 = n;
        this.y1 = n2;
    }

    @Override
    public void setSecondPosition(int n, int n2) {
        this.x2 = n;
        this.y2 = n2;
    }

    @Override
    public void setControlPosition(int n, int n2) {
    }

    @Override
    public void setDrawArrow(boolean bl) {
        this.drawArrow = bl;
    }

    @Override
    public void setLineWidth(int n) {
        if (n != this.lineWidth) {
            this.lineWidth = n;
            this.lineStroke = new BasicStroke(this.lineWidth);
        }
    }

    @Override
    public void setSpline(CatmullRomSpline catmullRomSpline) {
        this.spline = catmullRomSpline;
    }

    @Override
    public void setArrowLength(int n) {
        this.arrowLength = n;
    }

    @Override
    public void setLabelPosition(int n, int n2) {
        this.labelX = n;
        this.labelY = n2;
    }
}

