/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views.custom;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import lavesdk.algorithm.plugin.views.custom.CustomVisualObject;
import lavesdk.gui.widgets.Symbol;

public class CustomVisualFormula
extends CustomVisualObject {
    protected String expression;
    protected Symbol formula;
    private float lastFontSize;

    public CustomVisualFormula(String string, int n, int n2) throws IllegalArgumentException {
        super(n, n2, 0, 0, Color.white, Color.black);
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.expression = string;
        this.lastFontSize = 8.0f;
        this.formula = Symbol.createLaTeXSymbol(string, this.lastFontSize);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.expression = string;
        this.formula = Symbol.createLaTeXSymbol(string, this.lastFontSize);
    }

    @Override
    public int getWidth() {
        return this.formula.getIconWidth();
    }

    @Override
    public int getHeight() {
        return this.formula.getIconHeight();
    }

    @Override
    public void draw(Graphics2D graphics2D, Font font) {
        if (font.getSize2D() != this.lastFontSize) {
            this.lastFontSize = font.getSize2D();
            this.formula = Symbol.createLaTeXSymbol(this.expression, this.lastFontSize);
        }
        graphics2D.setColor(this.foreground);
        this.formula.paintIcon(null, graphics2D, this.x, this.y);
    }
}

