/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.language.LanguageFile;

public abstract class ViewHeaderBarExtension {
    protected final View view;
    protected final boolean separated;
    protected final LanguageFile langFile;
    protected final String langID;
    private final List<JComponent> components;

    public ViewHeaderBarExtension(View view, boolean bl, LanguageFile languageFile, String string) throws IllegalArgumentException {
        if (view == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.view = view;
        this.separated = bl;
        this.langFile = languageFile;
        this.langID = string;
        this.components = new ArrayList<JComponent>(3);
    }

    public final void apply() {
        this.createExtension();
        if (this.separated) {
            this.addSeparator();
        }
    }

    public final void remove() {
        for (JComponent jComponent : this.components) {
            this.view.removeHeaderBarComponent(jComponent);
        }
        this.components.clear();
    }

    protected abstract void createExtension();

    protected final void addComponent(JComponent jComponent) throws IllegalArgumentException {
        if (jComponent == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.view.addHeaderBarComponent(jComponent);
        this.components.add(jComponent);
    }

    protected final void addSeparator() {
        this.addComponent(new JToolBar.Separator());
    }
}

