/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.serialization.Serializer;

public final class ViewGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final int orientation;
    private final int padding;
    private final EventController eventController;
    private final List<GroupComponent> components;
    private final List<GroupComponent> visibleComponentsCache;
    private final List<Sash> visibleSashs;
    private float[] weights;
    private float[] visibleWeights;
    private boolean redefineVisibleComponents;
    private boolean redefineVisibleWeights;
    private Sash draggedSash;
    private Point mousePos;
    private final Cursor cursor;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public ViewGroup(int n) throws IllegalArgumentException {
        this(n, 0);
    }

    public ViewGroup(int n, int n2) throws IllegalArgumentException {
        if (!ViewGroup.checkOrientation(n)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.orientation = n;
        this.padding = n2 > 0 ? n2 : 0;
        this.eventController = new EventController();
        this.components = new ArrayList<GroupComponent>();
        this.visibleComponentsCache = new ArrayList<GroupComponent>();
        this.visibleSashs = new ArrayList<Sash>();
        this.weights = null;
        this.visibleWeights = null;
        this.redefineVisibleComponents = true;
        this.redefineVisibleWeights = true;
        this.draggedSash = null;
        this.mousePos = null;
        this.cursor = Cursor.getPredefinedCursor(n == 0 ? 11 : 8);
        super.setLayout(null);
        this.addComponentListener(this.eventController);
        this.addMouseListener(this.eventController);
        this.addMouseMotionListener(this.eventController);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public float[] getWeights() {
        if (EDT.isExecutedInEDT()) {
            return (float[])this.weights.clone();
        }
        return EDT.execute(new GuiRequest<float[]>(){

            @Override
            protected float[] execute() throws Throwable {
                return (float[])ViewGroup.this.weights.clone();
            }
        });
    }

    public void setWeights(final float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (fArray.length != this.components.size()) {
            throw new IllegalArgumentException("Amount of weights must match to the amount of components!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSetWeights(fArray);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setWeights"){

                @Override
                protected void execute() throws Throwable {
                    ViewGroup.this.internalSetWeights(fArray);
                }
            });
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    public void storeWeights(Serializer serializer, String string) throws IllegalArgumentException {
        if (serializer == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Serializable[] serializableArray = new Float[this.weights.length];
        for (int i = 0; i < serializableArray.length; ++i) {
            serializableArray[i] = Float.valueOf(this.weights[i]);
        }
        serializer.addArray(string, serializableArray);
    }

    public void restoreWeights(Serializer serializer, String string, float[] fArray) throws IllegalArgumentException {
        if (serializer == null || fArray == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Float[] floatArray = (Float[])serializer.getArray(string);
        if (floatArray == null) {
            this.setWeights(fArray);
        } else {
            float[] fArray2 = new float[floatArray.length];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = floatArray[i].floatValue();
            }
            this.setWeights(fArray2);
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void doLayout() {
        int n = 2 * this.padding;
        if (this.redefineVisibleComponents) {
            this.requestVisibleComponents();
        }
        this.setVisible(this.visibleComponentsCache.size() > 0);
        if (!this.isVisible()) {
            return;
        }
        if (this.redefineVisibleComponents || this.redefineVisibleWeights || this.visibleWeights == null) {
            this.visibleWeights = this.getVisibleWeights();
        }
        if (this.orientation == 0) {
            int n2 = this.getWidth() - this.visibleSashs.size() * 5 - n;
            int n3 = this.padding;
            for (int i = 0; i < this.visibleComponentsCache.size() - 1; ++i) {
                int n4 = (int)((float)n2 * this.visibleWeights[i]);
                this.visibleComponentsCache.get(i).setBounds(n3, this.padding, n4, this.getHeight() - n);
                n3 += n4 + 5;
            }
            this.visibleComponentsCache.get(this.visibleComponentsCache.size() - 1).setBounds(n3, this.padding, this.getWidth() - this.padding - n3, this.getHeight() - n);
        } else {
            int n5 = this.getHeight() - this.visibleSashs.size() * 5 - n;
            int n6 = this.padding;
            for (int i = 0; i < this.visibleComponentsCache.size() - 1; ++i) {
                int n7 = (int)((float)n5 * this.visibleWeights[i]);
                this.visibleComponentsCache.get(i).setBounds(this.padding, n6, this.getWidth() - n, n7);
                n6 += n7 + 5;
            }
            this.visibleComponentsCache.get(this.visibleComponentsCache.size() - 1).setBounds(this.padding, n6, this.getWidth() - n, this.getHeight() - this.padding - n6);
        }
        this.redefineVisibleComponents = false;
        this.redefineVisibleWeights = false;
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        this.components.get(n).getComponent().removeComponentListener(this.eventController);
        this.components.remove(n);
        for (int i = n; i < this.components.size(); ++i) {
            this.components.get(i).setIndex(i);
        }
        this.weights = null;
        this.redefineVisibleComponents = true;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (n >= 0) {
            this.components.add(n, new GroupComponent(component));
            for (int i = n; i < this.components.size(); ++i) {
                this.components.get(i).setIndex(i);
            }
        } else {
            GroupComponent groupComponent = new GroupComponent(component);
            groupComponent.setIndex(this.components.size());
            this.components.add(groupComponent);
        }
        this.weights = null;
        this.redefineVisibleComponents = true;
        component.addComponentListener(this.eventController);
    }

    private static boolean checkOrientation(int n) {
        return n == 0 || n == 1;
    }

    private void mouseDown(MouseEvent mouseEvent) {
        this.mousePos = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.draggedSash = this.getSashFromPosition(this.mousePos.x, this.mousePos.y);
    }

    private void mouseUp(MouseEvent mouseEvent) {
        this.draggedSash = null;
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        if (this.mousePos == null || this.draggedSash == null) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.orientation == 0) {
            this.draggedSash.moveHorizontal(point.x - this.mousePos.x);
        } else {
            this.draggedSash.moveVertical(point.y - this.mousePos.y);
        }
        this.mousePos = point;
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        if (this.draggedSash != null) {
            return;
        }
        if (this.getSashFromPosition(mouseEvent.getX(), mouseEvent.getY()) != null) {
            super.setCursor(this.cursor);
        } else {
            super.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void createDefaultWeights() {
        this.weights = new float[this.components.size()];
        float f = 1.0f / (float)this.weights.length;
        float f2 = 0.0f;
        for (int i = 0; i < this.weights.length - 1; ++i) {
            this.weights[i] = f;
            f2 += f;
        }
        this.weights[this.weights.length - 1] = 1.0f - f2;
    }

    private void requestVisibleComponents() {
        this.visibleComponentsCache.clear();
        this.visibleSashs.clear();
        for (GroupComponent groupComponent : this.components) {
            if (!groupComponent.isVisible()) continue;
            this.visibleComponentsCache.add(groupComponent);
        }
        for (int i = 1; i < this.visibleComponentsCache.size(); ++i) {
            this.visibleSashs.add(new Sash(this.visibleComponentsCache.get(i - 1), this.visibleComponentsCache.get(i)));
        }
    }

    private float[] getVisibleWeights() {
        float[] fArray = new float[this.visibleComponentsCache.size()];
        if (fArray.length < 1) {
            return fArray;
        }
        if (this.weights == null) {
            this.createDefaultWeights();
        }
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            GroupComponent groupComponent = this.components.get(i);
            if (groupComponent.isVisible()) {
                fArray[n] = this.weights[i];
                ++n;
                continue;
            }
            f += this.weights[i];
        }
        float f2 = f / (float)fArray.length;
        float f3 = 0.0f;
        for (int i = 0; i < fArray.length - 1; ++i) {
            int n2 = i;
            fArray[n2] = fArray[n2] + f2;
            f3 += fArray[i];
        }
        fArray[fArray.length - 1] = 1.0f - f3;
        return fArray;
    }

    private void adjustWeights() {
        int n;
        int n2;
        float f;
        int n3;
        if (this.visibleComponentsCache.size() < 1) {
            return;
        }
        if (this.orientation == 0) {
            n3 = this.getWidth() - this.visibleSashs.size() * 5;
            f = 0.0f;
            for (n2 = 0; n2 < this.visibleComponentsCache.size() - 1; ++n2) {
                this.visibleWeights[n2] = (float)this.visibleComponentsCache.get((int)n2).getSize().width / (float)n3;
                f += this.visibleWeights[n2];
            }
            if (this.visibleWeights.length > 0) {
                this.visibleWeights[this.visibleWeights.length - 1] = 1.0f - f;
            }
        } else {
            n3 = this.getHeight() - this.visibleSashs.size() * 5;
            f = 0.0f;
            for (n2 = 0; n2 < this.visibleComponentsCache.size() - 1; ++n2) {
                this.visibleWeights[n2] = (float)this.visibleComponentsCache.get((int)n2).getSize().height / (float)n3;
                f += this.visibleWeights[n2];
            }
            if (this.visibleWeights.length > 0) {
                this.visibleWeights[this.visibleWeights.length - 1] = 1.0f - f;
            }
        }
        float f2 = 0.0f;
        for (int i = 1; i < this.visibleComponentsCache.size(); ++i) {
            GroupComponent groupComponent = this.visibleComponentsCache.get(i - 1);
            float f3 = this.visibleWeights[i - 1];
            GroupComponent groupComponent2 = this.visibleComponentsCache.get(i);
            float f4 = this.visibleWeights[i];
            for (n = groupComponent.getIndex() + 1; n <= groupComponent2.getIndex() - 1; ++n) {
                f2 += this.weights[n];
            }
            float f5 = f2 != 0.0f ? f2 / 2.0f : 0.0f;
            this.weights[groupComponent.getIndex()] = f3 - f5;
            this.weights[groupComponent2.getIndex()] = f4 - f5;
        }
        float f6 = 0.0f;
        for (n = 0; n < this.weights.length - 1; ++n) {
            f6 += this.weights[n];
        }
        if (this.weights.length > 0) {
            this.weights[this.weights.length - 1] = 1.0f - f6;
        }
    }

    private Sash getSashFromPosition(int n, int n2) {
        for (Sash sash : this.visibleSashs) {
            if (this.orientation == 0 && n >= sash.getX() && n <= sash.getX() + 5) {
                return sash;
            }
            if (this.orientation != 1 || n2 < sash.getY() || n2 > sash.getY() + 5) continue;
            return sash;
        }
        return null;
    }

    private void internalSetWeights(float[] fArray) throws IllegalArgumentException {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        if (f != 1.0f) {
            throw new IllegalArgumentException("The sum of weights is not 1! Ensure that the total of weights is always 1!");
        }
        this.weights = fArray;
        this.redefineVisibleWeights = true;
        this.validate();
    }

    private class EventController
    implements ComponentListener,
    MouseListener,
    MouseMotionListener {
        private EventController() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ViewGroup.this.redefineVisibleComponents = true;
            ViewGroup.this.revalidate();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() != ViewGroup.this) {
                return;
            }
            ViewGroup.this.validate();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ViewGroup.this.redefineVisibleComponents = true;
            ViewGroup.this.revalidate();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (ViewGroup.this.draggedSash == null) {
                ViewGroup.super.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ViewGroup.this.mouseDown(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ViewGroup.this.mouseUp(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ViewGroup.this.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ViewGroup.this.mouseMoved(mouseEvent);
        }
    }

    private final class Sash {
        public final GroupComponent firstComponent;
        public final GroupComponent secondComponent;
        public static final int SIZE = 5;

        public Sash(GroupComponent groupComponent, GroupComponent groupComponent2) throws IllegalArgumentException {
            if (groupComponent == null || groupComponent2 == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.firstComponent = groupComponent;
            this.secondComponent = groupComponent2;
        }

        public int getX() {
            if (ViewGroup.this.orientation == 0) {
                return this.secondComponent.getX() - 5;
            }
            return 0;
        }

        public int getY() {
            if (ViewGroup.this.orientation == 0) {
                return 0;
            }
            return this.secondComponent.getY() - 5;
        }

        public void moveHorizontal(int n) {
            Dimension dimension = this.firstComponent.getSize();
            Dimension dimension2 = this.secondComponent.getSize();
            Point point = this.secondComponent.getLocation();
            if (dimension.width + n < 0 || dimension2.width - n < 0) {
                n = 0;
            }
            this.firstComponent.setSize(dimension.width + n, dimension.height);
            this.secondComponent.setBounds(point.x + n, point.y, dimension2.width - n, dimension2.height);
            ViewGroup.this.adjustWeights();
            this.firstComponent.validate();
            this.secondComponent.validate();
        }

        public void moveVertical(int n) {
            Dimension dimension = this.firstComponent.getSize();
            Dimension dimension2 = this.secondComponent.getSize();
            Point point = this.secondComponent.getLocation();
            if (dimension.height + n < 0 || dimension2.height - n < 0) {
                n = 0;
            }
            this.firstComponent.setSize(dimension.width, dimension.height + n);
            this.secondComponent.setBounds(point.x, point.y + n, dimension2.width, dimension2.height - n);
            ViewGroup.this.adjustWeights();
            this.firstComponent.validate();
            this.secondComponent.validate();
        }
    }

    private final class GroupComponent {
        private final Component component;
        private int x;
        private int y;
        private Dimension size;
        private int index;

        public GroupComponent(Component component) throws IllegalArgumentException {
            if (component == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.component = component;
            this.x = component.getX();
            this.y = component.getY();
            this.size = component.getSize();
            this.index = -1;
        }

        public final Component getComponent() {
            return this.component;
        }

        public final int getIndex() {
            return this.index;
        }

        public boolean isVisible() {
            return this.component.isVisible();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Point getLocation() {
            return new Point(this.x, this.y);
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) throws IllegalArgumentException {
            if (dimension == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.size = dimension;
            this.setBounds(this.x, this.y, dimension.width, dimension.height);
        }

        public void setSize(int n, int n2) {
            this.setSize(new Dimension(n, n2));
        }

        public void setBounds(Rectangle rectangle) throws IllegalArgumentException {
            if (rectangle == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.size = new Dimension(rectangle.width, rectangle.height);
            this.component.setBounds(this.x, this.y, this.size.width, this.size.height);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.setBounds(new Rectangle(n, n2, n3, n4));
        }

        public void validate() {
            this.component.validate();
        }

        void setIndex(int n) {
            this.index = n;
        }
    }
}

