/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewGroup;

public final class ViewContainer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Border paddingBorder;
    private static final int DEF_PADDING = 5;

    public ViewContainer() {
        this(5);
    }

    public ViewContainer(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.paddingBorder = n > 0 ? BorderFactory.createEmptyBorder(n, n, n, n) : null;
        super.setLayout(null);
        super.setBorder(this.paddingBorder);
    }

    @Override
    public void setBorder(Border border) {
        if (this.paddingBorder != null) {
            super.setBorder(border != null ? BorderFactory.createCompoundBorder(border, this.paddingBorder) : this.paddingBorder);
        } else {
            super.setBorder(border);
        }
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component instanceof View) {
            ((View)component).beforeRemove();
        }
        super.remove(n);
    }

    public List<View> queryAllViews() {
        ArrayList<View> arrayList = new ArrayList<View>();
        this.queryAllViews(this, arrayList);
        return arrayList;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof ViewGroup) && !(component instanceof View)) {
            return;
        }
        super.addImpl(component, object, n);
    }

    private void queryAllViews(Container container, List<View> list) {
        for (Component component : container.getComponents()) {
            if (component instanceof View) {
                list.add((View)component);
            }
            if (!(component instanceof Container)) continue;
            this.queryAllViews((Container)component, list);
        }
    }
}

