/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import lavesdk.configuration.Configuration;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BaseComponent;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public abstract class View
extends BaseComponent {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final boolean closable;
    private final JToolBar headerBar;
    private final JLabel titleLbl;
    private final JButton closeBtn;
    protected final LanguageFile langFile;
    protected final String langID;
    protected final JPanel content;
    private final EventController eventController;
    private boolean initialized;
    private boolean autoRepaint;
    private static final Color DEF_HIGHLIGHT = new Color(105, 155, 215);

    public View(String string) throws IllegalArgumentException {
        this(string, true);
    }

    public View(String string, boolean bl) throws IllegalArgumentException {
        this(string, bl, null, null);
    }

    public View(String string, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.title = string;
        this.closable = bl;
        this.headerBar = new JToolBar(0);
        this.titleLbl = new JLabel(string);
        this.closeBtn = new JButton(Resources.getInstance().CLOSE_ICON);
        this.langFile = languageFile;
        this.langID = string2;
        this.content = new JPanel();
        this.eventController = new EventController();
        this.autoRepaint = false;
        this.titleLbl.setVerticalAlignment(0);
        this.titleLbl.setVerticalTextPosition(0);
        this.closeBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.closeBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "VIEW_CLOSE_TOOLTIP", string2, "Close") + "</html>");
        this.closeBtn.setVisible(bl);
        super.setLayout(new BorderLayout());
        this.headerBar.setFloatable(false);
        this.headerBar.add(this.titleLbl);
        this.headerBar.add(Box.createHorizontalGlue());
        this.headerBar.add(this.closeBtn);
        this.add((Component)this.headerBar, "North");
        this.add((Component)this.content, "Center");
        this.closeBtn.addMouseListener(this.eventController);
        this.closeBtn.addActionListener(this.eventController);
        this.setFocusable(true);
        this.initialized = true;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void extendTitle(final String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.titleLbl.setText(this.title + string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".extendTitle"){

                @Override
                protected void execute() throws Throwable {
                    View.this.titleLbl.setText(View.this.title + string);
                }
            });
        }
    }

    public final boolean isClosable() {
        return this.closable;
    }

    public final JPanel getContentPanel() {
        return this.content;
    }

    public final void loadConfiguration(Configuration configuration) {
        this.loadConfiguration(configuration, "VIEW_" + this.title);
    }

    public final void loadConfiguration(Configuration configuration, String string) {
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = configuration.getConfiguration(string);
        if (configuration2 == null) {
            return;
        }
        this.readConfigurationData(configuration2);
    }

    public final void saveConfiguration(Configuration configuration) {
        this.saveConfiguration(configuration, "VIEW_" + this.title);
    }

    public final void saveConfiguration(Configuration configuration, String string) {
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = new Configuration();
        this.writeConfigurationData(configuration2);
        configuration.addConfiguration(string, configuration2);
    }

    public abstract void reset();

    public void highlight(boolean bl) {
        this.highlight(bl, DEF_HIGHLIGHT);
    }

    public void highlight(final boolean bl, final Color color) {
        if (EDT.isExecutedInEDT()) {
            super.setBorder(bl ? BorderFactory.createMatteBorder(2, 2, 2, 2, color == null ? DEF_HIGHLIGHT : color) : null);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".highlight"){

                @Override
                protected void execute() throws Throwable {
                    View.super.setBorder(bl ? BorderFactory.createMatteBorder(2, 2, 2, 2, color == null ? DEF_HIGHLIGHT : color) : null);
                }
            });
        }
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public boolean isVisible() {
        if (EDT.isExecutedInEDT()) {
            return super.isVisible();
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return View.super.isVisible();
            }
        });
    }

    @Override
    public void setVisible(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            super.setVisible(bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setVisible"){

                @Override
                protected void execute() throws Throwable {
                    View.super.setVisible(bl);
                }
            });
        }
    }

    @Override
    public String toString() {
        return View.class.getSimpleName() + "[" + this.title + "]";
    }

    @Override
    protected final void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    protected boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    protected void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    protected void autoRepaint() {
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    protected void readConfigurationData(Configuration configuration) {
        this.setVisible(configuration.getBoolean("visible", true));
    }

    protected void writeConfigurationData(Configuration configuration) {
        configuration.addBoolean("visible", this.isVisible());
    }

    protected final void addHeaderBarComponent(JComponent jComponent) throws IllegalArgumentException {
        if (jComponent == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.headerBar.add((Component)jComponent, this.headerBar.getComponentCount() - 1);
        this.headerBar.repaint();
    }

    protected final void addHeaderBarSeparator() {
        this.addHeaderBarComponent(new JToolBar.Separator());
    }

    protected final void removeHeaderBarComponent(JComponent jComponent) throws IllegalArgumentException {
        if (jComponent == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.headerBar.remove(jComponent);
        this.headerBar.repaint();
    }

    protected final void setCloseButtonToolTip(String string) {
        this.closeBtn.setToolTipText(string);
    }

    protected void close() {
        super.setVisible(false);
    }

    protected void beforeRemove() {
    }

    private class EventController
    implements MouseListener,
    ActionListener {
        private EventController() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() == View.this.closeBtn) {
                View.this.closeBtn.setIcon(Resources.getInstance().CLOSE_HOVER_ICON);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() == View.this.closeBtn) {
                View.this.closeBtn.setIcon(Resources.getInstance().CLOSE_ICON);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == View.this.closeBtn) {
                View.this.close();
            }
        }
    }
}

