/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import lavesdk.algorithm.plugin.views.FontHeaderBarExtension;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.configuration.Configuration;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.language.LanguageFile;

public class TextAreaView
extends View {
    private static final long serialVersionUID = 1L;
    private final JTextArea textArea = new JTextArea();
    private final float defFontSize;

    public TextAreaView(String string) throws IllegalArgumentException {
        this(string, true, null, null);
    }

    public TextAreaView(String string, boolean bl) throws IllegalArgumentException {
        this(string, bl, null, null);
    }

    public TextAreaView(String string, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, bl, languageFile, string2);
        this.textArea.setFont(UIManager.getFont("TextField.font"));
        this.textArea.setEditable(false);
        this.defFontSize = this.textArea.getFont().getSize();
        new FontHeaderBarExtension(this, this.defFontSize, bl, languageFile, string2).apply();
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)new JScrollPane(this.textArea), "Center");
    }

    @Override
    public boolean getAutoRepaint() {
        return super.getAutoRepaint();
    }

    @Override
    public void setAutoRepaint(boolean bl) {
        super.setAutoRepaint(bl);
    }

    @Override
    public void reset() {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setText("");
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".reset"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setText("");
                }
            });
        }
    }

    public boolean isEditable() {
        if (EDT.isExecutedInEDT()) {
            return this.textArea.isEditable();
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return TextAreaView.this.textArea.isEditable();
            }
        });
    }

    public void setEditable(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setEditable(bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEditable"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setEditable(bl);
                }
            });
        }
    }

    public String getText() {
        if (EDT.isExecutedInEDT()) {
            return this.textArea.getText();
        }
        return EDT.execute(new GuiRequest<String>(){

            @Override
            protected String execute() throws Throwable {
                return TextAreaView.this.textArea.getText();
            }
        });
    }

    public void setText(final String string) {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setText(string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setText"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setText(string);
                }
            });
        }
    }

    @Override
    public Font getFont() {
        if (EDT.isExecutedInEDT()) {
            return this.textArea.getFont();
        }
        return EDT.execute(new GuiRequest<Font>(){

            @Override
            protected Font execute() throws Throwable {
                return TextAreaView.this.textArea.getFont();
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setFont(font);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setFont(font);
                }
            });
        }
    }

    @Override
    public void setBackground(final Color color) {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setBackground(color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setBackground"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setBackground(color);
                }
            });
        }
        this.autoRepaint();
    }

    @Override
    public void setForeground(final Color color) {
        if (EDT.isExecutedInEDT()) {
            this.textArea.setForeground(color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setForeground"){

                @Override
                protected void execute() throws Throwable {
                    TextAreaView.this.textArea.setForeground(color);
                }
            });
        }
        this.autoRepaint();
    }

    @Override
    protected void autoRepaint() {
        if (this.getAutoRepaint()) {
            this.textArea.repaint();
        }
    }

    @Override
    protected void readConfigurationData(Configuration configuration) {
        super.readConfigurationData(configuration);
        this.setFont(this.getFont().deriveFont(configuration.getFloat("fontSize", this.defFontSize)));
    }

    @Override
    protected void writeConfigurationData(Configuration configuration) {
        super.writeConfigurationData(configuration);
        configuration.addFloat("fontSize", this.getFont().getSize2D());
    }
}

