/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import lavesdk.algorithm.plugin.views.FontHeaderBarExtension;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.MatrixEditor;
import lavesdk.gui.widgets.MatrixElementFormat;
import lavesdk.language.LanguageFile;
import lavesdk.math.Matrix;

public class MatrixView<T>
extends View {
    private static final long serialVersionUID = 1L;
    private final MatrixEditor<T> matrixEditor;

    public MatrixView(String string, MatrixElementFormat<T> matrixElementFormat) throws IllegalArgumentException {
        this(string, matrixElementFormat, true);
    }

    public MatrixView(String string, MatrixElementFormat<T> matrixElementFormat, boolean bl) throws IllegalArgumentException {
        this(string, matrixElementFormat, bl, null, null);
    }

    public MatrixView(String string, MatrixElementFormat<T> matrixElementFormat, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, bl, languageFile, string2);
        this.matrixEditor = new MatrixEditor<T>(matrixElementFormat);
        this.matrixEditor.setEditable(false);
        new FontHeaderBarExtension(this, this.matrixEditor.getFont().getSize2D(), bl, languageFile, string2);
        this.content.setLayout(new BorderLayout());
        this.content.add(this.matrixEditor, "Center");
    }

    @Override
    public boolean getAutoRepaint() {
        return this.matrixEditor.getAutoRepaint();
    }

    @Override
    public void setAutoRepaint(boolean bl) {
        this.matrixEditor.setAutoRepaint(bl);
    }

    @Override
    public void reset() {
        this.matrixEditor.setMatrix(null);
        this.matrixEditor.setColumnLabels(null);
        this.matrixEditor.setRowLabels(null);
        this.matrixEditor.setPaintLabels(false);
        this.matrixEditor.removeAllColumnStrikeouts();
        this.matrixEditor.removeAllRowStrikeouts();
    }

    public boolean isEditable() {
        return this.matrixEditor.isEditable();
    }

    public void setEditable(boolean bl) {
        this.matrixEditor.setEditable(bl);
    }

    public void clearSelection() {
        this.matrixEditor.clearSelection();
    }

    public final Matrix<T> getMatrix() {
        return this.matrixEditor.getMatrix();
    }

    public final void setMatrix(Matrix<T> matrix) {
        this.matrixEditor.setMatrix(matrix);
    }

    public int getMaskCount() {
        return this.matrixEditor.getMaskCount();
    }

    public Mask getMask(int n) throws IndexOutOfBoundsException {
        return this.matrixEditor.getMask(n);
    }

    public void addMask(Mask mask) {
        this.matrixEditor.addMask(mask);
    }

    public void removeMask(Mask mask) {
        this.matrixEditor.removeMask(mask);
    }

    public Color getElementBackground(int n, int n2) {
        return this.matrixEditor.getElementBackground(n, n2);
    }

    public void setElementBackground(int n, int n2, Color color) throws IndexOutOfBoundsException {
        this.matrixEditor.setElementBackground(n, n2, color);
    }

    public Color getElementForeground(int n, int n2) {
        return this.matrixEditor.getElementForeground(n, n2);
    }

    public void setElementForeground(int n, int n2, Color color) throws IndexOutOfBoundsException {
        this.matrixEditor.setElementForeground(n, n2, color);
    }

    public int getColumnSpacing() {
        return this.matrixEditor.getColumnSpacing();
    }

    public void setColumnSpacing(int n) throws IllegalArgumentException {
        this.matrixEditor.setColumnSpacing(n);
    }

    public int getRowSpacing() {
        return this.matrixEditor.getRowSpacing();
    }

    public void setRowSpacing(int n) throws IllegalArgumentException {
        this.matrixEditor.setRowSpacing(n);
    }

    public boolean isPaintLabels() {
        return this.matrixEditor.isPaintLabels();
    }

    public void setPaintLabels(boolean bl) {
        this.matrixEditor.setPaintLabels(bl);
    }

    public void setRowLabels(Map<Integer, String> map) {
        this.matrixEditor.setRowLabels(map);
    }

    public void setColumnLabels(Map<Integer, String> map) {
        this.matrixEditor.setColumnLabels(map);
    }

    public void addRowStrikeout(MatrixEditor.Strikeout strikeout) throws IllegalArgumentException {
        this.matrixEditor.addRowStrikeout(strikeout);
    }

    public void removeRowStrikeout(int n) {
        this.matrixEditor.removeRowStrikeout(n);
    }

    public void removeLastRowStrikeout() {
        this.matrixEditor.removeLastRowStrikeout();
    }

    public void removeAllRowStrikeouts() {
        this.matrixEditor.removeAllRowStrikeouts();
    }

    public void addColumnStrikeout(MatrixEditor.Strikeout strikeout) throws IllegalArgumentException {
        this.matrixEditor.addColumnStrikeout(strikeout);
    }

    public void removeColumnStrikeout(int n) {
        this.matrixEditor.removeColumnStrikeout(n);
    }

    public void removeLastColumnStrikeout() {
        this.matrixEditor.removeLastColumnStrikeout();
    }

    public void removeAllColumnStrikeouts() {
        this.matrixEditor.removeAllColumnStrikeouts();
    }

    public int getRowHeight() {
        return this.matrixEditor.getRowHeight();
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            super.setFont(font);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + "setFont"){

                @Override
                protected void execute() throws Throwable {
                    MatrixView.super.setFont(font);
                }
            });
        }
        this.matrixEditor.setFont(font);
    }

    @Override
    public void setRepaintDisabled(boolean bl) {
        this.matrixEditor.setRepaintDisabled(bl);
        super.setRepaintDisabled(bl);
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        this.matrixEditor.repaint();
    }
}

