/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.UIManager;
import lavesdk.algorithm.plugin.views.FontHeaderBarExtension;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.configuration.Configuration;
import lavesdk.gui.widgets.Legend;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.language.LanguageFile;

public class LegendView
extends View {
    private static final long serialVersionUID = 1L;
    private final Legend legend = new Legend();
    private final float defFontSize;

    public LegendView(String string) throws IllegalArgumentException {
        this(string, true);
    }

    public LegendView(String string, boolean bl) throws IllegalArgumentException {
        this(string, bl, null, null);
    }

    public LegendView(String string, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, bl, languageFile, string2);
        Font font = UIManager.getFont("Label.font");
        this.setFont(font);
        this.defFontSize = this.getFont().getSize();
        new FontHeaderBarExtension(this, this.defFontSize, bl, languageFile, string2).apply();
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)this.legend, "Center");
    }

    public void add(LegendItem legendItem) throws IllegalArgumentException {
        if (legendItem == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.legend.add(legendItem);
    }

    public LegendItem getItem(String string) {
        return this.legend.getItem(string);
    }

    public Color getGroupBackground() {
        return this.legend.getGroupBackground();
    }

    public void setGroupBackground(Color color) throws IllegalArgumentException {
        this.legend.setGroupBackground(color);
    }

    public Color getGroupForeground() {
        return this.legend.getGroupForeground();
    }

    public void setGroupForeground(Color color) throws IllegalArgumentException {
        this.legend.setGroupForeground(color);
    }

    @Override
    public Font getFont() {
        return this.legend.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.legend.setFont(font);
    }

    @Override
    public void removeAll() {
        this.legend.removeAll();
    }

    @Override
    public void reset() {
    }

    @Override
    protected void readConfigurationData(Configuration configuration) {
        super.readConfigurationData(configuration);
        this.setFont(this.getFont().deriveFont(configuration.getFloat("fontSize", this.defFontSize)));
    }

    @Override
    protected void writeConfigurationData(Configuration configuration) {
        super.writeConfigurationData(configuration);
        configuration.addFloat("fontSize", this.getFont().getSize2D());
    }
}

