/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lavesdk.algorithm.plugin.views.GraphLayout;
import lavesdk.algorithm.plugin.views.GraphScene;
import lavesdk.algorithm.plugin.views.GraphTransferProtocol;
import lavesdk.algorithm.plugin.views.GraphViewListener;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.custom.CustomVisualObject;
import lavesdk.algorithm.plugin.views.renderers.DefaultEdgeRenderer;
import lavesdk.algorithm.plugin.views.renderers.DefaultVertexRenderer;
import lavesdk.algorithm.plugin.views.renderers.EdgeRenderer;
import lavesdk.algorithm.plugin.views.renderers.VertexRenderer;
import lavesdk.configuration.Configuration;
import lavesdk.graphics.CatmullRomSpline;
import lavesdk.graphics.SplineIntersectionPoint;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesList;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.TextProperty;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.AccessibleIDObserver;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.GraphFactory;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;
import lavesdk.serialization.ObjectFile;
import lavesdk.serialization.Serializable;
import lavesdk.serialization.Serializer;
import lavesdk.utils.FileUtils;
import lavesdk.utils.MathUtils;
import lavesdk.utils.PopupWindow;

public class GraphView<V extends Vertex, E extends Edge>
extends View
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Graph<V, E> graph;
    private final GraphFactory<V, E> graphFactory;
    private GraphScene<V, E> nonEditableScene;
    private boolean restorableEditMode;
    private final JToolBar toolBar;
    private final JScrollPane scrollPane;
    private final GraphDrawingPanel graphPanel;
    private final JToggleButton cursorBtn;
    private final JToggleButton addVertexBtn;
    private final JToggleButton addEdgeBtn;
    private final JButton deleteObjectBtn;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private final JButton showPropertiesBtn;
    private final JToolBar.Separator[] toolBarSeparators;
    private final BorderLayout contentLayout;
    private final EventController eventController;
    private boolean editable;
    private boolean showZoomToolsAlways;
    private boolean showCursorToolAlways;
    private boolean hideGraphToolsAlways;
    private SelectionType selectionType;
    private Tool selTool;
    private int vpasTolerance;
    private boolean dynamicEdgeLabeling;
    private final List<VisualVertex> visualVertices;
    private final Map<Integer, VisualVertex> visualVerticesByID;
    private final List<VisualEdge> visualEdges;
    private final Map<Integer, VisualEdge> visualEdgesByID;
    private final Dimension drawingArea;
    private int zoom;
    private int lastZoom;
    private final List<VisualVertex> selVertices;
    private final List<VisualEdge> selEdges;
    private Point mousePos;
    private VisualVertex vertexToMove;
    private boolean vertexMoved;
    private final List<Point> edgeToolCtrlPoints;
    private Rectangle selAreaRect;
    private final Stroke selAreaStroke;
    private final VertexPropertiesDialog vertexPropsDlg;
    private final EdgePropertiesDialog edgePropsDlg;
    private long lastKeyTyped;
    private String keyTypedString;
    private final List<GraphViewListener<V, E>> listeners;
    private Font font;
    private final List<CustomVisualObject> customVisualObjects;
    private boolean graphDataStructureChanged;
    private int edgeOffsetDistance;
    private AccessibleIDObserver idObserver;
    private boolean loadingVGF;
    private String deleteObjectsWarningMsg;
    private String deleteObjectsWarningTitle;
    private String showPropsInfoMsg;
    private String showPropsInfoTitle;
    private final String vertexPropCaption;
    private final String edgePropWeight;
    private final String edgePropDirected;
    private final String edgePropDirectedDescDG;
    private final String edgePropDirectedDescUDG;
    private Color selectionColor;
    private Color edgeToolColor;
    private VertexRenderer<V> vertexRenderer;
    private EdgeRenderer<E> edgeRenderer;
    private int radiusOfVertex;
    private float radiusOfVertexF;
    private int currEdgeOffsetDistance;
    private float currEdgeOffsetDistanceF;
    private int loopOffsetDistance;
    private float loopOffsetDistanceF;
    private int edgeArrowLength;
    private float edgeArrowLengthF;
    private float fontSizeF;
    private boolean adjustPositionsToZoom;
    private boolean mouseDown;
    private static final int DEF_RADIUS = 10;
    private static final int DRAWINGAREA_PADDING = 100;
    private static final int DEF_ARROWLENGTH = 5;
    private static final int DEF_OFFSETDISTANCE = 20;
    private static final int DEF_LOOPOFFSETDISTANCE = 5;
    private static final int SELECT_EDGE_TOLARANCE = 3;
    private static final int EDGETOOL_CIRCLE_RADIUS = 3;
    private static final int DEF_VPAS_TOLERANCE = 5;
    private static final double MAX_ARC_ANGLE_EPSILONNEG = 179.999999;
    private static final double MAX_ARC_ANGLE_EPSILONPOS = 180.000001;
    public static final String VISUALGRAPHFILE_EXT = ".vgf";
    public static final Color DEF_VERTEXBACKGROUND = Color.white;
    public static final Color DEF_VERTEXFOREGROUND = Color.black;
    public static final int DEF_VERTEXEDGEWIDTH = 1;
    public static final Color DEF_EDGECOLOR = Color.black;
    public static final int DEF_EDGELINEWIDTH = 1;
    private static final Color DEF_SELECTIONCOLOR = SystemColor.textHighlight;
    private static final Color DEF_EDGETOOLCOLOR = Color.black;

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory) throws IllegalArgumentException {
        this(string, graph, graphFactory, null);
    }

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory, boolean bl) throws IllegalArgumentException {
        this(string, graph, graphFactory, null, bl);
    }

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory, GraphLayout graphLayout) throws IllegalArgumentException {
        this(string, graph, graphFactory, graphLayout, true, null, null);
    }

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory, GraphLayout graphLayout, boolean bl) throws IllegalArgumentException {
        this(string, graph, graphFactory, graphLayout, bl, null, null);
    }

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        this(string, graph, graphFactory, null, bl, languageFile, string2);
    }

    public GraphView(String string, Graph<V, E> graph, GraphFactory<V, E> graphFactory, GraphLayout graphLayout, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, bl, languageFile, string2);
        if (graph == null || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphFactory = graphFactory;
        this.nonEditableScene = null;
        this.restorableEditMode = true;
        this.toolBar = new JToolBar(1);
        this.graphPanel = new GraphDrawingPanel();
        this.scrollPane = new JScrollPane(this.graphPanel);
        this.cursorBtn = new JToggleButton(Resources.getInstance().MOUSECURSOR_ICON);
        this.addVertexBtn = new JToggleButton(Resources.getInstance().VERTEX_ADD_ICON);
        this.addEdgeBtn = new JToggleButton(Resources.getInstance().EDGE_ADD_ICON);
        this.deleteObjectBtn = new JButton(Resources.getInstance().DELETE_ICON);
        this.zoomInBtn = new JButton(Resources.getInstance().ZOOM_IN_ICON);
        this.zoomOutBtn = new JButton(Resources.getInstance().ZOOM_OUT_ICON);
        this.showPropertiesBtn = new JButton(Resources.getInstance().PROPERTIES_ICON);
        this.contentLayout = new BorderLayout();
        this.eventController = new EventController();
        this.editable = true;
        this.showZoomToolsAlways = true;
        this.showCursorToolAlways = false;
        this.hideGraphToolsAlways = false;
        this.selectionType = SelectionType.BOTH;
        this.vpasTolerance = 5;
        this.dynamicEdgeLabeling = true;
        this.visualVertices = new ArrayList<VisualVertex>();
        this.visualVerticesByID = new HashMap<Integer, VisualVertex>();
        this.visualEdges = new ArrayList<VisualEdge>();
        this.visualEdgesByID = new HashMap<Integer, VisualEdge>();
        this.drawingArea = new Dimension();
        this.lastZoom = 100;
        this.zoom = 100;
        this.mouseDown = false;
        this.vertexToMove = null;
        this.vertexMoved = false;
        this.mousePos = new Point();
        this.selVertices = new ArrayList<VisualVertex>();
        this.selEdges = new ArrayList<VisualEdge>();
        this.edgeToolCtrlPoints = new ArrayList<Point>();
        this.selAreaRect = null;
        this.selAreaStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
        this.vertexPropsDlg = new VertexPropertiesDialog(languageFile, string2);
        this.edgePropsDlg = new EdgePropertiesDialog(languageFile, string2);
        this.lastKeyTyped = 0L;
        this.keyTypedString = "";
        this.listeners = new ArrayList<GraphViewListener<V, E>>(3);
        this.font = UIManager.getFont("Label.font");
        this.customVisualObjects = new ArrayList<CustomVisualObject>();
        this.graphDataStructureChanged = false;
        this.edgeOffsetDistance = 20;
        this.loadingVGF = false;
        this.selectionColor = DEF_SELECTIONCOLOR;
        this.edgeToolColor = DEF_EDGETOOLCOLOR;
        this.vertexRenderer = new DefaultVertexRenderer<V>();
        this.edgeRenderer = new DefaultEdgeRenderer<E>();
        this.radiusOfVertex = 10;
        this.radiusOfVertexF = 10;
        this.currEdgeOffsetDistance = 20;
        this.currEdgeOffsetDistanceF = 20;
        this.loopOffsetDistance = 5;
        this.loopOffsetDistanceF = 5;
        this.edgeArrowLength = 5;
        this.edgeArrowLengthF = 5;
        this.fontSizeF = this.font.getSize();
        this.adjustPositionsToZoom = false;
        this.content.setLayout(this.contentLayout);
        this.content.add((Component)this.toolBar, "West");
        this.content.add((Component)this.scrollPane, "Center");
        this.cursorBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_MOUSECURSOR_BTN_TOOLTIP", string2, "<b>Mouse cursor</b><br>Use the cursor to select/deselect vertices and edges,<br>move a vertex by dragging him with the mouse or click in the graph<br>and move the mouse to stretch a selection area to select multiple objects.") + "</html>");
        this.addVertexBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_ADDVERTEX_BTN_TOOLTIP", string2, "<b>Add a new vertex</b><br>Use the mouse and click inside the graph area to position a new vertex.") + "</html>");
        this.addEdgeBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_ADDEDGE_BTN_TOOLTIP", string2, "<b>Add a new edge</b><br>Use your left mouse button to start/end a connection path and the right mouse button<br>to add intermediate points if necessary (after you click the left mouse button again<br>the vertices that lie on the path are connected).") + "</html>");
        this.deleteObjectBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_DELETEOBJ_BTN_TOOLTIP", string2, "<b>Delete objects</b><br>Select the vertices and edges you want to remove from the graph and<br>press this button or use the delete key on your keyboard.") + "</html>");
        this.showPropertiesBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_SHOWPROPS_BTN_TOOLTIP", string2, "<b>Show properties</b><br>Select a vertex or edge and press this button to show the properties window.<br>Their you can view and modify the properties of the object.<br><b>Tip 1</b>: You can double click on an object to open the properties window too.<br><b>Tip 2</b>: It is also possible to select a vertex/edge and use the keyboard to change<br>the vertex's caption or edge's weight.") + "</html>");
        this.zoomInBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_ZOOMIN_BTN_TOOLTIP", string2, "<b>Zoom in</b>") + "</html>");
        this.zoomOutBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHVIEW_ZOOMOUT_BTN_TOOLTIP", string2, "<b>Zoom out</b>") + "</html>");
        this.deleteObjectsWarningMsg = LanguageFile.getLabel(languageFile, "MSG_WARN_GRAPHVIEW_DELETEOBJ", string2, "Are you sure you want to delete the selected objects from the graph?");
        this.deleteObjectsWarningTitle = LanguageFile.getLabel(languageFile, "MSG_WARN_TITLE_GRAPHVIEW_DELETEOBJ", string2, "Delete selected objects");
        this.showPropsInfoMsg = LanguageFile.getLabel(languageFile, "MSG_INFO_GRAPHVIEW_SHOWPROPS", string2, "Select an object to show or modify its properties!");
        this.showPropsInfoTitle = LanguageFile.getLabel(languageFile, "MSG_INFO_TITLE_GRAPHVIEW_SHOWPROPS", string2, "Show properties");
        this.vertexPropCaption = LanguageFile.getLabel(languageFile, "GRAPHVIEW_VERTEXPROPS_CAPTION", string2, "caption");
        this.edgePropWeight = LanguageFile.getLabel(languageFile, "GRAPHVIEW_EDGEPROPS_WEIGHT", string2, "weight");
        this.edgePropDirected = LanguageFile.getLabel(languageFile, "GRAPHVIEW_EDGEPROPS_DIRECTED", string2, "directed");
        this.edgePropDirectedDescDG = LanguageFile.getLabel(languageFile, "GRAPHVIEW_EDGEPROPS_DIRECTED_CHANGEINFO_DG", string2, "This is a directed graph so changing this value does not have any effect.");
        this.edgePropDirectedDescUDG = LanguageFile.getLabel(languageFile, "GRAPHVIEW_EDGEPROPS_DIRECTED_CHANGEINFO_UDG", string2, "This is an undirected graph so changing this value does not have any effect.");
        this.toolBarSeparators = new JToolBar.Separator[4];
        for (int i = 0; i < this.toolBarSeparators.length; ++i) {
            this.toolBarSeparators[i] = new JToolBar.Separator();
        }
        this.toolBar.add(this.cursorBtn);
        this.toolBar.add(this.toolBarSeparators[0]);
        this.toolBar.add(this.addVertexBtn);
        this.toolBar.add(this.addEdgeBtn);
        this.toolBar.add(this.toolBarSeparators[1]);
        this.toolBar.add(this.deleteObjectBtn);
        this.toolBar.add(this.toolBarSeparators[2]);
        this.toolBar.add(this.showPropertiesBtn);
        this.toolBar.add(this.toolBarSeparators[3]);
        this.toolBar.add(this.zoomInBtn);
        this.toolBar.add(this.zoomOutBtn);
        this.selectTool(Tool.CURSOR);
        this.graphPanel.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        this.addKeyListener(this.eventController);
        this.graphPanel.addMouseListener(this.eventController);
        this.graphPanel.addMouseMotionListener(this.eventController);
        this.scrollPane.addMouseListener(this.eventController);
        this.cursorBtn.addActionListener(this.eventController);
        this.addVertexBtn.addActionListener(this.eventController);
        this.addEdgeBtn.addActionListener(this.eventController);
        this.deleteObjectBtn.addActionListener(this.eventController);
        this.showPropertiesBtn.addActionListener(this.eventController);
        this.zoomInBtn.addActionListener(this.eventController);
        this.zoomOutBtn.addActionListener(this.eventController);
        this.setGraph(graph);
        this.layoutGraph(graphLayout != null ? graphLayout : new CircleGraphLayout());
    }

    @Override
    public boolean getAutoRepaint() {
        return super.getAutoRepaint();
    }

    @Override
    public void setAutoRepaint(boolean bl) {
        super.setAutoRepaint(bl);
    }

    public final void addGraphViewListener(final GraphViewListener<V, E> graphViewListener) {
        if (graphViewListener == null || this.listeners.contains(graphViewListener)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.listeners.add(graphViewListener);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addGraphViewListener"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.listeners.add(graphViewListener);
                }
            });
        }
    }

    public final void removeGraphViewListener(final GraphViewListener<V, E> graphViewListener) {
        if (graphViewListener == null) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.listeners.remove(graphViewListener);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeGraphViewListener"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.listeners.remove(graphViewListener);
                }
            });
        }
    }

    public final boolean isEditable() {
        if (EDT.isExecutedInEDT()) {
            return this.editable;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return GraphView.this.editable;
            }
        });
    }

    public final void setEditable(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetEditable(bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEditable"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSetEditable(bl);
                }
            });
        }
    }

    public final boolean hasRestorableEditMode() {
        if (EDT.isExecutedInEDT()) {
            return this.restorableEditMode;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return GraphView.this.restorableEditMode;
            }
        });
    }

    public final void setRestorableEditMode(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.restorableEditMode = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setRestorableEditMode"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.restorableEditMode = bl;
                }
            });
        }
    }

    public final void setShowZoomToolsAlways(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.showZoomToolsAlways = bl;
            this.updateToolBarButtonVisibility();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setShowZoomToolsAlways"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.showZoomToolsAlways = bl;
                    GraphView.this.updateToolBarButtonVisibility();
                }
            });
        }
    }

    public final void setShowCursorToolAlways(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.showCursorToolAlways = bl;
            this.updateToolBarButtonVisibility();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setShowCursorToolAlways"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.showCursorToolAlways = bl;
                    GraphView.this.updateToolBarButtonVisibility();
                }
            });
        }
    }

    public final void setHideGraphToolsAlways(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.hideGraphToolsAlways = bl;
            this.updateToolBarButtonVisibility();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setHideGraphToolsAlways"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.hideGraphToolsAlways = bl;
                    GraphView.this.updateToolBarButtonVisibility();
                }
            });
        }
    }

    public SelectionType getSelectionType() {
        if (EDT.isExecutedInEDT()) {
            return this.selectionType;
        }
        return EDT.execute(new GuiRequest<SelectionType>(){

            @Override
            protected SelectionType execute() throws Throwable {
                return GraphView.this.selectionType;
            }
        });
    }

    public void setSelectionType(final SelectionType selectionType) {
        if (EDT.isExecutedInEDT()) {
            this.selectionType = selectionType;
            this.deselectAll();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setSelectionType"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.selectionType = selectionType;
                    GraphView.this.deselectAll();
                }
            });
        }
    }

    public int getLastZoom() {
        if (EDT.isExecutedInEDT()) {
            return this.lastZoom;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.lastZoom;
            }
        });
    }

    public int getZoom() {
        if (EDT.isExecutedInEDT()) {
            return this.zoom;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.zoom;
            }
        });
    }

    public void setZoom(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetZoom(n);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setZoom"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSetZoom(n);
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void zoomIn() {
        this.setZoom(this.getZoom() + 10);
    }

    public void zoomOut() {
        this.setZoom(this.getZoom() - 10);
    }

    public int getEdgeOffsetDistance() {
        if (EDT.isExecutedInEDT()) {
            return this.edgeOffsetDistance;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.edgeOffsetDistance;
            }
        });
    }

    public void setEdgeOffsetDistance(final int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.edgeOffsetDistance = n;
            this.currEdgeOffsetDistanceF = (float)this.edgeOffsetDistance / 100.0f * (float)this.zoom;
            this.currEdgeOffsetDistance = (int)this.currEdgeOffsetDistanceF;
            this.computeEdgePositions();
            this.computeDynamicEdgeLabeling();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEdgeOffsetDistance"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.edgeOffsetDistance = n;
                    GraphView.this.currEdgeOffsetDistanceF = (float)GraphView.this.edgeOffsetDistance / 100.0f * (float)GraphView.this.zoom;
                    GraphView.this.currEdgeOffsetDistance = (int)GraphView.this.currEdgeOffsetDistanceF;
                    GraphView.this.computeEdgePositions();
                    GraphView.this.computeDynamicEdgeLabeling();
                }
            });
        }
    }

    public int getVPASTolerance() {
        if (EDT.isExecutedInEDT()) {
            return this.vpasTolerance;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.vpasTolerance;
            }
        });
    }

    public void setVPASTolerance(final int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.vpasTolerance = n;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setVPASTolerance"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.vpasTolerance = n;
                }
            });
        }
    }

    public boolean hasDynamicEdgeLabeling() {
        if (EDT.isExecutedInEDT()) {
            return this.dynamicEdgeLabeling;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return GraphView.this.dynamicEdgeLabeling;
            }
        });
    }

    public void setDynamicEdgeLabeling(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.dynamicEdgeLabeling = bl;
            this.computeEdgePositions();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setDynamicEdgeLabeling"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.dynamicEdgeLabeling = bl;
                    GraphView.this.computeEdgePositions();
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void setVertexRenderer(final VertexRenderer<V> vertexRenderer) throws IllegalArgumentException {
        if (vertexRenderer == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.vertexRenderer = vertexRenderer;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setVertexRenderer"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.vertexRenderer = vertexRenderer;
                }
            });
        }
    }

    public void setEdgeRenderer(final EdgeRenderer<E> edgeRenderer) throws IllegalArgumentException {
        if (edgeRenderer == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.edgeRenderer = edgeRenderer;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEdgeRenderer"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.edgeRenderer = edgeRenderer;
                }
            });
        }
    }

    public Color getSelectionColor() {
        if (EDT.isExecutedInEDT()) {
            return this.selectionColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return GraphView.this.selectionColor;
            }
        });
    }

    public void setSelectionColor(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.selectionColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setSelectionColor"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.selectionColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    public Color getEdgeToolColor() {
        if (EDT.isExecutedInEDT()) {
            return this.edgeToolColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return GraphView.this.edgeToolColor;
            }
        });
    }

    public void setEdgeToolColor(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.edgeToolColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEdgeToolColor"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.edgeToolColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    public final int getVisualVertexCount() {
        if (EDT.isExecutedInEDT()) {
            return this.visualVertices.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.visualVertices.size();
            }
        });
    }

    public final VisualVertex getVisualVertex(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.visualVertices.get(n);
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return (VisualVertex)GraphView.this.visualVertices.get(n);
            }
        });
    }

    public final VisualVertex getVisualVertex(final Vertex vertex) {
        if (EDT.isExecutedInEDT()) {
            return vertex != null ? this.getVisualVertexByID(vertex.getID()) : null;
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return vertex != null ? GraphView.this.getVisualVertexByID(vertex.getID()) : null;
            }
        });
    }

    public final VisualVertex getVisualVertexByID(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.visualVerticesByID.get(n);
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return (VisualVertex)GraphView.this.visualVerticesByID.get(n);
            }
        });
    }

    public final VisualVertex getVisualVertexByCaption(final String string) {
        if (EDT.isExecutedInEDT()) {
            return this.internalGetVisualVertexByCaption(string);
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return GraphView.this.internalGetVisualVertexByCaption(string);
            }
        });
    }

    public final int getSelectedVertexCount() {
        if (EDT.isExecutedInEDT()) {
            return this.selVertices.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.selVertices.size();
            }
        });
    }

    public final VisualVertex getSelectedVertex(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.selVertices.get(n);
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return (VisualVertex)GraphView.this.selVertices.get(n);
            }
        });
    }

    public final int getVisualEdgeCount() {
        if (EDT.isExecutedInEDT()) {
            return this.visualEdges.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.visualEdges.size();
            }
        });
    }

    public final VisualEdge getVisualEdge(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.visualEdges.get(n);
        }
        return EDT.execute(new GuiRequest<VisualEdge>(){

            @Override
            protected VisualEdge execute() throws Throwable {
                return (VisualEdge)GraphView.this.visualEdges.get(n);
            }
        });
    }

    public final VisualEdge getVisualEdge(final Edge edge) {
        if (EDT.isExecutedInEDT()) {
            return edge != null ? this.getVisualEdgeByID(edge.getID()) : null;
        }
        return EDT.execute(new GuiRequest<VisualEdge>(){

            @Override
            protected VisualEdge execute() throws Throwable {
                return edge != null ? GraphView.this.getVisualEdgeByID(edge.getID()) : null;
            }
        });
    }

    public final VisualEdge getVisualEdgeByID(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.visualEdgesByID.get(n);
        }
        return EDT.execute(new GuiRequest<VisualEdge>(){

            @Override
            protected VisualEdge execute() throws Throwable {
                return (VisualEdge)GraphView.this.visualEdgesByID.get(n);
            }
        });
    }

    public final int getSelectedEdgeCount() {
        if (EDT.isExecutedInEDT()) {
            return this.selEdges.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.selEdges.size();
            }
        });
    }

    public final VisualEdge getSelectedEdge(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.selEdges.get(n);
        }
        return EDT.execute(new GuiRequest<VisualEdge>(){

            @Override
            protected VisualEdge execute() throws Throwable {
                return (VisualEdge)GraphView.this.selEdges.get(n);
            }
        });
    }

    public void selectVertex(final VisualVertex visualVertex, final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.internalSelectVertex(visualVertex, bl, true);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".selectVertex"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSelectVertex(visualVertex, bl, true);
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void selectVertices(final List<VisualVertex> list) {
        if (EDT.isExecutedInEDT()) {
            for (VisualVertex visualVertex : list) {
                this.internalSelectVertex(visualVertex, true, false);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".selectVertices"){

                @Override
                protected void execute() throws Throwable {
                    for (VisualVertex visualVertex : list) {
                        GraphView.this.internalSelectVertex(visualVertex, true, false);
                    }
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void selectEdge(final VisualEdge visualEdge, final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.internalSelectEdge(visualEdge, bl, true);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".selectEdge"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSelectEdge(visualEdge, bl, true);
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void selectEdges(final List<VisualEdge> list) {
        if (EDT.isExecutedInEDT()) {
            for (VisualEdge visualEdge : list) {
                this.internalSelectEdge(visualEdge, true, false);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".selectEdges"){

                @Override
                protected void execute() throws Throwable {
                    for (VisualEdge visualEdge : list) {
                        GraphView.this.internalSelectEdge(visualEdge, true, false);
                    }
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void deselectAll() {
        if (EDT.isExecutedInEDT()) {
            this.internalDeselectAll();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".deselectAll"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalDeselectAll();
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void removeAllVertices() {
        if (EDT.isExecutedInEDT()) {
            for (int i = this.visualVertices.size() - 1; i >= 0; --i) {
                this.removeVisualVertex(this.visualVertices.get(i));
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllVertices"){

                @Override
                protected void execute() throws Throwable {
                    for (int i = GraphView.this.visualVertices.size() - 1; i >= 0; --i) {
                        GraphView.this.removeVisualVertex((VisualVertex)GraphView.this.visualVertices.get(i));
                    }
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void removeAllEdges() {
        if (EDT.isExecutedInEDT()) {
            for (int i = this.visualEdges.size() - 1; i >= 0; --i) {
                this.removeVisualEdge(this.visualEdges.get(i));
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllEdges"){

                @Override
                protected void execute() throws Throwable {
                    for (int i = GraphView.this.visualEdges.size() - 1; i >= 0; --i) {
                        GraphView.this.removeVisualEdge((VisualEdge)GraphView.this.visualEdges.get(i));
                    }
                }
            });
        }
        this.graphPanel.repaint();
    }

    public GraphFactory<V, E> getGraphFactory() {
        if (EDT.isExecutedInEDT()) {
            return this.graphFactory;
        }
        return (GraphFactory)EDT.execute(new GuiRequest<GraphFactory<V, E>>(){

            @Override
            protected GraphFactory<V, E> execute() throws Throwable {
                return GraphView.this.graphFactory;
            }
        });
    }

    public Graph<V, E> getGraph() {
        if (EDT.isExecutedInEDT()) {
            return this.graph;
        }
        return (Graph)EDT.execute(new GuiRequest<Graph<V, E>>(){

            @Override
            protected Graph<V, E> execute() throws Throwable {
                return GraphView.this.graph;
            }
        });
    }

    public void setGraph(final Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSetGraph(graph);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setGraph"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSetGraph(graph);
                }
            });
        }
        this.autoRepaint();
    }

    public void layoutGraph(final GraphLayout graphLayout) throws IllegalArgumentException {
        if (graphLayout == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalLayoutGraph(graphLayout);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".layoutGraph"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalLayoutGraph(graphLayout);
                }
            });
        }
        this.autoRepaint();
    }

    public <N extends Vertex, L extends Edge> void transferGraph(final GraphTransferProtocol<N, L> graphTransferProtocol) throws IllegalArgumentException {
        if (graphTransferProtocol == null || !graphTransferProtocol.isPrepared()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalTransferGraph(graphTransferProtocol);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".transferGraph"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalTransferGraph(graphTransferProtocol);
                }
            });
        }
        this.autoRepaint();
    }

    public CircleGraphLayout createCircleGraphLayout() {
        return new CircleGraphLayout();
    }

    @Override
    public Font getFont() {
        if (EDT.isExecutedInEDT()) {
            return this.font;
        }
        return EDT.execute(new GuiRequest<Font>(){

            @Override
            protected Font execute() throws Throwable {
                return GraphView.this.font;
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (font == null) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.font = font;
            this.fontSizeF = font.getSize();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.font = font;
                    GraphView.this.fontSizeF = font.getSize();
                }
            });
        }
    }

    public void load(File file) throws IllegalArgumentException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.load(file.getAbsolutePath());
    }

    public void load(final String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalLoad(string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".load", true){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalLoad(string);
                }
            });
        }
        this.graphPanel.repaint();
    }

    public void save(File file) throws IllegalArgumentException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.save(file.getAbsolutePath());
    }

    public void save(final String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSave(string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".save", true){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSave(string);
                }
            });
        }
    }

    public void saveAsPNG(File file) throws IllegalArgumentException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.saveAsPNG(file.getAbsolutePath());
    }

    public void saveAsPNG(final String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSaveAsPNG(string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".saveAsPNG", true){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalSaveAsPNG(string);
                }
            });
        }
    }

    @Override
    public void reset() {
        this.removeAllEdges();
        this.removeAllVertices();
        this.removeAllVisualObjects();
        if (EDT.isExecutedInEDT()) {
            this.internalResetVisualAppearance();
            this.selectTool(Tool.CURSOR);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".reset"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalResetVisualAppearance();
                    GraphView.this.selectTool(Tool.CURSOR);
                }
            });
        }
    }

    public void resetVisualAppearance() {
        if (EDT.isExecutedInEDT()) {
            this.internalResetVisualAppearance();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".resetVisualAppearance"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.internalResetVisualAppearance();
                }
            });
        }
    }

    public VisualVertex getVertexFromPosition(final int n, final int n2) {
        if (EDT.isExecutedInEDT()) {
            return this.internalGetVertexFromPosition(n, n2);
        }
        return EDT.execute(new GuiRequest<VisualVertex>(){

            @Override
            protected VisualVertex execute() throws Throwable {
                return GraphView.this.internalGetVertexFromPosition(n, n2);
            }
        });
    }

    public VisualEdge getEdgeFromPosition(final int n, final int n2) {
        if (EDT.isExecutedInEDT()) {
            return this.internalGetEdgeFromPosition(n, n2);
        }
        return EDT.execute(new GuiRequest<VisualEdge>(){

            @Override
            protected VisualEdge execute() throws Throwable {
                return GraphView.this.internalGetEdgeFromPosition(n, n2);
            }
        });
    }

    public int getScaledVertexRadius(final VisualVertex visualVertex) {
        if (EDT.isExecutedInEDT()) {
            return this.internalGetScaledVertexRadius(visualVertex);
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.internalGetScaledVertexRadius(visualVertex);
            }
        });
    }

    public void addVisualObject(final CustomVisualObject customVisualObject) throws IllegalArgumentException {
        if (customVisualObject == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            if (!this.customVisualObjects.contains(customVisualObject)) {
                this.customVisualObjects.add(customVisualObject);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addVisualObject"){

                @Override
                protected void execute() throws Throwable {
                    if (!GraphView.this.customVisualObjects.contains(customVisualObject)) {
                        GraphView.this.customVisualObjects.add(customVisualObject);
                    }
                }
            });
        }
        this.autoRepaint();
    }

    public void removeVisualObject(final CustomVisualObject customVisualObject) {
        if (EDT.isExecutedInEDT()) {
            this.customVisualObjects.remove(customVisualObject);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeVisualObject"){

                @Override
                protected void execute() throws Throwable {
                    GraphView.this.customVisualObjects.remove(customVisualObject);
                }
            });
        }
        this.autoRepaint();
    }

    public void removeAllVisualObjects() {
        if (EDT.isExecutedInEDT()) {
            for (int i = this.customVisualObjects.size() - 1; i >= 0; --i) {
                this.removeVisualObject(this.customVisualObjects.get(i));
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllVisualObjects"){

                @Override
                protected void execute() throws Throwable {
                    for (int i = GraphView.this.customVisualObjects.size() - 1; i >= 0; --i) {
                        GraphView.this.removeVisualObject((CustomVisualObject)GraphView.this.customVisualObjects.get(i));
                    }
                }
            });
        }
    }

    public int getVisualObjectCount() {
        if (EDT.isExecutedInEDT()) {
            return this.customVisualObjects.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return GraphView.this.customVisualObjects.size();
            }
        });
    }

    public CustomVisualObject getVisualObject(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.customVisualObjects.get(n);
        }
        return EDT.execute(new GuiRequest<CustomVisualObject>(){

            @Override
            protected CustomVisualObject execute() throws Throwable {
                return (CustomVisualObject)GraphView.this.customVisualObjects.get(n);
            }
        });
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.addInt("zoom", this.zoom);
    }

    @Override
    public void deserialize(Serializer serializer) {
        this.setZoom(serializer.getInt("zoom", 100));
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        if (this.graphPanel != null) {
            this.graphPanel.repaint();
        }
    }

    @Override
    protected void autoRepaint() {
        if (this.getAutoRepaint()) {
            this.graphPanel.repaint();
        }
    }

    @Override
    protected void readConfigurationData(Configuration configuration) {
        super.readConfigurationData(configuration);
        this.changeToolBarOrientation(configuration.getString("toolBarOrientation", "West"));
        this.setZoom(configuration.getInt("zoom", this.zoom));
        this.setSelectionColor(configuration.getColor("selColor", DEF_SELECTIONCOLOR));
        this.setEdgeToolColor(configuration.getColor("edgeToolColor", DEF_EDGETOOLCOLOR));
    }

    @Override
    protected void writeConfigurationData(Configuration configuration) {
        super.writeConfigurationData(configuration);
        String string = this.contentLayout.getConstraints(this.toolBar).toString();
        configuration.addString("toolBarOrientation", !string.isEmpty() ? string : "West");
        configuration.addInt("zoom", this.getZoom());
        configuration.addColor("selColor", this.getSelectionColor());
        configuration.addColor("edgeToolColor", this.getEdgeToolColor());
    }

    protected final VisualVertex createVisualVertex(int n, int n2) {
        if (!this.beforeVisualVertexCreated(n, n2)) {
            return null;
        }
        V v = this.graphFactory.createVertex(this.getFreeVertexName());
        if (this.graph.add(v)) {
            VisualVertex visualVertex = new VisualVertex(this, v);
            this.addVisualVertex(visualVertex, n, n2);
            if (!this.loadingVGF) {
                this.adjustDrawingAreaToVertices();
                this.computeVertexAttachmentPoint(visualVertex);
            }
            this.afterVisualVertexCreated(visualVertex);
            this.fireVertexAdded(visualVertex);
            return visualVertex;
        }
        return null;
    }

    protected final void removeVisualVertex(VisualVertex visualVertex) {
        if (visualVertex == null) {
            return;
        }
        if (this.graph.remove(visualVertex.getVertex()) || !this.graph.contains(visualVertex.getVertex())) {
            int n;
            this.visualVertices.remove(visualVertex);
            this.visualVerticesByID.remove(((Vertex)visualVertex.getVertex()).getID());
            for (n = visualVertex.getIndex(); n < this.visualVertices.size(); ++n) {
                this.visualVertices.get(n).setIndex(n);
            }
            if (visualVertex.isSelected()) {
                this.selVertices.remove(visualVertex);
            }
            for (n = this.visualEdges.size() - 1; n >= 0; --n) {
                if (!this.visualEdges.get(n).dockTo(visualVertex)) continue;
                this.removeVisualEdge(this.visualEdges.get(n));
            }
            this.fireVertexRemoved(visualVertex);
        }
    }

    protected final VisualEdge createVisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2) throws IllegalArgumentException {
        return this.createVisualEdge(visualVertex, visualVertex2, false);
    }

    protected final VisualEdge createVisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, boolean bl) throws IllegalArgumentException {
        if (!this.beforeVisualEdgeCreated(visualVertex, visualVertex2, bl)) {
            return null;
        }
        E e = this.graphFactory.createEdge(visualVertex.getVertex(), visualVertex2.getVertex(), bl);
        if (this.graph.add(e)) {
            VisualEdge visualEdge = new VisualEdge(this, e, visualVertex, visualVertex2);
            this.addVisualEdge(visualEdge);
            if (!this.loadingVGF) {
                this.updateEdgeOffsetIndices();
                this.computeEdgePosition(visualEdge);
                this.computeDynamicEdgeLabeling();
                this.computeVertexAttachmentPoint(visualEdge.getPredecessor());
                this.computeVertexAttachmentPoint(visualEdge.getSuccessor());
            }
            this.afterVisualEdgeCreated(visualEdge);
            this.fireEdgeAdded(visualEdge);
            return visualEdge;
        }
        return null;
    }

    protected final void removeVisualEdge(VisualEdge visualEdge) {
        if (visualEdge == null) {
            return;
        }
        if (this.graph.remove(visualEdge.getEdge()) || !this.graph.contains(visualEdge.getEdge())) {
            this.visualEdges.remove(visualEdge);
            this.visualEdgesByID.remove(((Edge)visualEdge.getEdge()).getID());
            for (int i = visualEdge.getIndex(); i < this.visualEdges.size(); ++i) {
                this.visualEdges.get(i).setIndex(i);
            }
            if (visualEdge.isSelected()) {
                this.selEdges.remove(visualEdge);
            }
            this.updateEdgeOffsetIndices();
            this.computeDynamicEdgeLabeling();
            this.fireEdgeRemoved(visualEdge);
        }
    }

    protected final void addToolbarButton(JButton jButton) throws IllegalArgumentException {
        if (jButton == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.toolBar.add(jButton);
    }

    protected void selectTool(Tool tool) {
        this.cursorBtn.setSelected(tool == Tool.CURSOR);
        this.addVertexBtn.setSelected(tool == Tool.VERTEX);
        this.addEdgeBtn.setSelected(tool == Tool.EDGE);
        this.selTool = tool;
        this.deselectAll();
        this.edgeToolCtrlPoints.clear();
        this.graphPanel.repaint();
    }

    protected void beforePaint(Graphics2D graphics2D) {
    }

    protected void afterPaint(Graphics2D graphics2D) {
    }

    protected boolean beforeVisualVertexCreated(int n, int n2) {
        return true;
    }

    protected boolean beforeVisualEdgeCreated(VisualVertex visualVertex, VisualVertex visualVertex2, boolean bl) {
        return true;
    }

    protected void afterVisualVertexCreated(VisualVertex visualVertex) {
    }

    protected void afterVisualEdgeCreated(VisualEdge visualEdge) {
    }

    protected void loadAdvancedVertexProperties(PropertiesListModel propertiesListModel, V v) {
    }

    protected void applyAdvancedVertexProperties(PropertiesListModel propertiesListModel, V v) {
    }

    protected void loadAdvancedEdgeProperties(PropertiesListModel propertiesListModel, E e) {
    }

    protected void applyAdvancedEdgeProperties(PropertiesListModel propertiesListModel, E e) {
    }

    protected boolean ignoreKeyboardInput() {
        return false;
    }

    protected void applyKeyboardInput(V v, String string) {
        ((Vertex)v).setCaption(string);
    }

    protected void applyKeyboardInput(E e, String string) {
        try {
            ((Edge)e).setWeight(NumberFormat.getInstance().parse(string).floatValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected List<EdgeOffset> requestOffsetEdges(VisualVertex visualVertex, VisualVertex visualVertex2) {
        ArrayList<EdgeOffset> arrayList = new ArrayList<EdgeOffset>();
        List<E> list = this.graph.getEdges(visualVertex.getVertex(), visualVertex2.getVertex());
        if (list == null) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        for (Edge edge : list) {
            if (edge.getSuccessor() != visualVertex2.getVertex()) continue;
            ++n;
            bl = bl || !edge.isDirected();
        }
        List<E> list2 = this.graph.getEdges(visualVertex2.getVertex(), visualVertex.getVertex());
        int n2 = 0;
        boolean bl2 = false;
        if (list2 != null) {
            for (Edge edge : list2) {
                if (edge.getSuccessor() != visualVertex.getVertex()) continue;
                ++n2;
                bl2 = bl2 || edge.isDirected();
            }
        }
        int n3 = list.size() == 1 && list2 != null && list2.size() == 2 && bl && bl2 ? 0 : (n2 < n ? 0 : 1);
        for (int i = 0; i < list.size(); ++i) {
            if (((Edge)list.get(i)).getSuccessor() != visualVertex2.getVertex()) {
                list.remove(i);
                --i;
                continue;
            }
            arrayList.add(new EdgeOffset(this, (Edge)list.get(i), n3++));
        }
        return arrayList;
    }

    private void keyReleased(KeyEvent keyEvent) {
        if (!this.editable) {
            return;
        }
        if (keyEvent.getKeyCode() == 127 && keyEvent.getModifiers() == 0) {
            this.deleteSelectedObjects();
        }
    }

    private void keyTyped(KeyEvent keyEvent) {
        if (!this.editable || this.ignoreKeyboardInput()) {
            return;
        }
        if (this.getSelectedEdgeCount() + this.getSelectedVertexCount() != 1) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c == '\u007f') {
            return;
        }
        E e = this.getSelectedVertexCount() > 0 ? (E)this.getSelectedVertex(0).getVertex() : null;
        E e2 = this.getSelectedEdgeCount() > 0 ? (E)this.getSelectedEdge(0).getEdge() : null;
        String string = this.keyTypedString = keyEvent.getWhen() - this.lastKeyTyped <= 600L ? this.keyTypedString + keyEvent.getKeyChar() : "" + keyEvent.getKeyChar();
        if (e != null) {
            this.applyKeyboardInput(e, this.keyTypedString);
        } else if (e2 != null) {
            this.applyKeyboardInput(e2, this.keyTypedString);
        }
        this.lastKeyTyped = keyEvent.getWhen();
        if (e != null || e2 != null) {
            this.graphPanel.repaint();
        }
    }

    private void mouseDown(MouseEvent mouseEvent) {
        this.requestFocus();
        if (!this.editable && !this.showCursorToolAlways) {
            return;
        }
        if (this.selTool == Tool.CURSOR) {
            VisualEdge visualEdge;
            if (this.editable) {
                this.vertexToMove = SwingUtilities.isLeftMouseButton(mouseEvent) ? this.internalGetVertexFromPosition(mouseEvent.getX(), mouseEvent.getY()) : null;
            }
            this.selAreaRect = null;
            VisualVertex visualVertex = this.internalGetVertexFromPosition(mouseEvent.getX(), mouseEvent.getY());
            if (visualVertex == null && (visualEdge = this.internalGetEdgeFromPosition(mouseEvent.getX(), mouseEvent.getY())) == null) {
                this.deselectAll();
                this.selAreaRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            }
        }
        this.mouseDown = true;
        this.vertexMoved = false;
        this.mousePos.x = mouseEvent.getX();
        this.mousePos.y = mouseEvent.getY();
    }

    private void mouseUp(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        if (this.selTool == Tool.VERTEX && this.editable) {
            this.createVisualVertex(mouseEvent.getX(), mouseEvent.getY());
            this.graphPanel.repaint();
        } else if (this.selTool == Tool.EDGE && this.editable) {
            if (this.edgeToolCtrlPoints.size() > 0 || this.internalGetVertexFromPosition(mouseEvent.getX(), mouseEvent.getY()) != null) {
                if (this.edgeToolCtrlPoints.size() < 1) {
                    this.mousePos.x = mouseEvent.getX();
                    this.mousePos.y = mouseEvent.getY();
                }
                this.edgeToolCtrlPoints.add(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.edgeToolCtrlPoints.size() > 1) {
                    this.createEdgesByPath(this.edgeToolCtrlPoints);
                    this.edgeToolCtrlPoints.clear();
                }
                this.graphPanel.repaint();
            }
        } else if (this.selTool == Tool.CURSOR && this.selectionType != SelectionType.NONE && !this.vertexMoved) {
            if (!this.editable && !this.showCursorToolAlways) {
                return;
            }
            VisualVertex visualVertex = this.internalGetVertexFromPosition(mouseEvent.getX(), mouseEvent.getY());
            if (visualVertex != null && (this.selectionType == SelectionType.VERTICES_ONLY || this.selectionType == SelectionType.BOTH)) {
                this.selectVertex(visualVertex, (mouseEvent.getModifiers() & 2) != 0);
            } else {
                VisualEdge visualEdge = this.internalGetEdgeFromPosition(mouseEvent.getX(), mouseEvent.getY());
                if (visualEdge != null && (this.selectionType == SelectionType.EDGES_ONLY || this.selectionType == SelectionType.BOTH)) {
                    this.selectEdge(visualEdge, (mouseEvent.getModifiers() & 2) != 0);
                }
            }
            if (this.selAreaRect != null && this.selAreaRect.width > 0 && this.selAreaRect.height > 0) {
                if (this.selectionType == SelectionType.VERTICES_ONLY || this.selectionType == SelectionType.BOTH) {
                    this.selectVertices(this.getVerticesFromRect(this.selAreaRect));
                }
                if (this.selectionType == SelectionType.EDGES_ONLY || this.selectionType == SelectionType.BOTH) {
                    this.selectEdges(this.getEdgesFromRect(this.selAreaRect));
                }
            }
            this.graphPanel.repaint();
        }
        this.selAreaRect = null;
        this.mouseDown = false;
        this.vertexToMove = null;
        this.vertexMoved = false;
    }

    private void mouseMove(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        if (this.mouseDown && this.vertexToMove != null && (mouseEvent.getModifiers() & 2) == 0) {
            int n = mouseEvent.getX() - this.mousePos.x;
            int n2 = mouseEvent.getY() - this.mousePos.y;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<VisualVertex> arrayList = new ArrayList<VisualVertex>();
            if (!this.vertexToMove.isSelected()) {
                arrayList.add(0, this.vertexToMove);
                this.deselectAll();
            } else {
                arrayList.addAll(this.selVertices);
            }
            for (VisualVertex serializable : arrayList) {
                int n3 = serializable.getX() + n;
                int n4 = serializable.getY() + n2;
                VisualVertex visualVertex = arrayList.size() == 1 ? this.getVertexOnSameHorAxis(this.vertexToMove, n4, this.vpasTolerance) : null;
                VisualVertex visualVertex2 = arrayList.size() == 1 ? this.getVertexOnSameVerAxis(this.vertexToMove, n3, this.vpasTolerance) : null;
                n3 = visualVertex2 != null ? visualVertex2.getX() : n3;
                int n5 = n4 = visualVertex != null ? visualVertex.getY() : n4;
                if (visualVertex2 != null) {
                    bl = true;
                }
                if (visualVertex != null) {
                    bl2 = true;
                }
                serializable.setPosition(n3, n4);
            }
            if (arrayList.size() == 1) {
                for (VisualEdge visualEdge : this.visualEdges) {
                    if (!visualEdge.dockTo(this.vertexToMove)) continue;
                    this.computeEdgePosition(visualEdge);
                }
                this.computeVertexAttachmentPoints();
            } else {
                this.computeEdgePositions();
            }
            this.computeDynamicEdgeLabeling();
            this.adjustDrawingAreaToVertices();
            if (!bl) {
                this.mousePos.x = mouseEvent.getX();
            }
            if (!bl2) {
                this.mousePos.y = mouseEvent.getY();
            }
            this.vertexMoved = true;
            this.graphPanel.repaint();
        } else if (this.edgeToolCtrlPoints.size() > 0) {
            this.mousePos.x = mouseEvent.getX();
            this.mousePos.y = mouseEvent.getY();
            this.graphPanel.repaint();
        } else if (this.mouseDown && this.selAreaRect != null) {
            if (mouseEvent.getX() < this.mousePos.x) {
                this.selAreaRect.x = mouseEvent.getX();
                this.selAreaRect.width = this.mousePos.x - mouseEvent.getX();
            } else {
                this.selAreaRect.x = this.mousePos.x;
                this.selAreaRect.width = mouseEvent.getX() - this.mousePos.x;
            }
            if (mouseEvent.getY() < this.mousePos.y) {
                this.selAreaRect.y = mouseEvent.getY();
                this.selAreaRect.height = this.mousePos.y - mouseEvent.getY();
            } else {
                this.selAreaRect.y = this.mousePos.y;
                this.selAreaRect.height = mouseEvent.getY() - this.mousePos.y;
            }
            this.graphPanel.repaint();
        }
    }

    private void mouseDblClicked(MouseEvent mouseEvent) {
        if (!this.editable || this.selTool != Tool.CURSOR) {
            return;
        }
        this.showProperties();
    }

    private void addVisualVertex(VisualVertex visualVertex, int n, int n2) {
        visualVertex.setPosition(n, n2);
        visualVertex.setIndex(this.visualVertices.size());
        this.visualVertices.add(visualVertex);
        this.visualVerticesByID.put(((Vertex)visualVertex.getVertex()).getID(), visualVertex);
    }

    private void addVisualEdge(VisualEdge visualEdge) {
        visualEdge.setIndex(this.visualEdges.size());
        this.visualEdges.add(visualEdge);
        this.visualEdgesByID.put(((Edge)visualEdge.getEdge()).getID(), visualEdge);
    }

    private void updateToolBarButtonVisibility() {
        this.cursorBtn.setVisible(this.editable || this.showCursorToolAlways);
        this.addVertexBtn.setVisible(this.editable && !this.hideGraphToolsAlways);
        this.addEdgeBtn.setVisible(this.editable && !this.hideGraphToolsAlways);
        this.deleteObjectBtn.setVisible(this.editable && !this.hideGraphToolsAlways);
        this.showPropertiesBtn.setVisible(this.editable);
        this.zoomInBtn.setVisible(this.editable || this.showZoomToolsAlways);
        this.zoomOutBtn.setVisible(this.editable || this.showZoomToolsAlways);
        this.toolBarSeparators[0].setVisible(this.cursorBtn.isVisible());
        this.toolBarSeparators[1].setVisible(this.addEdgeBtn.isVisible());
        this.toolBarSeparators[2].setVisible(this.deleteObjectBtn.isVisible());
        this.toolBarSeparators[3].setVisible(this.showPropertiesBtn.isVisible());
        this.toolBar.setVisible(this.isToolbarVisible());
    }

    private void internalSetEditable(boolean bl) {
        this.editable = bl;
        if (!bl && this.restorableEditMode && this.nonEditableScene == null) {
            this.nonEditableScene = new GraphScene(this);
            this.nonEditableScene.begin();
        } else if (bl && this.restorableEditMode && this.nonEditableScene != null) {
            this.nonEditableScene.end(false);
            if (!this.graphDataStructureChanged) {
                this.nonEditableScene.reverse();
            }
            this.nonEditableScene = null;
        }
        this.updateToolBarButtonVisibility();
        if (!bl) {
            this.selectTool(Tool.CURSOR);
        }
        this.graphDataStructureChanged = false;
    }

    private void internalSetZoom(int n) {
        if (n < 1) {
            return;
        }
        this.lastZoom = this.zoom;
        this.zoom = n;
        this.radiusOfVertexF = this.radiusOfVertexF / (float)this.lastZoom * (float)this.zoom;
        this.radiusOfVertex = (int)this.radiusOfVertexF;
        this.currEdgeOffsetDistanceF = this.currEdgeOffsetDistanceF / (float)this.lastZoom * (float)this.zoom;
        this.currEdgeOffsetDistance = (int)this.currEdgeOffsetDistanceF;
        this.loopOffsetDistanceF = this.loopOffsetDistanceF / (float)this.lastZoom * (float)this.zoom;
        this.loopOffsetDistance = (int)this.loopOffsetDistanceF;
        this.edgeArrowLengthF = this.edgeArrowLengthF / (float)this.lastZoom * (float)this.zoom;
        this.edgeArrowLength = (int)this.edgeArrowLengthF;
        this.fontSizeF = this.fontSizeF / (float)this.lastZoom * (float)this.zoom;
        this.font = this.font.deriveFont(this.fontSizeF);
        this.adjustPositionsToZoom = true;
        if (this.zoom != 100) {
            this.extendTitle(" (" + this.zoom + "%)");
        } else {
            this.extendTitle("");
        }
    }

    private VisualVertex internalGetVisualVertexByCaption(String string) {
        for (VisualVertex visualVertex : this.visualVertices) {
            if (!((Vertex)visualVertex.getVertex()).getCaption().equals(string)) continue;
            return visualVertex;
        }
        return null;
    }

    private void internalDeselectAll() {
        for (VisualVertex serializable : this.visualVertices) {
            serializable.setSelected(false);
        }
        for (VisualEdge visualEdge : this.visualEdges) {
            visualEdge.setSelected(false);
        }
        this.selVertices.clear();
        this.selEdges.clear();
        this.keyTypedString = "";
    }

    private void internalSetGraph(Graph<V, E> graph) {
        int n;
        this.graph = graph;
        if (this.idObserver != null) {
            this.idObserver.remove();
        }
        this.idObserver = new AccessibleIDObserver(graph){

            @Override
            protected void vertexIDModified(int n, int n2) {
                VisualVertex visualVertex = (VisualVertex)GraphView.this.visualVerticesByID.get(n);
                if (visualVertex != null) {
                    GraphView.this.visualVerticesByID.put(n2, visualVertex);
                }
            }

            @Override
            protected void edgeIDModified(int n, int n2) {
                VisualEdge visualEdge = (VisualEdge)GraphView.this.visualEdgesByID.get(n);
                if (visualEdge != null) {
                    GraphView.this.visualEdgesByID.put(n2, visualEdge);
                }
            }
        };
        this.internalDeselectAll();
        this.visualVertices.clear();
        this.visualVerticesByID.clear();
        this.visualEdges.clear();
        this.visualEdgesByID.clear();
        for (n = 0; n < graph.getOrder(); ++n) {
            this.addVisualVertex(new VisualVertex(this, graph.getVertex(n)), 0, 0);
        }
        for (n = 0; n < graph.getSize(); ++n) {
            this.addVisualEdge(new VisualEdge(this, graph.getEdge(n), this.getVisualVertex(((Edge)graph.getEdge(n)).getPredecessor()), this.getVisualVertex(((Edge)graph.getEdge(n)).getSuccessor())));
        }
        this.computeEdgePositions();
        this.computeDynamicEdgeLabeling();
        this.graphDataStructureChanged = true;
    }

    private void internalLayoutGraph(GraphLayout graphLayout) {
        graphLayout.layout(this.graph, this);
        this.adjustDrawingAreaToVertices();
        this.updateEdgeOffsetIndices();
        this.computeEdgePositions();
        this.computeDynamicEdgeLabeling();
        this.computeVertexAttachmentPoints();
    }

    private <N extends Vertex, L extends Edge> void internalTransferGraph(GraphTransferProtocol<N, L> graphTransferProtocol) {
        GraphTransferProtocol.TransferData transferData;
        int n;
        if (graphTransferProtocol.getClearExistingGraph()) {
            this.removeAllEdges();
            this.removeAllVertices();
        }
        for (n = 0; n < graphTransferProtocol.getGraph().getOrder(); ++n) {
            N n2 = graphTransferProtocol.getGraph().getVertex(n);
            transferData = graphTransferProtocol.getVertexTransferData().get(n);
            if (transferData == null) continue;
            VisualVertex visualVertex = this.getVisualVertexByCaption(((Vertex)n2).getCaption());
            if (visualVertex == null) {
                visualVertex = this.createVisualVertex(0, 0);
            }
            if (visualVertex == null) continue;
            visualVertex.deserialize(transferData);
        }
        for (n = 0; n < graphTransferProtocol.getGraph().getSize(); ++n) {
            VisualVertex visualVertex;
            VisualVertex visualVertex2;
            VisualEdge visualEdge;
            transferData = graphTransferProtocol.getEdgeTransferData().get(n);
            if (transferData == null || (visualEdge = this.createVisualEdge(visualVertex2 = this.getVisualVertexByCaption(((Edge)graphTransferProtocol.getGraph().getEdge(n)).getPredecessor().getCaption()), visualVertex = this.getVisualVertexByCaption(((Edge)graphTransferProtocol.getGraph().getEdge(n)).getSuccessor().getCaption()))) == null) continue;
            visualEdge.deserialize(transferData);
        }
        this.internalSetZoom(graphTransferProtocol.getZoom());
        this.adjustPositionsToZoom = false;
        this.adjustDrawingAreaToVertices();
        this.updateEdgeOffsetIndices();
        this.computeEdgePositions();
        this.computeDynamicEdgeLabeling();
        this.computeVertexAttachmentPoints();
        this.graphDataStructureChanged = true;
    }

    private void internalLoad(String string) throws IOException {
        ObjectFile objectFile = this.createVGF("tmp");
        if (!string.toLowerCase().endsWith(VISUALGRAPHFILE_EXT)) {
            string = string + VISUALGRAPHFILE_EXT;
        }
        ObjectFile objectFile2 = new ObjectFile(string);
        objectFile2.load();
        if (!this.loadVGFData(objectFile2)) {
            this.loadVGFData(objectFile);
            throw new IOException("Invalid data in file!");
        }
        this.graphDataStructureChanged = true;
    }

    private boolean loadVGFData(ObjectFile objectFile) {
        Serializer serializer;
        int n;
        this.loadingVGF = true;
        this.deselectAll();
        this.removeAllEdges();
        this.removeAllVertices();
        for (n = 0; n < objectFile.getSerializerCount("vertex"); ++n) {
            VisualVertex visualVertex = this.createVisualVertex(0, 0);
            serializer = objectFile.getSerializer(visualVertex, "vertex");
            VisualVertex visualVertex2 = this.getVisualVertexByCaption(serializer.getString("caption"));
            if (visualVertex2 != null && visualVertex2 != visualVertex) {
                this.removeVisualVertex(visualVertex);
                objectFile.updateObject(serializer.getID(), visualVertex2);
                visualVertex = visualVertex2;
            }
            if (visualVertex == null) continue;
            visualVertex.deserialize(serializer);
        }
        for (n = 0; n < objectFile.getSerializerCount("edge"); ++n) {
            serializer = objectFile.getSerializer(new VisualEdge(this), "edge");
            VisualVertex visualVertex = (VisualVertex)objectFile.getObject(serializer.getInt("vertex1"));
            VisualVertex visualVertex3 = (VisualVertex)objectFile.getObject(serializer.getInt("vertex2"));
            if (visualVertex == null || visualVertex3 == null) {
                return false;
            }
            VisualEdge visualEdge = this.createVisualEdge(visualVertex, visualVertex3);
            if (visualEdge == null) continue;
            visualEdge.deserialize(serializer);
        }
        this.deserialize(objectFile.getSerializer(this, "graphView"));
        this.loadingVGF = false;
        this.computeEdgePositions();
        this.updateEdgeOffsetIndices();
        this.adjustDrawingAreaToVertices();
        this.adjustPositionsToZoom = false;
        return true;
    }

    private void internalSave(String string) throws IOException {
        ObjectFile objectFile = this.createVGF(string);
        objectFile.save();
    }

    private ObjectFile createVGF(String string) {
        this.deselectAll();
        if (!string.toLowerCase().endsWith(VISUALGRAPHFILE_EXT)) {
            string = string + VISUALGRAPHFILE_EXT;
        }
        ObjectFile objectFile = new ObjectFile(string);
        for (VisualVertex serializable : this.visualVertices) {
            serializable.serialize(objectFile.getSerializer(serializable, "vertex"));
        }
        for (VisualEdge visualEdge : this.visualEdges) {
            Serializer serializer = objectFile.getSerializer(visualEdge, "edge");
            visualEdge.serialize(serializer);
            serializer.addInt("vertex1", objectFile.getSerializer(visualEdge.getPredecessor(), "vertex").getID());
            serializer.addInt("vertex2", objectFile.getSerializer(visualEdge.getSuccessor(), "vertex").getID());
        }
        this.serialize(objectFile.getSerializer(this, "graphView"));
        return objectFile;
    }

    private void internalSaveAsPNG(String string) throws IOException {
        this.deselectAll();
        if (!string.toLowerCase().endsWith(".png")) {
            string = string + ".png";
        }
        Dimension dimension = this.graphPanel.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.fill(new Rectangle(dimension));
        this.paint(graphics2D, false);
        ImageIO.write((RenderedImage)bufferedImage, "png", FileUtils.createFilePath(string));
    }

    private void internalResetVisualAppearance() {
        for (VisualVertex serializable : this.visualVertices) {
            serializable.setBackground(DEF_VERTEXBACKGROUND);
            serializable.setForeground(DEF_VERTEXFOREGROUND);
            serializable.setEdgeWidth(1);
        }
        for (VisualEdge visualEdge : this.visualEdges) {
            visualEdge.setColor(DEF_EDGECOLOR);
            visualEdge.setLineWidth(1);
        }
    }

    private VisualVertex internalGetVertexFromPosition(int n, int n2) {
        for (int i = this.visualVertices.size() - 1; i >= 0; --i) {
            int n3;
            VisualVertex visualVertex = this.visualVertices.get(i);
            int n4 = this.internalGetScaledVertexRadius(visualVertex);
            int n5 = visualVertex.getX() - n;
            if (n5 * n5 + (n3 = visualVertex.getY() - n2) * n3 > n4 * n4) continue;
            return visualVertex;
        }
        return null;
    }

    private VisualEdge internalGetEdgeFromPosition(int n, int n2) {
        for (VisualEdge visualEdge : this.visualEdges) {
            if (!visualEdge.getSpline().contains(n, n2, 3)) continue;
            return visualEdge;
        }
        return null;
    }

    private int internalGetScaledVertexRadius(VisualVertex visualVertex) {
        if (visualVertex == null) {
            return 0;
        }
        if (visualVertex.getScale() == 1.0f) {
            return this.radiusOfVertex;
        }
        return (int)((float)this.radiusOfVertex * visualVertex.getScale());
    }

    private String getFreeVertexName() {
        int n = 1;
        while (true) {
            boolean bl = false;
            for (VisualVertex visualVertex : this.visualVertices) {
                if (!((Vertex)visualVertex.getVertex()).getCaption().equalsIgnoreCase("" + n)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return "" + n;
            }
            ++n;
        }
    }

    private void createEdgesByPath(List<Point> list) {
        VisualVertex visualVertex = null;
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            VisualVertex visualVertex2 = this.internalGetVertexFromPosition(point.x, point.y);
            if (visualVertex2 == null) continue;
            if (visualVertex != null) {
                this.createVisualEdge(visualVertex, visualVertex2);
            }
            visualVertex = visualVertex2;
        }
    }

    private List<VisualVertex> getVerticesFromRect(Rectangle rectangle) {
        ArrayList<VisualVertex> arrayList = new ArrayList<VisualVertex>();
        for (VisualVertex visualVertex : this.visualVertices) {
            if (!rectangle.contains(visualVertex.getX(), visualVertex.getY())) continue;
            arrayList.add(visualVertex);
        }
        return arrayList;
    }

    private VisualVertex getVertexOnSameHorAxis(VisualVertex visualVertex, int n, int n2) {
        for (VisualVertex visualVertex2 : this.visualVertices) {
            if (visualVertex2 == visualVertex || Math.abs(visualVertex2.getY() - n) > n2) continue;
            return visualVertex2;
        }
        return null;
    }

    private VisualVertex getVertexOnSameVerAxis(VisualVertex visualVertex, int n, int n2) {
        for (VisualVertex visualVertex2 : this.visualVertices) {
            if (visualVertex2 == visualVertex || Math.abs(visualVertex2.getX() - n) > n2) continue;
            return visualVertex2;
        }
        return null;
    }

    private List<VisualEdge> getEdgesFromRect(Rectangle rectangle) {
        ArrayList<VisualEdge> arrayList = new ArrayList<VisualEdge>();
        for (VisualEdge visualEdge : this.visualEdges) {
            if (!rectangle.contains(visualEdge.getX1(), visualEdge.getY1()) || !rectangle.contains(visualEdge.getX2(), visualEdge.getY2())) continue;
            arrayList.add(visualEdge);
        }
        return arrayList;
    }

    private void internalSelectVertex(VisualVertex visualVertex, boolean bl, boolean bl2) {
        if (!bl) {
            this.deselectAll();
        }
        visualVertex.setSelected(!bl2 || !visualVertex.isSelected());
        if (visualVertex.isSelected()) {
            this.selVertices.add(visualVertex);
            this.fireVertexSelected(visualVertex);
        } else {
            this.selVertices.remove(visualVertex);
        }
        this.keyTypedString = "";
    }

    private void internalSelectEdge(VisualEdge visualEdge, boolean bl, boolean bl2) {
        if (!bl) {
            this.deselectAll();
        }
        visualEdge.setSelected(!bl2 || !visualEdge.isSelected());
        if (visualEdge.isSelected()) {
            this.selEdges.add(visualEdge);
            this.fireEdgeSelected(visualEdge);
        } else {
            this.selEdges.remove(visualEdge);
        }
        this.keyTypedString = "";
    }

    private void checkVisibilityOfVertices() {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        for (VisualVertex visualVertex : this.visualVertices) {
            int n = this.internalGetScaledVertexRadius(visualVertex);
            int n2 = 0;
            if (visualVertex.getX() + n < rectangle.x) {
                n2 |= 2;
            }
            if (visualVertex.getX() - n > rectangle.x + rectangle.width) {
                n2 |= 4;
            }
            if (visualVertex.getY() + n < rectangle.y) {
                n2 |= 8;
            }
            if (visualVertex.getY() - n > rectangle.y + rectangle.height) {
                n2 |= 0x10;
            }
            visualVertex.setVisibilityFlags(n2 == 0 ? 1 : n2);
        }
    }

    private boolean isVertexInViewport(VisualVertex visualVertex) {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        int n = this.internalGetScaledVertexRadius(visualVertex);
        Rectangle rectangle2 = new Rectangle(visualVertex.getX() - n, visualVertex.getY() - n, n * 2, n * 2);
        return rectangle.contains(rectangle2);
    }

    private void ensureVertexVisibility(VisualVertex visualVertex) {
        if (this.isVertexInViewport(visualVertex)) {
            return;
        }
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        this.scrollPane.getViewport().setViewPosition(new Point(visualVertex.getX() - rectangle.width / 2, visualVertex.getY() - rectangle.height / 2));
    }

    private boolean isEdgeInViewport(VisualEdge visualEdge) {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return rectangle.contains(visualEdge.getPredecessor().getX(), visualEdge.getPredecessor().getY()) && rectangle.contains(visualEdge.getSupportX(), visualEdge.getSupportY()) && rectangle.contains(visualEdge.getSuccessor().getX(), visualEdge.getSuccessor().getY());
    }

    private void ensureEdgeVisibility(VisualEdge visualEdge) {
        if (this.isEdgeInViewport(visualEdge)) {
            return;
        }
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        this.scrollPane.getViewport().setViewPosition(new Point(visualEdge.getSupportX() - rectangle.width / 2, visualEdge.getSupportY() - rectangle.height / 2));
    }

    private boolean isToolbarVisible() {
        return this.editable || this.showZoomToolsAlways || this.showCursorToolAlways;
    }

    private void updateEdgeOffsetIndices() {
        boolean bl = false;
        for (VisualVertex visualVertex : this.visualVertices) {
            for (VisualVertex visualVertex2 : this.visualVertices) {
                List<EdgeOffset> list = this.requestOffsetEdges(visualVertex, visualVertex2);
                if (list == null) continue;
                for (EdgeOffset edgeOffset : list) {
                    VisualEdge visualEdge = this.visualEdgesByID.get(((Edge)edgeOffset.edge).getID());
                    if (visualEdge == null) continue;
                    int n = visualEdge.getOffsetIndex();
                    visualEdge.setOffsetIndex(edgeOffset.offset);
                    if (n == edgeOffset.offset) continue;
                    this.computeEdgePosition(visualEdge);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.computeVertexAttachmentPoints();
        }
    }

    private void computeEdgePositions() {
        for (VisualEdge visualEdge : this.visualEdges) {
            this.computeEdgePosition(visualEdge);
        }
        this.computeDynamicEdgeLabeling();
        this.computeVertexAttachmentPoints();
    }

    private void computeEdgePosition(VisualEdge visualEdge) {
        int n;
        if (!((Edge)visualEdge.getEdge()).isLoop()) {
            float f;
            int n2 = this.currEdgeOffsetDistance * visualEdge.getOffsetIndex();
            int n3 = visualEdge.getOffsetIndex() < 0 ? -1 : 1;
            int n4 = visualEdge.getPredecessor().getX();
            int n5 = visualEdge.getPredecessor().getY();
            int n6 = visualEdge.getSuccessor().getX();
            int n7 = visualEdge.getSuccessor().getY();
            float f2 = (n6 - n4) / 2;
            float f3 = f = (float)((n7 - n5) / 2);
            float f4 = -f2;
            double d = (double)n3 * Math.sqrt((float)(n2 * n2) / (f3 * f3 + f4 * f4));
            visualEdge.setSupportX((int)((double)((float)n4 + f2) + d * (double)f3));
            visualEdge.setSupportY((int)((double)((float)n5 + f) + d * (double)f4));
        } else {
            n = this.internalGetScaledVertexRadius(visualEdge.getPredecessor());
            visualEdge.setSupportX(visualEdge.getPredecessor().getX());
            visualEdge.setSupportY(visualEdge.getPredecessor().getY() - n - Math.abs(visualEdge.getOffsetIndex()) * this.currEdgeOffsetDistance);
        }
        n = this.internalGetScaledVertexRadius(visualEdge.getPredecessor());
        int n8 = visualEdge.getSupportX() - visualEdge.getPredecessor().getX();
        int n9 = visualEdge.getSupportY() - visualEdge.getPredecessor().getY();
        double d = Math.sqrt(n8 * n8 + n9 * n9);
        int n10 = (int)((double)n8 / d * (double)(n + visualEdge.getPredecessor().getEdgeWidth() + 1));
        int n11 = (int)((double)n9 / d * (double)(n + visualEdge.getPredecessor().getEdgeWidth() + 1));
        visualEdge.setX1(visualEdge.getPredecessor().getX() + n10);
        visualEdge.setY1(visualEdge.getPredecessor().getY() + n11);
        n = this.internalGetScaledVertexRadius(visualEdge.getSuccessor());
        n8 = visualEdge.getSuccessor().getX() - visualEdge.getSupportX();
        n9 = visualEdge.getSuccessor().getY() - visualEdge.getSupportY();
        d = Math.sqrt(n8 * n8 + n9 * n9);
        n10 = (int)((double)n8 / d * (double)(n + visualEdge.getSuccessor().getEdgeWidth() + 1));
        n11 = (int)((double)n9 / d * (double)(n + visualEdge.getSuccessor().getEdgeWidth() + 1));
        visualEdge.setX2(visualEdge.getSuccessor().getX() - n10);
        visualEdge.setY2(visualEdge.getSuccessor().getY() - n11);
        visualEdge.createSpline();
        visualEdge.setLabelPosition(visualEdge.getSupportX(), visualEdge.getSupportY());
    }

    private void computeDynamicEdgeLabeling() {
        SplineIntersectionPoint splineIntersectionPoint;
        if (!this.dynamicEdgeLabeling) {
            return;
        }
        SplineIntersectionPoint[][] splineIntersectionPointArray = new SplineIntersectionPoint[this.visualEdges.size()][this.visualEdges.size()];
        boolean[] blArray = new boolean[this.visualEdges.size()];
        for (final VisualEdge visualEdge : this.visualEdges) {
            for (VisualEdge object2 : this.visualEdges) {
                if (visualEdge == object2 || splineIntersectionPointArray[visualEdge.getIndex()][object2.getIndex()] != null) continue;
                splineIntersectionPoint = visualEdge.getSpline().intersect(object2.getSpline());
                if (splineIntersectionPoint == null) {
                    splineIntersectionPoint = new SplineIntersectionPoint(visualEdge.getSpline(), object2.getSpline(), 0, 0, -1, -1);
                } else {
                    blArray[object2.getIndex()] = true;
                    blArray[visualEdge.getIndex()] = true;
                }
                SplineIntersectionPoint splineIntersectionPoint2 = splineIntersectionPoint;
                splineIntersectionPointArray[object2.getIndex()][visualEdge.getIndex()] = splineIntersectionPoint2;
                splineIntersectionPointArray[visualEdge.getIndex()][object2.getIndex()] = splineIntersectionPoint2;
            }
        }
        for (int i = 0; i < this.visualEdges.size(); ++i) {
            Object object;
            Point point;
            int n;
            VisualEdge visualEdge;
            visualEdge = this.visualEdges.get(i);
            if (!blArray[visualEdge.getIndex()]) {
                visualEdge.setLabelPosition(visualEdge.getSupportX(), visualEdge.getSupportY());
                continue;
            }
            ArrayList<SplineIntersectionPoint> arrayList = new ArrayList<SplineIntersectionPoint>(5);
            for (n = 0; n < this.visualEdges.size(); ++n) {
                splineIntersectionPoint = splineIntersectionPointArray[visualEdge.getIndex()][n];
                if (splineIntersectionPoint == null || splineIntersectionPoint.getSegmentIndexOfSpline1() == -1) continue;
                arrayList.add(splineIntersectionPoint);
            }
            if (visualEdge.getOffsetIndex() == 0) {
                final Point point2 = new Point(visualEdge.getX1(), visualEdge.getY1());
                Point point3 = new Point(visualEdge.getX2(), visualEdge.getY2());
                Collections.sort(arrayList, new Comparator<SplineIntersectionPoint>(){

                    @Override
                    public int compare(SplineIntersectionPoint splineIntersectionPoint, SplineIntersectionPoint splineIntersectionPoint2) {
                        return (int)Point.distanceSq(point2.x, point2.y, splineIntersectionPoint.x, splineIntersectionPoint.y) - (int)Point.distanceSq(point2.x, point2.y, splineIntersectionPoint2.x, splineIntersectionPoint2.y);
                    }
                });
                Point point4 = point2;
                Point point5 = point2;
                point = point4;
                double d = 0.0;
                for (int j = 0; j <= arrayList.size(); ++j) {
                    Point point6 = j < arrayList.size() ? (Point)arrayList.get(j) : point3;
                    double d2 = Point.distanceSq(point.x, point.y, point6.x, point6.y);
                    if (d2 > d) {
                        point4 = point;
                        point5 = point6;
                        d = d2;
                    }
                    point = point6;
                }
                object = new Point2D.Float((point4.x + point5.x) / 2, (point4.y + point5.y) / 2);
            } else {
                Collections.sort(arrayList, new Comparator<SplineIntersectionPoint>(){

                    @Override
                    public int compare(SplineIntersectionPoint splineIntersectionPoint, SplineIntersectionPoint splineIntersectionPoint2) {
                        if (visualEdge.getSpline() == splineIntersectionPoint.getSpline1()) {
                            return splineIntersectionPoint.getSegmentIndexOfSpline1() - splineIntersectionPoint2.getSegmentIndexOfSpline1();
                        }
                        return splineIntersectionPoint.getSegmentIndexOfSpline2() - splineIntersectionPoint2.getSegmentIndexOfSpline2();
                    }
                });
                n = 0;
                int n2 = 0;
                int n3 = 0;
                for (int j = 0; j <= arrayList.size(); ++j) {
                    Point point7 = point = j < arrayList.size() ? (SplineIntersectionPoint)arrayList.get(j) : null;
                    int n4 = point != null ? (visualEdge.getSpline() == ((SplineIntersectionPoint)point).getSpline1() ? ((SplineIntersectionPoint)point).getSegmentIndexOfSpline1() : ((SplineIntersectionPoint)point).getSegmentIndexOfSpline2()) : visualEdge.getSpline().getPoints().length - 1;
                    if (n4 - n3 > n2 - n) {
                        n = n3;
                        n2 = n4;
                    }
                    n3 = n4;
                }
                object = visualEdge.getSpline().getPoints()[(n + n2) / 2];
            }
            visualEdge.setLabelPosition((int)((Point2D.Float)object).x, (int)((Point2D.Float)object).y);
        }
    }

    private void computeVertexAttachmentPoints() {
        for (VisualVertex visualVertex : this.visualVertices) {
            this.computeVertexAttachmentPoint(visualVertex);
        }
    }

    private void computeVertexAttachmentPoint(VisualVertex visualVertex) {
        int n = this.internalGetScaledVertexRadius(visualVertex);
        Object v = visualVertex.getVertex();
        if (((Vertex)v).getIncidentEdgeCount() < 1) {
            visualVertex.setAttachmentPosition(visualVertex.getX(), visualVertex.getY() + n);
        } else if (((Vertex)v).getIncidentEdgeCount() < 2) {
            VisualEdge visualEdge = this.visualEdgesByID.get(((Vertex)v).getIncidentEdge(0).getID());
            if (visualEdge != null) {
                int n2 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getX1() : visualEdge.getX2();
                int n3 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getY1() : visualEdge.getY2();
                visualVertex.setAttachmentPosition(n2 + 2 * (visualVertex.getX() - n2), n3 + 2 * (visualVertex.getY() - n3));
            }
        } else {
            int n4;
            VisualEdge visualEdge = this.visualEdgesByID.get(((Vertex)v).getIncidentEdge(0).getID());
            int n5 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getX1() : visualEdge.getX2();
            int n6 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getY1() : visualEdge.getY2();
            int n7 = n5 - visualVertex.getX();
            int n8 = n6 - visualVertex.getY();
            double d = Math.sqrt(n7 * n7 + n8 * n8);
            ArrayList<AttachmentPointData> arrayList = new ArrayList<AttachmentPointData>(((Vertex)v).getIncidentEdgeCount());
            arrayList.add(new AttachmentPointData(0.0, n5, n6));
            for (int i = 1; i < ((Vertex)v).getIncidentEdgeCount(); ++i) {
                visualEdge = this.visualEdgesByID.get(((Vertex)v).getIncidentEdge(i).getID());
                if (visualEdge == null) continue;
                int n9 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getX1() : visualEdge.getX2();
                int n10 = ((Edge)visualEdge.getEdge()).getPredecessor() == v ? visualEdge.getY1() : visualEdge.getY2();
                int n11 = n9 - visualVertex.getX();
                int n12 = n10 - visualVertex.getY();
                double d2 = Math.toDegrees(Math.acos((double)(n7 * n11 + n8 * n12) / (d * Math.sqrt(n11 * n11 + n12 * n12))));
                if (MathUtils.ccw(visualVertex.getX(), visualVertex.getY(), n5, n6, n9, n10) < 0) {
                    d2 = 360.0 - d2;
                }
                arrayList.add(new AttachmentPointData(d2, n9, n10));
            }
            Collections.sort(arrayList, new Comparator<AttachmentPointData>(){

                @Override
                public int compare(AttachmentPointData attachmentPointData, AttachmentPointData attachmentPointData2) {
                    if (attachmentPointData.angle < attachmentPointData2.angle) {
                        return -1;
                    }
                    if (attachmentPointData.angle > attachmentPointData2.angle) {
                        return 1;
                    }
                    return 0;
                }
            });
            AttachmentPointData attachmentPointData = null;
            AttachmentPointData attachmentPointData2 = null;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n4 = 1; n4 <= arrayList.size(); ++n4) {
                AttachmentPointData attachmentPointData3 = (AttachmentPointData)arrayList.get(n4 - 1);
                AttachmentPointData attachmentPointData4 = n4 < arrayList.size() ? (AttachmentPointData)arrayList.get(n4) : (AttachmentPointData)arrayList.get(0);
                double d5 = n4 < arrayList.size() ? attachmentPointData4.angle : 360.0;
                double d6 = Math.PI * (double)n * ((d5 - attachmentPointData3.angle) / 180.0);
                if (!(d6 > d3)) continue;
                d3 = d6;
                d4 = d5 - attachmentPointData3.angle;
                attachmentPointData = attachmentPointData3;
                attachmentPointData2 = attachmentPointData4;
            }
            if (attachmentPointData == null || attachmentPointData2 == null) {
                visualVertex.setAttachmentPosition(visualVertex.getX(), visualVertex.getY());
            } else {
                n4 = attachmentPointData.circlepoint_x - visualVertex.getX();
                int n13 = attachmentPointData.circlepoint_y - visualVertex.getY();
                int n14 = attachmentPointData2.circlepoint_x - visualVertex.getX();
                int n15 = attachmentPointData2.circlepoint_y - visualVertex.getY();
                int n16 = n4 + n14;
                int n17 = n13 + n15;
                if (n16 == 0 && n17 == 0 || d4 > 179.999999 && d4 < 180.000001) {
                    n16 = -n13;
                    n17 = n4;
                }
                double d7 = Math.sqrt((double)(n * n) / (double)(n16 * n16 + n17 * n17));
                if (MathUtils.ccw(visualVertex.getX(), visualVertex.getY(), attachmentPointData.circlepoint_x, attachmentPointData.circlepoint_y, attachmentPointData2.circlepoint_x, attachmentPointData2.circlepoint_y) < 0) {
                    d7 *= -1.0;
                }
                visualVertex.setAttachmentPosition(visualVertex.getX() + (int)(d7 * (double)n16), visualVertex.getY() + (int)(d7 * (double)n17));
            }
        }
    }

    private void loadVertexProperties(PropertiesListModel propertiesListModel, V v) {
        TextProperty textProperty = new TextProperty(this.vertexPropCaption, "", ((Vertex)v).getCaption());
        propertiesListModel.add(textProperty);
        this.loadAdvancedVertexProperties(propertiesListModel, v);
    }

    private void applyVertexProperties(PropertiesListModel propertiesListModel, V v) {
        TextProperty textProperty = propertiesListModel.getTextProperty(this.vertexPropCaption);
        if (textProperty != null) {
            ((Vertex)v).setCaption(textProperty.getValue());
        }
        this.applyAdvancedVertexProperties(propertiesListModel, v);
    }

    private void loadEdgeProperties(PropertiesListModel propertiesListModel, E e) {
        String string;
        switch (this.graph.getType()) {
            case DIRECTED: {
                string = this.edgePropDirectedDescDG;
                break;
            }
            case UNDIRECTED: {
                string = this.edgePropDirectedDescUDG;
                break;
            }
            default: {
                string = "";
            }
        }
        NumericProperty numericProperty = new NumericProperty(this.edgePropWeight, "", Float.valueOf(((Edge)e).getWeight()));
        BooleanProperty booleanProperty = new BooleanProperty(this.edgePropDirected, string, ((Edge)e).isDirected());
        propertiesListModel.add(numericProperty);
        propertiesListModel.add(booleanProperty);
        this.loadAdvancedEdgeProperties(propertiesListModel, e);
    }

    private void applyEdgeProperties(PropertiesListModel propertiesListModel, E e) {
        BooleanProperty booleanProperty;
        NumericProperty numericProperty = propertiesListModel.getNumericProperty(this.edgePropWeight);
        if (numericProperty != null) {
            ((Edge)e).setWeight(numericProperty.getValue().floatValue());
        }
        if ((booleanProperty = propertiesListModel.getBooleanProperty(this.edgePropDirected)) != null) {
            ((Edge)e).setDirected(booleanProperty.getValue());
        }
        this.applyAdvancedEdgeProperties(propertiesListModel, e);
    }

    private void fireVertexAdded(VisualVertex visualVertex) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.vertexAdded(visualVertex);
        }
    }

    private void fireVertexRemoved(VisualVertex visualVertex) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.vertexRemoved(visualVertex);
        }
    }

    private void fireVertexSelected(VisualVertex visualVertex) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.vertexSelected(visualVertex);
        }
    }

    private void fireEdgeAdded(VisualEdge visualEdge) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.edgeAdded(visualEdge);
        }
    }

    private void fireEdgeRemoved(VisualEdge visualEdge) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.edgeRemoved(visualEdge);
        }
    }

    private void fireEdgeSelected(VisualEdge visualEdge) {
        for (GraphViewListener<V, E> graphViewListener : this.listeners) {
            graphViewListener.edgeSelected(visualEdge);
        }
    }

    private void changeToolBarOrientation(String string) {
        this.content.remove(this.toolBar);
        switch (string) {
            case "North": 
            case "South": {
                this.toolBar.setOrientation(0);
                break;
            }
            case "East": 
            case "West": {
                this.toolBar.setOrientation(1);
                break;
            }
            default: {
                this.toolBar.setOrientation(1);
                string = "West";
            }
        }
        this.content.add((Component)this.toolBar, string);
    }

    private void showProperties() {
        if (!this.editable) {
            return;
        }
        int n = this.selVertices.size() + this.selEdges.size();
        if (n != 1) {
            JOptionPane.showMessageDialog(this, this.showPropsInfoMsg, this.showPropsInfoTitle, 1);
            return;
        }
        if (this.selVertices.size() > 0) {
            this.vertexPropsDlg.show(this.selVertices.get(0));
        } else if (this.selEdges.size() > 0) {
            this.edgePropsDlg.show(this.selEdges.get(0));
        }
    }

    private void deleteSelectedObjects() {
        if (!this.editable) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, this.deleteObjectsWarningMsg, this.deleteObjectsWarningTitle, 0, 2) == 0) {
            int n;
            for (n = this.selEdges.size() - 1; n >= 0; --n) {
                this.removeVisualEdge(this.selEdges.get(n));
            }
            for (n = this.selVertices.size() - 1; n >= 0; --n) {
                this.removeVisualVertex(this.selVertices.get(n));
            }
            this.graphPanel.repaint();
        }
    }

    private void adjustObjectsToZoom() {
        for (VisualVertex object : this.visualVertices) {
            object.setPosition((int)((float)object.getX() / (float)this.lastZoom * (float)this.zoom), (int)((float)object.getY() / (float)this.lastZoom * (float)this.zoom));
        }
        for (CustomVisualObject customVisualObject : this.customVisualObjects) {
            customVisualObject.setX((int)((float)customVisualObject.getX() / (float)this.lastZoom * (float)this.zoom + 0.5f));
            customVisualObject.setY((int)((float)customVisualObject.getY() / (float)this.lastZoom * (float)this.zoom + 0.5f));
            customVisualObject.setWidth((int)((float)customVisualObject.getWidth() / (float)this.lastZoom * (float)this.zoom));
            customVisualObject.setHeight((int)((float)customVisualObject.getHeight() / (float)this.lastZoom * (float)this.zoom));
        }
        this.computeEdgePositions();
        this.adjustDrawingAreaToVertices();
    }

    private void adjustDrawingAreaToVertices() {
        int n = 0;
        int n2 = 0;
        for (VisualVertex visualVertex : this.visualVertices) {
            int n3 = this.internalGetScaledVertexRadius(visualVertex);
            int n4 = visualVertex.getX() + n3;
            int n5 = visualVertex.getY() + n3;
            if (n4 > n) {
                n = n4;
            }
            if (n5 <= n2) continue;
            n2 = n5;
        }
        this.drawingArea.width = n += 100;
        this.drawingArea.height = n2 += 100;
        this.graphPanel.setPreferredSize(this.drawingArea);
        this.graphPanel.revalidate();
    }

    private void paint(Graphics2D graphics2D, boolean bl) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (this.adjustPositionsToZoom) {
            this.adjustObjectsToZoom();
            this.adjustPositionsToZoom = false;
        }
        this.checkVisibilityOfVertices();
        this.beforePaint(graphics2D);
        this.drawEdges(graphics2D, bl);
        this.drawVertices(graphics2D, bl);
        for (CustomVisualObject customVisualObject : this.customVisualObjects) {
            customVisualObject.draw(graphics2D, this.font);
        }
        if (this.edgeToolCtrlPoints.size() > 0) {
            this.drawEdgeToolPath(graphics2D);
        }
        if (this.selAreaRect != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.selAreaStroke);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.selAreaRect);
            graphics2D.setStroke(stroke);
        }
    }

    private void drawVertices(Graphics2D graphics2D, boolean bl) {
        for (VisualVertex visualVertex : this.visualVertices) {
            if (bl && !visualVertex.isVisible()) continue;
            int n = this.internalGetScaledVertexRadius(visualVertex);
            int n2 = visualVertex.getX() - n;
            int n3 = visualVertex.getY() - n;
            this.vertexRenderer.setBackground(visualVertex.getBackground());
            this.vertexRenderer.setForeground(visualVertex.isSelected() ? this.selectionColor : visualVertex.getForeground());
            this.vertexRenderer.setPositionCenter(visualVertex.getX(), visualVertex.getY());
            this.vertexRenderer.setPositionLeftTop(n2, n3);
            this.vertexRenderer.setDiameter(n * 2);
            this.vertexRenderer.setFont(this.font);
            this.vertexRenderer.setEdgeWidth(visualVertex.getEdgeWidth());
            this.vertexRenderer.setAttachmentPoint(visualVertex.getAttachmentX(), visualVertex.getAttachmentY());
            this.vertexRenderer.draw(graphics2D, visualVertex.getVertex());
        }
    }

    private void drawEdges(Graphics2D graphics2D, boolean bl) {
        for (VisualEdge visualEdge : this.visualEdges) {
            if (bl && !visualEdge.isVisible()) continue;
            this.edgeRenderer.setBackground(visualEdge.getColor());
            this.edgeRenderer.setForeground(visualEdge.isSelected() ? this.selectionColor : visualEdge.getColor());
            this.edgeRenderer.setDrawArrow(((Edge)visualEdge.getEdge()).isDirected());
            this.edgeRenderer.setFirstPosition(visualEdge.getX1(), visualEdge.getY1());
            this.edgeRenderer.setSecondPosition(visualEdge.getX2(), visualEdge.getY2());
            this.edgeRenderer.setControlPosition(visualEdge.getSupportX(), visualEdge.getSupportY());
            this.edgeRenderer.setFont(this.font);
            this.edgeRenderer.setLineWidth(visualEdge.getLineWidth());
            this.edgeRenderer.setArrowLength(this.edgeArrowLength);
            this.edgeRenderer.setLabelPosition(visualEdge.getLabelX(), visualEdge.getLabelY());
            this.edgeRenderer.setSpline(visualEdge.getSpline());
            this.edgeRenderer.draw(graphics2D, visualEdge.getEdge());
        }
    }

    private void drawEdgeToolPath(Graphics2D graphics2D) {
        for (int i = 0; i < this.edgeToolCtrlPoints.size(); ++i) {
            Point point = this.edgeToolCtrlPoints.get(i);
            Point point2 = i < this.edgeToolCtrlPoints.size() - 1 ? this.edgeToolCtrlPoints.get(i + 1) : this.mousePos;
            graphics2D.setColor(this.edgeToolColor);
            graphics2D.drawOval(point.x - 3, point.y - 3, 6, 6);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    private class EventController
    implements MouseListener,
    MouseMotionListener,
    ActionListener,
    KeyListener {
        private EventController() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                GraphView.this.mouseDblClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GraphView.this.mouseDown(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            GraphView.this.mouseUp(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            GraphView.this.mouseMove(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            GraphView.this.mouseMove(mouseEvent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GraphView.this.cursorBtn) {
                GraphView.this.selectTool(Tool.CURSOR);
            } else if (actionEvent.getSource() == GraphView.this.addVertexBtn) {
                GraphView.this.selectTool(Tool.VERTEX);
            } else if (actionEvent.getSource() == GraphView.this.addEdgeBtn) {
                GraphView.this.selectTool(Tool.EDGE);
            } else if (actionEvent.getSource() == GraphView.this.deleteObjectBtn) {
                GraphView.this.deleteSelectedObjects();
            } else if (actionEvent.getSource() == GraphView.this.showPropertiesBtn) {
                GraphView.this.showProperties();
            } else if (actionEvent.getSource() == GraphView.this.zoomInBtn) {
                GraphView.this.zoomIn();
            } else if (actionEvent.getSource() == GraphView.this.zoomOutBtn) {
                GraphView.this.zoomOut();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            GraphView.this.keyReleased(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            GraphView.this.keyTyped(keyEvent);
        }
    }

    private class EdgePropertiesDialog
    extends PropertiesDialog<VisualEdge> {
        public EdgePropertiesDialog(LanguageFile languageFile, String string) {
            super(languageFile, string);
            this.setTitle(LanguageFile.getLabel(languageFile, "GRAPHVIEW_PROPERTIESDLG_EDGE_TITLE", string, "Edge Properties"));
        }

        @Override
        protected void applyObjectProperties(PropertiesListModel propertiesListModel, VisualEdge visualEdge) {
            GraphView.this.applyEdgeProperties(propertiesListModel, visualEdge.getEdge());
        }

        @Override
        protected void loadObjectProperties(PropertiesListModel propertiesListModel, VisualEdge visualEdge) {
            GraphView.this.loadEdgeProperties(propertiesListModel, visualEdge.getEdge());
        }
    }

    private class VertexPropertiesDialog
    extends PropertiesDialog<VisualVertex> {
        public VertexPropertiesDialog(LanguageFile languageFile, String string) {
            super(languageFile, string);
            this.setTitle(LanguageFile.getLabel(languageFile, "GRAPHVIEW_PROPERTIESDLG_VERTEX_TITLE", string, "Vertex Properties"));
        }

        @Override
        protected void applyObjectProperties(PropertiesListModel propertiesListModel, VisualVertex visualVertex) {
            GraphView.this.applyVertexProperties(propertiesListModel, visualVertex.getVertex());
        }

        @Override
        protected void loadObjectProperties(PropertiesListModel propertiesListModel, VisualVertex visualVertex) {
            GraphView.this.loadVertexProperties(propertiesListModel, visualVertex.getVertex());
        }
    }

    private abstract class PropertiesDialog<T>
    extends PopupWindow {
        private final PropertiesList list;
        private final JButton okBtn;
        private final JButton cancelBtn;
        private T currObject = null;

        public PropertiesDialog(LanguageFile languageFile, String string) {
            this.setSize(180, 180);
            JPanel jPanel = new JPanel();
            this.list = new PropertiesList(null);
            this.okBtn = new JButton(LanguageFile.getLabel(languageFile, "DLG_BTN_OK", string, "Ok"));
            this.cancelBtn = new JButton(LanguageFile.getLabel(languageFile, "DLG_BTN_CANCEL", string, "Cancel"));
            this.content.setLayout(new BorderLayout());
            jPanel.setLayout(new FlowLayout(2));
            this.content.add((Component)this.list, "Center");
            this.content.add((Component)jPanel, "South");
            jPanel.add(this.okBtn);
            jPanel.add(this.cancelBtn);
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PropertiesDialog.this.currObject != null) {
                        PropertiesDialog.this.applyObjectProperties(PropertiesDialog.this.list.getModel(), PropertiesDialog.this.currObject);
                        PropertiesDialog.this.currObject = null;
                    }
                    PropertiesDialog.this.close();
                    GraphView.this.graphPanel.repaint();
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertiesDialog.this.currObject = null;
                    PropertiesDialog.this.close();
                }
            });
        }

        public void show(T t) {
            this.currObject = t;
            this.list.removeAll();
            this.loadObjectProperties(this.list.getModel(), t);
            this.show(GraphView.this.showPropertiesBtn, ((GraphView)GraphView.this).showPropertiesBtn.getSize().width + 1, 0);
        }

        protected abstract void applyObjectProperties(PropertiesListModel var1, T var2);

        protected abstract void loadObjectProperties(PropertiesListModel var1, T var2);
    }

    private class AttachmentPointData {
        public final double angle;
        public final int circlepoint_x;
        public final int circlepoint_y;

        public AttachmentPointData(double d, int n, int n2) {
            this.angle = d;
            this.circlepoint_x = n;
            this.circlepoint_y = n2;
        }
    }

    private class GraphDrawingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private GraphDrawingPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            GraphView.this.paint((Graphics2D)graphics, true);
        }
    }

    private static enum Tool {
        CURSOR,
        VERTEX,
        EDGE,
        CUSTOM;

    }

    public static enum SelectionType {
        NONE,
        VERTICES_ONLY,
        EDGES_ONLY,
        BOTH;

    }

    protected class EdgeOffset {
        public final E edge;
        public final int offset;
        final /* synthetic */ GraphView this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public EdgeOffset(E e, int n2) throws IllegalArgumentException {
            this.this$0 = (GraphView)n;
            if (e == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.edge = e;
            this.offset = n2;
        }
    }

    public class CircleGraphLayout
    extends GraphLayout {
        private static final int DEF_PADDING = 60;
        private static final int DEF_OFFSET_LEFT = 50;
        private static final int DEF_OFFSET_TOP = 20;

        public <N extends Vertex, L extends Edge> void layout(Graph<N, L> graph, GraphView<N, L> graphView) {
            int n;
            double d;
            int n2 = (int)(0.5f * (float)GraphView.this.zoom);
            int n3 = (int)(0.2f * (float)GraphView.this.zoom);
            int n4 = graph.getOrder() > 2 ? 60 * (graph.getOrder() / 2) : 60;
            int n5 = (int)((float)n4 / 100.0f * (float)GraphView.this.zoom);
            double d2 = Math.sqrt((double)(2 * n5 * n5) * (1.0 - Math.cos(d = Math.toRadians(360.0 / (double)graph.getOrder()))));
            if (d2 < (double)(n = 2 * GraphView.this.radiusOfVertex + 5)) {
                n5 = (int)((double)n / Math.sqrt(2.0 - 2.0 * Math.cos(d)));
            }
            int n6 = n2 + 2 * GraphView.this.radiusOfVertex + n5;
            int n7 = n3 + 2 * GraphView.this.radiusOfVertex + n5;
            double d3 = 0.0;
            for (int i = 0; i < graph.getOrder(); ++i) {
                VisualVertex visualVertex = graphView.getVisualVertex((Vertex)graph.getVertex(i));
                if (visualVertex != null) {
                    visualVertex.setPosition(n6 - (int)(Math.cos(d3) * (double)n5), n7 - (int)(Math.sin(d3) * (double)n5));
                }
                d3 += d;
            }
        }
    }

    public static class VisualEdge
    implements Serializable {
        private final E e;
        private final VisualVertex predecessor;
        private final VisualVertex successor;
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int supportX;
        private int supportY;
        private int labelX;
        private int labelY;
        private CatmullRomSpline spline;
        private boolean selected;
        private Color color;
        private int lineWidth;
        private int offsetIndex;
        private int index;
        final /* synthetic */ GraphView this$0;

        VisualEdge(E e, VisualVertex visualVertex, VisualVertex visualVertex2) throws IllegalArgumentException {
            this.this$0 = var1_1;
            if (e == null || visualVertex == null || visualVertex2 == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.e = e;
            this.predecessor = visualVertex;
            this.successor = visualVertex2;
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = 0;
            this.y2 = 0;
            this.supportX = 0;
            this.supportY = 0;
            this.labelX = 0;
            this.labelY = 0;
            this.spline = null;
            this.selected = false;
            this.color = DEF_EDGECOLOR;
            this.lineWidth = 1;
            this.offsetIndex = 0;
            this.index = -1;
        }

        VisualEdge(GraphView graphView) {
            this.this$0 = graphView;
            this.e = null;
            this.predecessor = null;
            this.successor = null;
        }

        public final E getEdge() {
            return this.e;
        }

        public final VisualVertex getPredecessor() {
            return this.predecessor;
        }

        public final VisualVertex getSuccessor() {
            return this.successor;
        }

        public final int getIndex() {
            return this.index;
        }

        final void setIndex(int n) {
            this.index = n;
        }

        public final int getOffsetIndex() {
            return this.offsetIndex;
        }

        final void setOffsetIndex(int n) {
            this.offsetIndex = n;
        }

        public final Color getColor() {
            return this.color;
        }

        public final void setColor(Color color) throws IllegalArgumentException {
            if (color == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.color = color;
            this.this$0.autoRepaint();
        }

        public final int getLineWidth() {
            return this.lineWidth;
        }

        public final void setLineWidth(int n) throws IllegalArgumentException {
            if (n < 1) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.lineWidth = n;
            this.this$0.autoRepaint();
        }

        public final int getX1() {
            return this.x1;
        }

        final void setX1(int n) {
            this.x1 = n;
        }

        public final int getY1() {
            return this.y1;
        }

        final void setY1(int n) {
            this.y1 = n;
        }

        public final int getX2() {
            return this.x2;
        }

        final void setX2(int n) {
            this.x2 = n;
        }

        public final int getY2() {
            return this.y2;
        }

        final void setY2(int n) {
            this.y2 = n;
        }

        public final int getSupportX() {
            return this.supportX;
        }

        final void setSupportX(int n) {
            this.supportX = n;
        }

        public final int getSupportY() {
            return this.supportY;
        }

        final void setSupportY(int n) {
            this.supportY = n;
        }

        public final int getLabelX() {
            return this.labelX;
        }

        public final int getLabelY() {
            return this.labelY;
        }

        final void setLabelPosition(int n, int n2) {
            this.labelX = n;
            this.labelY = n2;
        }

        public final boolean isVisible() {
            int n;
            int n2;
            int n3;
            if (!((Edge)this.e).isLoop() && (n3 = (int)Math.sqrt((n2 = this.successor.getX() - this.predecessor.getX()) * n2 + (n = this.successor.getY() - this.predecessor.getY()) * n)) <= this.this$0.internalGetScaledVertexRadius(this.predecessor) + this.this$0.internalGetScaledVertexRadius(this.successor)) {
                return false;
            }
            n2 = this.predecessor.getVisibilityFlags() & this.successor.getVisibilityFlags();
            return n2 == 0 || n2 == 1;
        }

        public final boolean dockTo(VisualVertex visualVertex) {
            return visualVertex == this.predecessor || visualVertex == this.successor;
        }

        public final CatmullRomSpline getSpline() {
            return this.spline;
        }

        final void createSpline() {
            if (this.offsetIndex == 0) {
                this.spline = new CatmullRomSpline(new Point[]{new Point(this.x1, this.y1), new Point(this.x2, this.y2)}, 1);
            } else if (((Edge)this.e).isLoop()) {
                this.spline = new CatmullRomSpline(new Point[]{new Point(this.x1, this.y1), new Point(this.supportX - this.this$0.loopOffsetDistance * this.offsetIndex, this.supportY), new Point(this.supportX + this.this$0.loopOffsetDistance * this.offsetIndex, this.supportY), new Point(this.x2, this.y2)});
            } else {
                int n = this.x2 - this.x1;
                int n2 = this.y2 - this.y1;
                double d = Math.sqrt(n * n + n2 * n2);
                int n3 = 24;
                if (d <= 100.0) {
                    n3 = 12;
                } else if (d >= 400.0) {
                    n3 = 32;
                }
                this.spline = new CatmullRomSpline(new Point[]{new Point(this.x1, this.y1), new Point(this.supportX, this.supportY), new Point(this.x2, this.y2)}, n3);
            }
        }

        public final boolean isSelected() {
            return this.selected;
        }

        final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public final void ensureVisibility() {
            if (EDT.isExecutedInEDT()) {
                this.this$0.ensureEdgeVisibility(this);
            } else {
                EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".ensureVisibility"){

                    @Override
                    protected void execute() throws Throwable {
                        VisualEdge.this.this$0.ensureEdgeVisibility(VisualEdge.this);
                    }
                });
            }
        }

        public String toString() {
            return "(" + this.predecessor + ", " + this.successor + ")";
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.addObject("color", this.color);
            serializer.addInt("lineWidth", this.lineWidth);
            ((Edge)this.e).serialize(serializer);
        }

        @Override
        public void deserialize(Serializer serializer) {
            this.color = serializer.getObject("color", Color.black);
            this.lineWidth = serializer.getInt("lineWidth", 1);
            ((Edge)this.e).deserialize(serializer);
        }
    }

    public static class VisualVertex
    implements Serializable {
        private final V v;
        private int x;
        private int y;
        private boolean selected;
        private int visibilityFlags;
        private Color background;
        private Color foreground;
        private int edgeWidth;
        private float scale;
        private int index;
        private int attachmentX;
        private int attachmentY;
        static final int VF_VISIBLE = 1;
        static final int VF_HIDDEN_OOB_LEFT = 2;
        static final int VF_HIDDEN_OOB_RIGHT = 4;
        static final int VF_HIDDEN_OOB_TOP = 8;
        static final int VF_HIDDEN_OOB_BOTTOM = 16;
        final /* synthetic */ GraphView this$0;

        VisualVertex(V v) throws IllegalArgumentException {
            this.this$0 = var1_1;
            if (v == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.v = v;
            this.x = 0;
            this.y = 0;
            this.selected = false;
            this.visibilityFlags = 1;
            this.background = DEF_VERTEXBACKGROUND;
            this.foreground = DEF_VERTEXFOREGROUND;
            this.edgeWidth = 1;
            this.scale = 1.0f;
            this.index = -1;
            this.attachmentX = 0;
            this.attachmentY = 0;
        }

        public final V getVertex() {
            return this.v;
        }

        public final int getIndex() {
            return this.index;
        }

        final void setIndex(int n) {
            this.index = n;
        }

        public final Color getBackground() {
            return this.background;
        }

        public final void setBackground(Color color) throws IllegalArgumentException {
            if (color == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.background = color;
            this.this$0.autoRepaint();
        }

        public final Color getForeground() {
            return this.foreground;
        }

        public final void setForeground(Color color) throws IllegalArgumentException {
            if (color == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.foreground = color;
            this.this$0.autoRepaint();
        }

        public final int getEdgeWidth() {
            return this.edgeWidth;
        }

        public final void setEdgeWidth(int n) throws IllegalArgumentException {
            if (n < 1) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.edgeWidth = n;
            this.this$0.autoRepaint();
        }

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) throws IllegalArgumentException {
            if (f <= 0.0f) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.scale = f;
            this.this$0.autoRepaint();
        }

        public final int getX() {
            return this.x;
        }

        final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        final void setY(int n) {
            this.y = n;
        }

        final void setPosition(int n, int n2) {
            this.setX(n);
            this.setY(n2);
        }

        public final int getAttachmentX() {
            return this.attachmentX;
        }

        final void setAttachmentX(int n) {
            this.attachmentX = n;
        }

        public final int getAttachmentY() {
            return this.attachmentY;
        }

        final void setAttachmentY(int n) {
            this.attachmentY = n;
        }

        final void setAttachmentPosition(int n, int n2) {
            this.attachmentX = n;
            this.attachmentY = n2;
        }

        public final boolean isSelected() {
            return this.selected;
        }

        final void setSelected(boolean bl) {
            this.selected = bl;
        }

        final int getVisibilityFlags() {
            return this.visibilityFlags;
        }

        final void setVisibilityFlags(int n) {
            this.visibilityFlags = n;
        }

        public final boolean isVisible() {
            return (this.visibilityFlags & 1) != 0;
        }

        public final void ensureVisibility() {
            if (EDT.isExecutedInEDT()) {
                this.this$0.ensureVertexVisibility(this);
            } else {
                EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".ensureVisibility"){

                    @Override
                    protected void execute() throws Throwable {
                        VisualVertex.this.this$0.ensureVertexVisibility(VisualVertex.this);
                    }
                });
            }
        }

        public String toString() {
            return ((Vertex)this.v).toString();
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.addInt("x", this.x);
            serializer.addInt("y", this.y);
            serializer.addObject("background", this.background);
            serializer.addObject("foreground", this.foreground);
            serializer.addInt("edgeWidth", this.edgeWidth);
            serializer.addFloat("scale", this.scale);
            ((Vertex)this.v).serialize(serializer);
        }

        @Override
        public void deserialize(Serializer serializer) {
            this.x = serializer.getInt("x");
            this.y = serializer.getInt("y");
            this.background = serializer.getObject("background", Color.white);
            this.foreground = serializer.getObject("foreground", Color.black);
            this.edgeWidth = serializer.getInt("edgeWidth", 1);
            this.scale = serializer.getFloat("scale", 1.0f);
            ((Vertex)this.v).deserialize(serializer);
        }
    }
}

