/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.util.ArrayList;
import java.util.List;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.serialization.Serializer;

public abstract class GraphTransferProtocol<V extends Vertex, E extends Edge> {
    protected final GraphView<V, E> graphView;
    protected final Graph<V, E> graph;
    protected final boolean clearExistingGraph;
    private int lastTransferID;
    private final List<TransferData> vertexTransferData;
    private final List<TransferData> edgeTransferData;
    private boolean isPrepared;
    private int zoom;

    public GraphTransferProtocol(GraphView<V, E> graphView, boolean bl) throws IllegalArgumentException {
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphView = graphView;
        this.graph = graphView.getGraph();
        this.clearExistingGraph = bl;
        this.lastTransferID = 0;
        this.vertexTransferData = new ArrayList<TransferData>();
        this.edgeTransferData = new ArrayList<TransferData>();
        this.isPrepared = false;
        this.zoom = 0;
    }

    public final GraphView<V, E> getGraphView() {
        return this.graphView;
    }

    public final Graph<V, E> getGraph() {
        return this.graph;
    }

    public final boolean prepare() {
        int n;
        if (this.isPrepared) {
            return false;
        }
        for (n = 0; n < this.graph.getOrder(); ++n) {
            this.vertexTransferData.add(this.getTransferData((E)this.graph.getVertex(n)));
        }
        for (n = 0; n < this.graph.getSize(); ++n) {
            this.edgeTransferData.add(this.getTransferData(this.graph.getEdge(n)));
        }
        this.zoom = this.graphView.getZoom();
        this.isPrepared = true;
        return this.isPrepared;
    }

    protected abstract TransferData getTransferData(V var1);

    protected abstract TransferData getTransferData(E var1);

    List<TransferData> getVertexTransferData() {
        return this.vertexTransferData;
    }

    List<TransferData> getEdgeTransferData() {
        return this.edgeTransferData;
    }

    boolean isPrepared() {
        return this.isPrepared;
    }

    int getZoom() {
        return this.zoom;
    }

    boolean getClearExistingGraph() {
        return this.clearExistingGraph;
    }

    public class TransferData
    extends Serializer {
        private static final long serialVersionUID = 1L;

        public TransferData() {
            super(++GraphTransferProtocol.this.lastTransferID, "" + GraphTransferProtocol.this.lastTransferID);
        }

        protected void removeTransferData(String string) {
            super.removeData(string);
        }
    }
}

