/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.GraphViewListener;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.math.graph.AccessibleID;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.serialization.Serializable;
import lavesdk.serialization.Serializer;

public class GraphScene<V extends Vertex, E extends Edge> {
    private final GraphView<V, E> graphView;
    private final Map<Integer, VisualVertexSceneObject> sceneVertices;
    private final List<Integer> sceneVerticesOrder;
    private final Map<Integer, VisualEdgeSceneObject> sceneEdges;
    private final List<Integer> sceneEdgesOrder;
    private int nextStateID;
    private SceneRecorder sceneRecorder;
    private boolean sceneBegin;
    private boolean sceneEnd;
    private SceneObjectState sceneData;

    public GraphScene(GraphView<V, E> graphView) throws IllegalArgumentException {
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphView = graphView;
        this.sceneVertices = new HashMap<Integer, VisualVertexSceneObject>();
        this.sceneVerticesOrder = new ArrayList<Integer>();
        this.sceneEdges = new HashMap<Integer, VisualEdgeSceneObject>();
        this.sceneEdgesOrder = new ArrayList<Integer>();
        this.nextStateID = 1;
        this.sceneRecorder = null;
        this.sceneBegin = false;
        this.sceneEnd = false;
        this.sceneData = null;
    }

    public final GraphView<V, E> getGraphView() {
        return this.graphView;
    }

    public final synchronized GraphScene<V, E> begin() throws IllegalStateException {
        int n;
        if (this.sceneEnd) {
            throw new IllegalStateException("scene has already ended");
        }
        this.sceneData = new SceneObjectState();
        this.graphView.serialize(this.sceneData);
        this.sceneData.freeze();
        for (n = 0; n < this.graphView.getVisualVertexCount(); ++n) {
            this.addVertexSceneObject(this.graphView.getVisualVertex(n));
        }
        for (n = 0; n < this.graphView.getVisualEdgeCount(); ++n) {
            this.addEdgeSceneObject(this.graphView.getVisualEdge(n));
        }
        this.sceneRecorder = new SceneRecorder();
        this.graphView.addGraphViewListener(this.sceneRecorder);
        this.sceneBegin = true;
        return this;
    }

    public final synchronized GraphScene<V, E> end() throws IllegalStateException {
        return this.end(true);
    }

    public final synchronized GraphScene<V, E> end(boolean bl) throws IllegalStateException {
        if (!this.sceneBegin) {
            throw new IllegalStateException("scene has not yet begun");
        }
        if (this.sceneEnd) {
            return this;
        }
        if (bl) {
            int n;
            for (n = this.sceneVerticesOrder.size() - 1; n >= 0; --n) {
                if (this.sceneVertices.get(this.sceneVerticesOrder.get(n)).isModified()) continue;
                this.sceneVertices.remove(this.sceneVerticesOrder.get(n));
                this.sceneVerticesOrder.remove(n);
            }
            for (n = this.sceneEdgesOrder.size() - 1; n >= 0; --n) {
                if (this.sceneEdges.get(this.sceneEdgesOrder.get(n)).isModified()) continue;
                this.sceneEdges.remove(this.sceneEdgesOrder.get(n));
                this.sceneEdgesOrder.remove(n);
            }
        }
        this.graphView.removeGraphViewListener(this.sceneRecorder);
        this.sceneEnd = true;
        return this;
    }

    public final synchronized void reverse() throws IllegalStateException {
        int n;
        if (!this.sceneEnd) {
            throw new IllegalStateException("scene has to be ended before it can be reversed");
        }
        for (n = this.sceneVerticesOrder.size() - 1; n >= 0; --n) {
            this.reverseVertexSceneObject(this.sceneVertices.get(this.sceneVerticesOrder.get(n)));
        }
        for (n = this.sceneEdgesOrder.size() - 1; n >= 0; --n) {
            this.reverseEdgeSceneObject(this.sceneEdges.get(this.sceneEdgesOrder.get(n)));
        }
        if (this.sceneData != null) {
            this.sceneData.unfreeze();
            this.graphView.deserialize(this.sceneData);
            this.graphView.setZoom(this.graphView.getZoom());
        }
        this.sceneVertices.clear();
        this.sceneVerticesOrder.clear();
        this.sceneEdges.clear();
        this.sceneEdgesOrder.clear();
        this.graphView.repaint();
    }

    public final boolean isRecorded() {
        return this.sceneEnd;
    }

    private SceneObject addVertexSceneObject(GraphView.VisualVertex visualVertex) {
        VisualVertexSceneObject visualVertexSceneObject = new VisualVertexSceneObject(visualVertex);
        this.sceneVertices.put(visualVertexSceneObject.getObjectID(), visualVertexSceneObject);
        this.sceneVerticesOrder.add(visualVertexSceneObject.getObjectID());
        visualVertexSceneObject.requestInitialState();
        return visualVertexSceneObject;
    }

    private SceneObject addEdgeSceneObject(GraphView.VisualEdge visualEdge) {
        VisualEdgeSceneObject visualEdgeSceneObject = new VisualEdgeSceneObject(visualEdge);
        this.sceneEdges.put(visualEdgeSceneObject.getObjectID(), visualEdgeSceneObject);
        this.sceneEdgesOrder.add(visualEdgeSceneObject.getObjectID());
        visualEdgeSceneObject.requestInitialState();
        return visualEdgeSceneObject;
    }

    private void reverseVertexSceneObject(final VisualVertexSceneObject visualVertexSceneObject) {
        switch (visualVertexSceneObject.getAction()) {
            case ADDED: {
                if (EDT.isExecutedInEDT()) {
                    this.graphView.removeVisualVertex(visualVertexSceneObject.getVisualVertex());
                    break;
                }
                EDT.execute(new GuiJob(){

                    @Override
                    protected void execute() throws Throwable {
                        GraphScene.this.graphView.removeVisualVertex(visualVertexSceneObject.getVisualVertex());
                    }
                });
                break;
            }
            case REMOVED: {
                GraphView.VisualVertex visualVertex = EDT.isExecutedInEDT() ? this.graphView.createVisualVertex(0, 0) : EDT.execute(new GuiRequest<GraphView.VisualVertex>(){

                    @Override
                    protected GraphView.VisualVertex execute() throws Throwable {
                        return GraphScene.this.graphView.createVisualVertex(0, 0);
                    }
                });
                if (visualVertex != null) {
                    AccessibleID accessibleID = new AccessibleID((Vertex)visualVertex.getVertex());
                    accessibleID.modify(visualVertexSceneObject.getObjectID());
                }
                visualVertexSceneObject.restoreInitialState(visualVertex);
                break;
            }
            default: {
                GraphView.VisualVertex visualVertex = this.graphView.getVisualVertexByID(visualVertexSceneObject.getObjectID());
                visualVertexSceneObject.restoreInitialState(visualVertex);
            }
        }
    }

    private void reverseEdgeSceneObject(final VisualEdgeSceneObject visualEdgeSceneObject) {
        switch (visualEdgeSceneObject.getAction()) {
            case ADDED: {
                if (EDT.isExecutedInEDT()) {
                    this.graphView.removeVisualEdge(visualEdgeSceneObject.getVisualEdge());
                    break;
                }
                EDT.execute(new GuiJob(){

                    @Override
                    protected void execute() throws Throwable {
                        GraphScene.this.graphView.removeVisualEdge(visualEdgeSceneObject.getVisualEdge());
                    }
                });
                break;
            }
            case REMOVED: {
                final VisualVertexSceneObject visualVertexSceneObject = this.sceneVertices.get(visualEdgeSceneObject.getPredecessorID());
                final VisualVertexSceneObject visualVertexSceneObject2 = this.sceneVertices.get(visualEdgeSceneObject.getSuccessorID());
                if (visualVertexSceneObject == null || visualVertexSceneObject2 == null) break;
                GraphView.VisualEdge visualEdge = EDT.isExecutedInEDT() ? this.graphView.createVisualEdge(visualVertexSceneObject.getVisualVertex(), visualVertexSceneObject2.getVisualVertex(), visualEdgeSceneObject.isDirected()) : EDT.execute(new GuiRequest<GraphView.VisualEdge>(){

                    @Override
                    protected GraphView.VisualEdge execute() throws Throwable {
                        return GraphScene.this.graphView.createVisualEdge(visualVertexSceneObject.getVisualVertex(), visualVertexSceneObject2.getVisualVertex(), visualEdgeSceneObject.isDirected());
                    }
                });
                if (visualEdge != null) {
                    AccessibleID accessibleID = new AccessibleID((Edge)visualEdge.getEdge());
                    accessibleID.modify(visualEdgeSceneObject.getObjectID());
                }
                visualEdgeSceneObject.restoreInitialState(visualEdge);
                break;
            }
            default: {
                GraphView.VisualEdge visualEdge = this.graphView.getVisualEdgeByID(visualEdgeSceneObject.getObjectID());
                visualEdgeSceneObject.restoreInitialState(visualEdge);
            }
        }
    }

    private class SceneRecorder
    implements GraphViewListener<V, E> {
        private SceneRecorder() {
        }

        @Override
        public void vertexAdded(GraphView.VisualVertex visualVertex) {
            GraphScene.this.addVertexSceneObject(visualVertex).applyAction(SceneObjectAction.ADDED);
        }

        @Override
        public void vertexRemoved(GraphView.VisualVertex visualVertex) {
            SceneObject sceneObject = (SceneObject)GraphScene.this.sceneVertices.get(((Vertex)visualVertex.getVertex()).getID());
            if (sceneObject != null) {
                sceneObject.applyAction(SceneObjectAction.REMOVED);
            }
        }

        @Override
        public void vertexSelected(GraphView.VisualVertex visualVertex) {
        }

        @Override
        public void edgeAdded(GraphView.VisualEdge visualEdge) {
            GraphScene.this.addEdgeSceneObject(visualEdge).applyAction(SceneObjectAction.ADDED);
        }

        @Override
        public void edgeRemoved(GraphView.VisualEdge visualEdge) {
            SceneObject sceneObject = (SceneObject)GraphScene.this.sceneEdges.get(((Edge)visualEdge.getEdge()).getID());
            if (sceneObject != null) {
                sceneObject.applyAction(SceneObjectAction.REMOVED);
            }
        }

        @Override
        public void edgeSelected(GraphView.VisualEdge visualEdge) {
        }
    }

    private class SceneObjectState
    extends Serializer {
        private static final long serialVersionUID = 1L;
        private byte[] state;

        public SceneObjectState() throws IllegalArgumentException {
            super(GraphScene.this.nextStateID++, "SceneObject");
        }

        public void freeze() {
            this.state = this.freezeData();
        }

        public void unfreeze() {
            if (this.state != null) {
                this.unfreezeData(this.state);
            }
        }
    }

    private static enum SceneObjectAction {
        NONE,
        ADDED,
        REMOVED;


        public SceneObjectAction apply(SceneObjectAction sceneObjectAction) throws IllegalArgumentException {
            if (sceneObjectAction == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            switch (this) {
                case NONE: {
                    return sceneObjectAction;
                }
                case ADDED: {
                    return sceneObjectAction == ADDED ? ADDED : NONE;
                }
                case REMOVED: {
                    return sceneObjectAction == REMOVED ? REMOVED : NONE;
                }
            }
            return NONE;
        }
    }

    private class VisualEdgeSceneObject
    extends SceneObject {
        private final boolean directed;
        private final int predecessorID;
        private final int successorID;

        public VisualEdgeSceneObject(GraphView.VisualEdge visualEdge) {
            super(visualEdge, ((Edge)visualEdge.getEdge()).getID());
            this.directed = ((Edge)visualEdge.getEdge()).isDirected();
            this.predecessorID = ((Vertex)visualEdge.getPredecessor().getVertex()).getID();
            this.successorID = ((Vertex)visualEdge.getSuccessor().getVertex()).getID();
        }

        public GraphView.VisualEdge getVisualEdge() {
            return GraphScene.this.graphView.getVisualEdgeByID(this.objectID);
        }

        public boolean isDirected() {
            return this.directed;
        }

        public int getPredecessorID() {
            return this.predecessorID;
        }

        public int getSuccessorID() {
            return this.successorID;
        }
    }

    private class VisualVertexSceneObject
    extends SceneObject {
        public VisualVertexSceneObject(GraphView.VisualVertex visualVertex) {
            super(visualVertex, ((Vertex)visualVertex.getVertex()).getID());
        }

        public GraphView.VisualVertex getVisualVertex() {
            return GraphScene.this.graphView.getVisualVertexByID(this.objectID);
        }
    }

    private abstract class SceneObject {
        protected final Serializable object;
        protected final int objectID;
        private SceneObjectAction action;
        private SceneObjectState initialState;

        public SceneObject(Serializable serializable, int n) throws IllegalArgumentException {
            if (serializable == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.object = serializable;
            this.objectID = n;
            this.action = SceneObjectAction.NONE;
            this.initialState = null;
        }

        public final int getObjectID() {
            return this.objectID;
        }

        public void requestInitialState() throws IllegalStateException {
            if (this.initialState != null) {
                throw new IllegalStateException("initial state is already requested");
            }
            this.initialState = new SceneObjectState();
            this.object.serialize(this.initialState);
            this.initialState.freeze();
        }

        public void restoreInitialState(Serializable serializable) {
            if (this.initialState == null || serializable == null) {
                return;
            }
            this.initialState.unfreeze();
            serializable.deserialize(this.initialState);
            this.initialState = null;
        }

        public boolean isModified() {
            if (this.initialState == null) {
                return false;
            }
            if (this.action != SceneObjectAction.NONE) {
                return true;
            }
            SceneObjectState sceneObjectState = new SceneObjectState();
            this.object.serialize(sceneObjectState);
            return !this.initialState.equals(sceneObjectState);
        }

        public void applyAction(SceneObjectAction sceneObjectAction) throws IllegalArgumentException {
            this.action = this.action.apply(sceneObjectAction);
        }

        public SceneObjectAction getAction() {
            return this.action;
        }
    }
}

