/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewHeaderBarExtension;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public class FontHeaderBarExtension
extends ViewHeaderBarExtension {
    private final JButton fontSizeUpBtn;
    private final JButton fontSizeDownBtn;
    private final JButton fontSizeNormalBtn;
    private final EventController eventController;
    private float normalFontSize;

    public FontHeaderBarExtension(View view, float f, boolean bl, LanguageFile languageFile, String string) throws IllegalArgumentException {
        super(view, bl, languageFile, string);
        if (f < 1.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.normalFontSize = f;
        this.fontSizeUpBtn = new JButton(Resources.getInstance().FONTSIZE_UP_ICON);
        this.fontSizeDownBtn = new JButton(Resources.getInstance().FONTSIZE_DOWN_ICON);
        this.fontSizeNormalBtn = new JButton(Resources.getInstance().FONTSIZE_NORMAL_ICON);
        this.eventController = new EventController();
        this.fontSizeUpBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "TEXTVIEW_FONTSIZE_UP_BTN_TOOLTIP", string, "Font Size Up") + "</html>");
        this.fontSizeDownBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "TEXTVIEW_FONTSIZE_DOWN_BTN_TOOLTIP", string, "Font Size Down") + "</html>");
        this.fontSizeNormalBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "TEXTVIEW_FONTSIZE_NORMAL_BTN_TOOLTIP", string, "Standard Font Size") + "</html>");
        this.fontSizeUpBtn.addActionListener(this.eventController);
        this.fontSizeDownBtn.addActionListener(this.eventController);
        this.fontSizeNormalBtn.addActionListener(this.eventController);
    }

    @Override
    protected void createExtension() {
        this.addComponent(this.fontSizeDownBtn);
        this.addComponent(this.fontSizeNormalBtn);
        this.addComponent(this.fontSizeUpBtn);
    }

    private void changeFontSize(float f) {
        Font font = this.view.getFont();
        if (font != null) {
            this.view.setFont(f != 0.0f ? font.deriveFont((float)font.getSize() + f) : font.deriveFont(this.normalFontSize));
        }
    }

    private class EventController
    implements ActionListener {
        private EventController() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FontHeaderBarExtension.this.fontSizeUpBtn) {
                FontHeaderBarExtension.this.changeFontSize(2.0f);
            } else if (actionEvent.getSource() == FontHeaderBarExtension.this.fontSizeDownBtn) {
                FontHeaderBarExtension.this.changeFontSize(-2.0f);
            } else if (actionEvent.getSource() == FontHeaderBarExtension.this.fontSizeNormalBtn) {
                FontHeaderBarExtension.this.changeFontSize(0.0f);
            }
        }
    }
}

