/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmExerciseHandler;
import lavesdk.algorithm.AlgorithmExerciseProvider;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.Annotation;
import lavesdk.gui.dialogs.AnnotationDialog;
import lavesdk.gui.widgets.AnnotationViewKit;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;
import lavesdk.utils.FileUtils;
import lavesdk.utils.MathUtils;

public class ExercisesListView
extends View
implements AlgorithmExerciseProvider {
    private static final long serialVersionUID = 1L;
    private final LanguageFile langFile;
    private final String langID;
    private AlgorithmExerciseHandler exerciseModeHandler;
    private final JScrollPane scrollPane;
    private final EvaluationPanel evalPanel;
    private Item activeItem;
    private final JPanel itemList;
    private boolean performingExam;
    private final String labelExercise;
    private final String labelCredit;
    private final String labelCredits;
    private final String labelResult;
    private final String labelAttempts;
    private final String labelLastSolution;
    private final String labelSolve;
    private final String labelGiveUp;
    private final String labelInputHint;
    private final String labelAnnotation;
    private final String labelSucceeded;
    private final String labelFailed;
    private final String labelFailedHint;
    private final String msgInfoExerciseMode;
    private final String msgTitleExerciseMode;
    private final String inputHintDlgTitle;
    private static final Color ITEM_BACKGROUND = Color.white;
    private static final Color ITEM_SEPARATOR = new Color(170, 200, 220);
    private static final Color ACTIVE_ITEM_BACKGROUND = new Color(245, 251, 255);
    private static final Color ACTIVE_ITEM_BORDER = new Color(230, 236, 240);
    private static final int ITEM_PADDING_TOP = 5;
    private static final int ITEM_PADDING_LEFT = 2;
    private static final int ITEM_PADDING_RIGHT = 2;
    private static final int ITEM_PADDING_BOTTOM = 2;
    private static final Border ITEM_BORDER_ACTIVE = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ACTIVE_ITEM_BORDER), BorderFactory.createEmptyBorder(4, 1, 1, 1));
    private static final Border ITEM_BORDER_NORMAL = BorderFactory.createEmptyBorder(5, 2, 2, 2);
    private static final Border ITEM_BORDER_NORMAL_WITHSEP = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ITEM_SEPARATOR), BorderFactory.createEmptyBorder(4, 2, 2, 2));
    private static final JLabel prefHeightHTMLLabel = new JLabel();

    public ExercisesListView(LanguageFile languageFile, String string) {
        super(LanguageFile.getLabel(languageFile, "EXERCISESLIST_TITLE", string, "Exercises"), true, languageFile, string);
        this.langFile = languageFile;
        this.langID = string;
        this.exerciseModeHandler = null;
        this.evalPanel = new EvaluationPanel(languageFile, string);
        this.activeItem = null;
        this.performingExam = false;
        this.labelExercise = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_EXERCISE", string, "Exercise");
        this.labelCredit = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_CREDIT", string, "Credit");
        this.labelCredits = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_CREDITS", string, "Credits");
        this.labelResult = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_RESULT", string, "Result:");
        this.labelAttempts = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_ATTEMPTS", string, "Attempts:");
        this.labelLastSolution = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_LAST_SOLUTION", string, "Last Solution:");
        this.labelSolve = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_BTN_SOLVE", string, "Solve Exercise");
        this.labelGiveUp = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_BTN_GIVEUP", string, "Give Up Exercise");
        this.labelInputHint = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_BTN_INPUTHINT", string, "Show Input Hint");
        this.labelAnnotation = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_BTN_ANNOTATION", string, "Show Annotation");
        this.labelSucceeded = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_STATE_SUCCEEDED", string, "Succeeded");
        this.labelFailed = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_STATE_FAILED", string, "Failed");
        this.labelFailedHint = LanguageFile.getLabel(languageFile, "EXERCISESLIST_ITEM_STATE_FAILEDHINT", string, "Failed - Why?");
        this.msgInfoExerciseMode = LanguageFile.getLabel(languageFile, "MSG_INFO_EXERCISEMODE", string, "The exercise mode can only be activated/deactivated when the algorithm is stopped!");
        this.msgTitleExerciseMode = LanguageFile.getLabel(languageFile, "MSG_INFO_TITLE_EXERCISEMODE", string, "Exercise Mode");
        this.inputHintDlgTitle = LanguageFile.getLabel(languageFile, "EXERCISE_INPUTHINT_TITLE", string, "Input Hint");
        this.content.setLayout(new BorderLayout());
        this.itemList = new JPanel();
        this.itemList.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane(this.itemList);
        this.itemList.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.evalPanel.setBackground(SystemColor.control);
        this.content.add((Component)this.scrollPane, "Center");
        this.content.add((Component)this.evalPanel, "South");
        this.itemList.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ExercisesListView.this.scrollPane.getViewport().setViewPosition(new Point(0, ExercisesListView.this.itemList.getHeight()));
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ExercisesListView.this.itemList.revalidate();
            }
        });
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void setHandler(AlgorithmExerciseHandler algorithmExerciseHandler) {
        this.exerciseModeHandler = algorithmExerciseHandler;
    }

    @Override
    public void beginExam() {
        this.reset();
        this.performingExam = true;
    }

    @Override
    public void endExam(boolean bl) {
        if (!bl) {
            Component[] componentArray = this.itemList.getComponents();
            float f = 0.0f;
            float f2 = 0.0f;
            for (Component component : componentArray) {
                if (!(component instanceof Item)) continue;
                Item item = (Item)component;
                f += item.getTotalCredits();
                f2 += item.getAchievedCredits();
            }
            this.evalPanel.update(f, f2);
        }
        this.performingExam = false;
    }

    @Override
    public void beforeProcessingExercise(AlgorithmExercise<?> algorithmExercise, AlgorithmStep algorithmStep) {
        if (this.activeItem != null) {
            this.activeItem.setBackground(ITEM_BACKGROUND);
        }
        this.activeItem = new Item(algorithmExercise, algorithmStep, this.itemList.getComponentCount() > 0);
        this.activeItem.setBackground(ACTIVE_ITEM_BACKGROUND);
        if (this.itemList.getComponentCount() > 0) {
            this.itemList.remove(this.itemList.getComponentCount() - 1);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.itemList.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.itemList.add((Component)this.activeItem, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = this.itemList.getComponentCount();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.itemList.add((Component)new JLabel(), gridBagConstraints2);
        this.itemList.revalidate();
    }

    @Override
    public void afterProcessingExercise(AlgorithmExercise<?> algorithmExercise, AlgorithmExercise.ExamResult examResult, String string) {
        if (this.activeItem != null) {
            this.activeItem.endProcess(examResult == AlgorithmExercise.ExamResult.SUCCEEDED, string);
        }
    }

    @Override
    public void afterSolvingExercise(AlgorithmExercise<?> algorithmExercise, boolean bl, String string) {
        if (this.activeItem != null) {
            this.activeItem.doProcess(bl, string);
        }
    }

    @Override
    public void reset() {
        this.itemList.removeAll();
        this.evalPanel.reset();
        this.repaint();
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        this.itemList.repaint();
        this.evalPanel.repaint();
    }

    @Override
    protected void close() {
        if (this.performingExam) {
            JOptionPane.showMessageDialog(null, this.msgInfoExerciseMode, this.msgTitleExerciseMode, 1);
            return;
        }
        this.exerciseModeHandler.setExerciseModeEnabled(false);
    }

    private static Dimension getPreferredHeight(String string, int n) {
        prefHeightHTMLLabel.setText(string);
        javax.swing.text.View view = (javax.swing.text.View)prefHeightHTMLLabel.getClientProperty("html");
        view.setSize(n, 0.0f);
        float f = view.getPreferredSpan(0);
        float f2 = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(f), (int)Math.ceil(f2));
    }

    private class EvaluationPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JLabel lblEvaluation;
        private final JLabel lblCredits;
        private final JLabel lblCreditsAchieved;
        private final JLabel lblInPercent;
        private final JLabel lblCreditsInPercent;
        private final JLabel lblGrading;
        private final JButton btnGradingValue;
        private final float[][] gradingScale;
        private final String gradingScaleDlgTitle;
        private static final String DEF_CREDITS_ACHIEVED = "-/-";
        private static final String DEF_CREDITS_PERCENT = "-%";
        private static final String DEF_GRADING_VALUE = "-";

        public EvaluationPanel(LanguageFile languageFile, String string) {
            this.lblEvaluation = new JLabel(LanguageFile.getLabel(languageFile, "EXERCISESLIST_EVALUATION", string, "Evaluation"));
            this.lblCredits = new JLabel(LanguageFile.getLabel(languageFile, "EXERCISESLIST_EVALUATION_CREDITSACHIEVED", string, "Credits:"));
            this.lblCreditsAchieved = new JLabel(DEF_CREDITS_ACHIEVED);
            this.lblInPercent = new JLabel(LanguageFile.getLabel(languageFile, "EXERCISESLIST_EVALUATION_INPERCENT", string, "In Percent:"));
            this.lblCreditsInPercent = new JLabel(DEF_CREDITS_PERCENT);
            this.lblGrading = new JLabel(LanguageFile.getLabel(languageFile, "EXERCISESLIST_EVALUATION_GRADING", string, "Grading:"));
            this.btnGradingValue = new JButton(DEF_GRADING_VALUE);
            this.gradingScaleDlgTitle = LanguageFile.getLabel(languageFile, "EXERCISESLIST_EVALUATION_GRADING_SCALE", string, "Grading Scale");
            this.btnGradingValue.setToolTipText(this.gradingScaleDlgTitle);
            this.gradingScale = this.createGradingScale();
            Font font = UIManager.getFont("Label.font");
            this.lblEvaluation.setFont(font.deriveFont(1));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.lblEvaluation, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblCredits, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.lblCreditsAchieved, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblInPercent, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.lblCreditsInPercent, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.lblGrading, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.btnGradingValue, gridBagConstraints);
            this.btnGradingValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextArea jTextArea = new JTextArea(EvaluationPanel.this.getGradingScaleAsTable());
                    jTextArea.setFont(UIManager.getFont("TextPane.font"));
                    jTextArea.setEditable(false);
                    JOptionPane jOptionPane = new JOptionPane(jTextArea, 1);
                    JDialog jDialog = jOptionPane.createDialog(EvaluationPanel.this.gradingScaleDlgTitle);
                    if (ExercisesListView.this.exerciseModeHandler.getHost() != null) {
                        ExercisesListView.this.exerciseModeHandler.getHost().adaptDialog(jDialog);
                    }
                    jTextArea.setBackground(jDialog.getBackground());
                    jDialog.setVisible(true);
                }
            });
        }

        public void update(float f, float f2) {
            float f3 = f > 0.0f ? f2 / f : 0.0f;
            this.lblCreditsAchieved.setText(MathUtils.formatFloat(f2) + "/" + MathUtils.formatFloat(f));
            this.lblCreditsInPercent.setText(NumberFormat.getPercentInstance().format(f3));
            this.btnGradingValue.setText(NumberFormat.getInstance().format(this.getGradingValue(f3)));
            this.repaint();
        }

        public void reset() {
            this.lblCreditsAchieved.setText(DEF_CREDITS_ACHIEVED);
            this.lblCreditsInPercent.setText(DEF_CREDITS_PERCENT);
            this.btnGradingValue.setText(DEF_GRADING_VALUE);
            this.repaint();
        }

        private float[][] createGradingScale() {
            return new float[][]{{1.0f, 1.0f}, {0.98f, 1.3f}, {0.92f, 1.7f}, {0.86f, 2.0f}, {0.8f, 2.3f}, {0.74f, 2.7f}, {0.68f, 3.0f}, {0.62f, 3.3f}, {0.56f, 3.7f}, {0.52f, 4.0f}, {0.5f, 5.0f}};
        }

        private String getGradingScaleAsTable() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.gradingScale.length && i != this.gradingScale.length - 1; ++i) {
                float f = this.gradingScale[i][0] * 100.0f;
                float f2 = this.gradingScale[i + 1][0] * 100.0f;
                float f3 = this.gradingScale[i][1];
                stringBuilder.append(MathUtils.formatFloat(f) + DEF_GRADING_VALUE + MathUtils.formatFloat(f2) + "%\t" + NumberFormat.getInstance().format(f3) + "\n");
            }
            stringBuilder.append("< 50%\t" + NumberFormat.getNumberInstance().format(5.0));
            return stringBuilder.toString();
        }

        private float getGradingValue(float f) {
            for (int i = 0; i < this.gradingScale.length; ++i) {
                if (i == this.gradingScale.length - 1) {
                    return this.gradingScale[i][1];
                }
                if (!(f <= this.gradingScale[i][0]) || !(f > this.gradingScale[i + 1][0])) continue;
                return this.gradingScale[i][1];
            }
            return 5.0f;
        }
    }

    private class Item
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final AlgorithmExercise<?> exercise;
        private final AlgorithmStep step;
        private final boolean showSeparator;
        private int attempts;
        private boolean locked;
        private boolean succeeded;
        private final JLabel lblHeader;
        private final JLabel lblExerciseText;
        private final JLabel lblResult;
        private final JLabel lblResultValue;
        private final JLabel lblAttempts;
        private final JLabel lblAttemptsValue;
        private final JButton btnSolve;
        private final JButton btnGiveUp;
        private final JButton btnInputHint;
        private final JButton btnAnnotation;
        private final JLabel lblLastSolution;
        private final JLabel lblLastSolutionValue;
        private final JSeparator separator;
        private final JSeparator separatorAdditionalButtons;
        private final int minimumWidth;
        private Dimension lastPrefSize;
        private final Dimension prefSizeHeader;
        private final Dimension prefSizeResult;
        private final Dimension prefSizeAttempts;
        private final Dimension prefSizeLastSol;
        private final Dimension prefSizeSolveBtn;
        private final Dimension prefSizeGiveUpBtn;
        private final Dimension prefSizeInputHintBtn;
        private final Dimension prefSizeAnnotationBtn;
        private final Dimension prefSizeSeparator;
        private final Dimension prefSizeSeparatorAdditionalButtons;
        private final MouseListener resultValueMouseListener;
        private final int INNER_MIN_PADDING = 50;
        private final int BUTTON_INTERSPACING = 5;
        private final int BUTTONGROUP_INTERSPACING = 10;

        public Item(AlgorithmExercise<?> algorithmExercise, AlgorithmStep algorithmStep, boolean bl) throws IllegalArgumentException {
            if (algorithmExercise == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            Font font = UIManager.getFont("Label.font");
            String string = algorithmExercise.getCredits() == 1.0f ? ExercisesListView.this.labelCredit : ExercisesListView.this.labelCredits;
            this.exercise = algorithmExercise;
            this.step = algorithmStep;
            this.showSeparator = bl;
            this.attempts = 0;
            this.locked = false;
            this.succeeded = false;
            this.lblHeader = new JLabel(ExercisesListView.this.labelExercise + " (" + MathUtils.formatFloat(algorithmExercise.getCredits()) + " " + string + "):");
            this.lblHeader.setFont(font.deriveFont(1));
            this.add(this.lblHeader);
            this.lblExerciseText = new JLabel(this.getExerciseText(algorithmExercise));
            this.add(this.lblExerciseText);
            this.lblResult = new JLabel(ExercisesListView.this.labelResult);
            this.lblResult.setForeground(Color.gray);
            this.add(this.lblResult);
            this.lblResultValue = new JLabel();
            this.lblResultValue.setForeground(Color.gray);
            this.add(this.lblResultValue);
            this.lblAttempts = new JLabel(ExercisesListView.this.labelAttempts);
            this.lblAttempts.setForeground(Color.gray);
            this.add(this.lblAttempts);
            this.lblAttemptsValue = new JLabel("" + this.attempts);
            this.lblAttemptsValue.setForeground(Color.gray);
            this.add(this.lblAttemptsValue);
            this.lblLastSolution = new JLabel(ExercisesListView.this.labelLastSolution);
            this.lblLastSolution.setForeground(Color.gray);
            this.add(this.lblLastSolution);
            this.lblLastSolutionValue = new JLabel();
            this.lblLastSolutionValue.setForeground(Color.gray);
            this.add(this.lblLastSolutionValue);
            this.btnSolve = new JButton(Resources.getInstance().EXERCISE_SOLVE_ICON);
            this.btnSolve.setToolTipText(ExercisesListView.this.labelSolve);
            this.add(this.btnSolve);
            this.btnGiveUp = new JButton(Resources.getInstance().EXERCISE_GIVEUP_ICON);
            this.btnGiveUp.setToolTipText(ExercisesListView.this.labelGiveUp);
            this.add(this.btnGiveUp);
            JButton jButton = this.btnInputHint = algorithmExercise.hasInputHint() ? new JButton(Resources.getInstance().EXERCISE_INPUTHINT_ICON) : null;
            if (this.btnInputHint != null) {
                this.btnInputHint.setToolTipText(ExercisesListView.this.labelInputHint);
                this.add(this.btnInputHint);
            }
            JButton jButton2 = this.btnAnnotation = algorithmStep != null && algorithmStep.getAnnotation() != null ? new JButton(Resources.getInstance().ANNOTATION_ICON) : null;
            if (this.btnAnnotation != null) {
                this.btnAnnotation.setToolTipText(ExercisesListView.this.labelAnnotation);
                this.add(this.btnAnnotation);
            }
            JSeparator jSeparator = this.separatorAdditionalButtons = this.btnInputHint != null || this.btnAnnotation != null ? new JSeparator(1) : null;
            if (this.separatorAdditionalButtons != null) {
                this.add(this.separatorAdditionalButtons);
            }
            this.separator = new JSeparator();
            this.add(this.separator);
            this.lastPrefSize = new Dimension(-1, 0);
            this.prefSizeHeader = this.lblHeader.getPreferredSize();
            this.prefSizeResult = this.lblResult.getPreferredSize();
            this.prefSizeAttempts = this.lblAttempts.getPreferredSize();
            this.prefSizeLastSol = this.lblLastSolution.getPreferredSize();
            this.prefSizeSolveBtn = this.btnSolve.getPreferredSize();
            this.prefSizeGiveUpBtn = this.btnGiveUp.getPreferredSize();
            this.prefSizeInputHintBtn = this.btnInputHint != null ? this.btnInputHint.getPreferredSize() : new Dimension(0, 0);
            this.prefSizeAnnotationBtn = this.btnAnnotation != null ? this.btnAnnotation.getPreferredSize() : new Dimension(0, 0);
            this.prefSizeSeparator = this.separator.getPreferredSize();
            this.prefSizeSeparatorAdditionalButtons = this.separatorAdditionalButtons != null ? this.separatorAdditionalButtons.getPreferredSize() : new Dimension(0, 0);
            this.resultValueMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Item.this.showHintDialog(Item.this.exercise.getLastFailedHintMessage(), ExercisesListView.this.labelFailedHint);
                }
            };
            this.minimumWidth = this.computeMinimumWidth();
            this.setBackground(ACTIVE_ITEM_BACKGROUND);
            this.setBorder(ITEM_BORDER_ACTIVE);
            this.setLayout(null);
            this.btnSolve.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Item.this.setLockStatus(true);
                    boolean bl = Item.this.exercise.solve();
                    if (!bl) {
                        Item.this.setLockStatus(false);
                        Item.this.showHintDialog(Item.this.exercise.getInputHintMessage(ExercisesListView.this.langFile, ExercisesListView.this.langID), ExercisesListView.this.inputHintDlgTitle);
                    }
                }
            });
            this.btnGiveUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Item.this.setLockStatus(true);
                    Item.this.exercise.giveUp();
                }
            });
            if (this.btnInputHint != null) {
                this.btnInputHint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Item.this.showHintDialog(Item.this.exercise.getInputHintMessage(ExercisesListView.this.langFile, ExercisesListView.this.langID), ExercisesListView.this.inputHintDlgTitle);
                    }
                });
            }
            if (this.btnAnnotation != null) {
                this.btnAnnotation.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Annotation annotation = Item.this.step.getAnnotation();
                        if (annotation != null) {
                            new AnnotationDialog(ExercisesListView.this.exerciseModeHandler.getHost(), annotation, ExercisesListView.this.langFile, ExercisesListView.this.langID).setVisible(true);
                        }
                    }
                });
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int n;
            int n2 = n = ExercisesListView.this.scrollPane.getViewport().getWidth() >= this.minimumWidth ? ExercisesListView.this.scrollPane.getViewport().getWidth() : this.minimumWidth;
            if (n == this.lastPrefSize.width) {
                return this.lastPrefSize;
            }
            int n3 = n - 2 - 2;
            this.lastPrefSize = new Dimension(n, 0);
            Dimension dimension = ExercisesListView.getPreferredHeight(this.lblExerciseText.getText(), n3);
            int n4 = MathUtils.max(this.prefSizeResult.height + this.prefSizeAttempts.height, this.prefSizeSolveBtn.height, this.prefSizeGiveUpBtn.height);
            this.lastPrefSize.height += this.prefSizeHeader.height;
            this.lastPrefSize.height += dimension.height;
            this.lastPrefSize.height += this.prefSizeSeparator.height;
            this.lastPrefSize.height += n4;
            this.lastPrefSize.height += this.prefSizeLastSol.height;
            this.lastPrefSize.height += 7;
            return this.lastPrefSize;
        }

        @Override
        public void doLayout() {
            int n;
            int n2 = this.getWidth() - 2 - 2;
            int n3 = 5;
            int n4 = 2;
            this.lblHeader.setBounds(n4, n3, this.prefSizeHeader.width, this.prefSizeHeader.height);
            Dimension dimension = ExercisesListView.getPreferredHeight(this.lblExerciseText.getText(), n2);
            this.lblExerciseText.setBounds(n4, n3 += this.prefSizeHeader.height, dimension.width, dimension.height);
            this.separator.setBounds(n4, n3 += dimension.height, n2, this.prefSizeSeparator.height);
            int n5 = n3 += this.prefSizeSeparator.height;
            int n6 = MathUtils.max(this.prefSizeResult.height + this.prefSizeAttempts.height, this.prefSizeSolveBtn.height, this.prefSizeGiveUpBtn.height);
            int n7 = n5 + (n6 - (this.prefSizeResult.height + this.prefSizeAttempts.height)) / 2;
            int n8 = n5 + (n6 - this.prefSizeSolveBtn.height) / 2;
            int n9 = n5 + (n6 - this.prefSizeGiveUpBtn.height) / 2;
            int n10 = n5 + (n6 - this.prefSizeInputHintBtn.height) / 2;
            int n11 = n5 + (n6 - this.prefSizeAnnotationBtn.height) / 2;
            int n12 = MathUtils.max(this.prefSizeResult.width, this.prefSizeAttempts.width, this.prefSizeLastSol.width);
            this.lblResult.setBounds(n4, n7, this.prefSizeResult.width, this.prefSizeResult.height);
            Dimension dimension2 = this.lblResultValue.getPreferredSize();
            this.lblResultValue.setBounds(n4 + n12 + 3, n7 + (this.prefSizeResult.height - dimension2.height) / 2, dimension2.width, dimension2.height);
            n3 = n7 + this.prefSizeResult.height;
            this.lblAttempts.setBounds(n4, n3, this.prefSizeAttempts.width, this.prefSizeAttempts.height);
            Dimension dimension3 = this.lblAttemptsValue.getPreferredSize();
            this.lblAttemptsValue.setBounds(n4 + n12 + 3, n3 + (this.prefSizeAttempts.height - dimension3.height) / 2, dimension3.width, dimension3.height);
            int n13 = n = n2 - this.prefSizeAnnotationBtn.width - this.prefSizeInputHintBtn.width - (this.btnInputHint != null && this.btnAnnotation != null ? 5 : 0) - 1;
            if (this.btnInputHint != null) {
                this.btnInputHint.setBounds(n, n10, this.prefSizeInputHintBtn.width, this.prefSizeInputHintBtn.height);
                n13 += this.prefSizeInputHintBtn.width + 5;
            }
            if (this.btnAnnotation != null) {
                this.btnAnnotation.setBounds(n13, n11, this.prefSizeAnnotationBtn.width, this.prefSizeAnnotationBtn.height);
            }
            if (this.separatorAdditionalButtons != null) {
                this.separatorAdditionalButtons.setBounds(n - (10 + this.prefSizeSeparatorAdditionalButtons.width) / 2, n9, this.prefSizeSeparatorAdditionalButtons.width, this.prefSizeGiveUpBtn.height);
            }
            int n14 = n - 10 - this.prefSizeGiveUpBtn.width;
            this.btnGiveUp.setBounds(n14, n9, this.prefSizeGiveUpBtn.width, this.prefSizeGiveUpBtn.height);
            this.btnSolve.setBounds(n14 - 5 - this.prefSizeSolveBtn.width, n8, this.prefSizeSolveBtn.width, this.prefSizeSolveBtn.height);
            n3 = n5 + n6;
            this.lblLastSolution.setBounds(n4, n3, this.prefSizeLastSol.width, this.prefSizeLastSol.height);
            Dimension dimension4 = this.lblLastSolutionValue.getPreferredSize();
            this.lblLastSolutionValue.setBounds(n4 + n12 + 3, n3, n2 - n4 - n12 - 3, dimension4.height);
        }

        public void doProcess(boolean bl, String string) {
            this.setLockStatus(false);
            ++this.attempts;
            this.update(bl, string);
        }

        public void endProcess(boolean bl, String string) {
            this.update(bl, string);
            this.lock();
        }

        public float getTotalCredits() {
            return this.exercise.getCredits();
        }

        public float getAchievedCredits() {
            if (this.succeeded && this.attempts > 0) {
                return this.exercise.getCredits() / (float)this.attempts;
            }
            return 0.0f;
        }

        private int computeMinimumWidth() {
            int n;
            int n2 = MathUtils.max(this.prefSizeResult.width, this.prefSizeAttempts.width, this.prefSizeLastSol.width);
            int n3 = n = this.btnInputHint != null || this.btnAnnotation != null ? 10 : 0;
            if (this.btnInputHint != null) {
                n += this.prefSizeInputHintBtn.width;
            }
            if (this.btnAnnotation != null) {
                n += this.prefSizeAnnotationBtn.width;
            }
            if (this.btnInputHint != null && this.btnAnnotation != null) {
                n += 5;
            }
            return Math.max(this.prefSizeHeader.width, n2 + 50 + this.prefSizeSolveBtn.width + 5 + this.prefSizeGiveUpBtn.width + n);
        }

        private void update(boolean bl, String string) {
            String string2;
            ImageIcon imageIcon;
            boolean bl2 = this.exercise.hasLastFailedHint();
            boolean bl3 = !bl && bl2;
            this.succeeded = bl;
            if (!bl) {
                imageIcon = bl2 ? Resources.getInstance().FAILED_HINT_ICON : Resources.getInstance().FAILED_ICON;
                string2 = bl2 ? ExercisesListView.this.labelFailedHint : ExercisesListView.this.labelFailed;
            } else {
                imageIcon = this.attempts > 1 ? Resources.getInstance().SUFFICIENT_ICON : Resources.getInstance().SUCCEEDED_ICON;
                string2 = ExercisesListView.this.labelSucceeded;
            }
            this.lblAttemptsValue.setText("" + this.attempts);
            this.lblResultValue.setIcon(imageIcon);
            this.lblResultValue.setToolTipText(string2);
            this.lblResultValue.setCursor(bl3 ? Cursor.getPredefinedCursor(12) : null);
            this.lblResultValue.removeMouseListener(this.resultValueMouseListener);
            if (bl3) {
                this.lblResultValue.addMouseListener(this.resultValueMouseListener);
            }
            this.lblLastSolutionValue.setText(string);
            this.lblLastSolutionValue.setToolTipText(this.lblLastSolutionValue.getText());
            this.repaint();
        }

        private void lock() {
            this.setLockStatus(true);
            this.locked = true;
            this.setBackground(ITEM_BACKGROUND);
            this.setBorder(this.showSeparator ? ITEM_BORDER_NORMAL_WITHSEP : ITEM_BORDER_NORMAL);
            this.repaint();
        }

        private void setLockStatus(boolean bl) {
            if (this.locked) {
                return;
            }
            this.btnSolve.setEnabled(!bl);
            this.btnGiveUp.setEnabled(!bl);
            if (this.btnInputHint != null) {
                this.btnInputHint.setEnabled(!bl);
            }
            if (this.btnAnnotation != null) {
                this.btnAnnotation.setEnabled(!bl);
            }
        }

        private String getExerciseText(AlgorithmExercise<?> algorithmExercise) {
            return "<html>" + algorithmExercise.getText().replaceAll(FileUtils.LINESEPARATOR, "<br>") + "</html>";
        }

        private void showHintDialog(Annotation annotation, String string) {
            if (annotation == null) {
                return;
            }
            PluginHost pluginHost = ExercisesListView.this.exerciseModeHandler.getHost();
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jEditorPane.setEditorKit(new AnnotationViewKit(annotation.getImagesList()));
            jEditorPane.setText(annotation.getText());
            jEditorPane.setEditable(false);
            JOptionPane jOptionPane = new JOptionPane(jScrollPane, 1, -1);
            JDialog jDialog = jOptionPane.createDialog(string);
            pluginHost.adaptDialog(jDialog);
            jDialog.setVisible(true);
        }
    }
}

