/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import lavesdk.algorithm.plugin.views.DefaultNetworkView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.DefaultRNFactory;
import lavesdk.math.graph.network.Network;
import lavesdk.math.graph.network.Node;
import lavesdk.math.graph.network.RNEdge;
import lavesdk.math.graph.network.ResidualNetwork;
import lavesdk.serialization.Serializable;

public class DefaultRNView
extends GraphView<Vertex, RNEdge> {
    private static final long serialVersionUID = 1L;
    private final DefaultNetworkView networkView;
    private static final double CAPTIONADOPTION_TOLERANCE = 50.0;

    public DefaultRNView(String string, LanguageFile languageFile, String string2, DefaultNetworkView defaultNetworkView) throws IllegalArgumentException, NullPointerException {
        this(string, true, languageFile, string2, defaultNetworkView);
    }

    public DefaultRNView(String string, boolean bl, LanguageFile languageFile, String string2, DefaultNetworkView defaultNetworkView) throws IllegalArgumentException, NullPointerException {
        super(string, new ResidualNetwork((Network<? extends Node, ? extends Arc>)defaultNetworkView.getGraph()), new DefaultRNFactory(), null, bl, languageFile, string2);
        this.networkView = defaultNetworkView;
    }

    public ResidualNetwork getGraph() {
        return (ResidualNetwork)super.getGraph();
    }

    @Override
    public void setGraph(Graph<Vertex, RNEdge> graph) throws IllegalArgumentException {
        if (!(graph instanceof ResidualNetwork)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        super.setGraph(graph);
    }

    @Override
    protected void afterVisualVertexCreated(GraphView.VisualVertex visualVertex) {
        GraphView.VisualVertex visualVertex2 = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.networkView.getVisualVertexCount(); ++i) {
            GraphView.VisualVertex visualVertex3 = this.networkView.getVisualVertex(i);
            double d2 = Math.sqrt((visualVertex3.getX() - visualVertex.getX()) * (visualVertex3.getX() - visualVertex.getX()) + (visualVertex3.getY() - visualVertex.getY()) * (visualVertex3.getY() - visualVertex.getY()));
            if (!(d2 < d)) continue;
            visualVertex2 = visualVertex3;
            d = d2;
        }
        if (visualVertex2 != null && d <= 50.0) {
            ((Vertex)visualVertex.getVertex()).setCaption(((Node)visualVertex2.getVertex()).getCaption());
        }
    }

    @Override
    protected boolean beforeVisualEdgeCreated(GraphView.VisualVertex visualVertex, GraphView.VisualVertex visualVertex2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.networkView.getVisualVertexByCaption(((Vertex)visualVertex.getVertex()).getCaption()) != null && this.networkView.getVisualVertexByCaption(((Vertex)visualVertex2.getVertex()).getCaption()) != null;
        if (!bl2) {
            String string = LanguageFile.getLabel(this.langFile, "MSG_ERR_DEFAULTRNVIEW_CREATEEDGE", this.langID, "The vertices \"&predecessor&\" and \"&successor&\" do not exist in the network.\nYou can only create edges between vertices that exist in the related network!\nTip: Check the captions of the vertices.");
            JOptionPane.showMessageDialog(this, string.replace("&predecessor&", ((Vertex)visualVertex.getVertex()).getCaption()).replace("&successor&", ((Vertex)visualVertex2.getVertex()).getCaption()), LanguageFile.getLabel(this.langFile, "MSG_ERR_TITLE_DEFAULTRNVIEW_CREATEEDGE", this.langID, "Create edge"), 0);
        }
        return bl2;
    }

    @Override
    protected List<GraphView.EdgeOffset> requestOffsetEdges(GraphView.VisualVertex visualVertex, GraphView.VisualVertex visualVertex2) {
        Object object;
        Serializable serializable2;
        ArrayList<GraphView.EdgeOffset> arrayList = new ArrayList<GraphView.EdgeOffset>();
        Object v = visualVertex.getVertex();
        Object v2 = visualVertex2.getVertex();
        List list = this.getGraph().getEdges(v, v2);
        List list2 = this.getGraph().getEdges(v2, v);
        int n = 0;
        int n2 = 0;
        if (list == null) {
            return null;
        }
        for (Serializable serializable2 : list) {
            if (((RNEdge)serializable2).getRelationID() >= 0) continue;
            ++n;
        }
        if (list2 != null) {
            for (Serializable serializable2 : list2) {
                if (((RNEdge)serializable2).getRelationID() >= 0) continue;
                ++n2;
            }
        }
        if (n > 0 || n2 > 0) {
            return super.requestOffsetEdges(visualVertex, visualVertex2);
        }
        if (list.size() == 1) {
            object = (RNEdge)list.get(0);
            serializable2 = this.networkView.getVisualEdgeByID(((RNEdge)object).getRelationID());
            if (list2 == null) {
                arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object, 0));
            } else if (list2.size() == 1) {
                arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object, 1));
            } else if (serializable2 == null) {
                arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object, -2));
            } else {
                boolean bl = !((Arc)((GraphView.VisualEdge)serializable2).getEdge()).getPredecessor().getCaption().equals(((Vertex)v).getCaption()) || !((Arc)((GraphView.VisualEdge)serializable2).getEdge()).getSuccessor().getCaption().equals(((Vertex)v2).getCaption());
                boolean bl2 = false;
                for (RNEdge rNEdge : list2) {
                    if (rNEdge.getRelationID() != ((RNEdge)object).getRelationID()) continue;
                    bl2 = true;
                    break;
                }
                int n3 = bl && bl2 && list2.size() == 2 ? 2 : 1;
                arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object, bl ? -n3 : n3));
            }
        } else if (list.size() == 2) {
            Object object2;
            Object object3;
            GraphView.VisualEdge visualEdge;
            object = (RNEdge)list.get(0);
            serializable2 = (RNEdge)list.get(1);
            GraphView.VisualEdge visualEdge2 = this.networkView.getVisualEdgeByID(((RNEdge)object).getRelationID());
            GraphView.VisualEdge visualEdge3 = this.networkView.getVisualEdgeByID(((RNEdge)serializable2).getRelationID());
            if (visualEdge2 == null || visualEdge3 == null) {
                return null;
            }
            if (((Arc)visualEdge2.getEdge()).getPredecessor().getCaption().equals(((Vertex)v).getCaption()) && ((Arc)visualEdge2.getEdge()).getSuccessor().getCaption().equals(((Vertex)v2).getCaption())) {
                visualEdge = visualEdge2;
                object3 = object;
                object2 = serializable2;
            } else {
                visualEdge = visualEdge3;
                object3 = serializable2;
                object2 = object;
            }
            arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object3, visualEdge.getOffsetIndex()));
            boolean bl = false;
            if (list2 != null) {
                for (RNEdge rNEdge : list2) {
                    if (rNEdge.getRelationID() != ((RNEdge)object2).getRelationID()) continue;
                    bl = true;
                    break;
                }
            }
            arrayList.add(new GraphView.EdgeOffset((GraphView)this, (Edge)object2, -(bl ? 2 : 1)));
        }
        return arrayList;
    }
}

