/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.text.NumberFormat;
import java.text.ParseException;
import lavesdk.algorithm.plugin.views.GraphLayout;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.DefaultNetworkFactory;
import lavesdk.math.graph.network.Network;
import lavesdk.math.graph.network.Node;
import lavesdk.resources.Resources;

public class DefaultNetworkView
extends GraphView<Node, Arc> {
    private static final long serialVersionUID = 1L;
    private final String arcPropFlow;
    private boolean applyInputToFlow;
    private boolean applyInputToExcess;

    public DefaultNetworkView(String string, Network<Node, Arc> network) throws IllegalArgumentException {
        this(string, network, (GraphLayout)null);
    }

    public DefaultNetworkView(String string, Network<Node, Arc> network, GraphLayout graphLayout) throws IllegalArgumentException {
        this(string, network, graphLayout, true, "en");
    }

    public DefaultNetworkView(String string, Network<Node, Arc> network, GraphLayout graphLayout, boolean bl, String string2) throws IllegalArgumentException {
        this(string, network, graphLayout, bl, Resources.getInstance().LANGUAGE_FILE, string2);
    }

    public DefaultNetworkView(String string, Network<Node, Arc> network, GraphLayout graphLayout, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, network, new DefaultNetworkFactory(), graphLayout, bl, languageFile, string2);
        this.arcPropFlow = LanguageFile.getLabel(languageFile, "NETWORKVIEW_ARCPROPS_FLOW", string2, "Flow");
        this.applyInputToFlow = false;
        this.applyInputToExcess = false;
    }

    @Override
    public Network<Node, Arc> getGraph() {
        return (Network)super.getGraph();
    }

    @Override
    public void setGraph(Graph<Node, Arc> graph) throws IllegalArgumentException {
        if (!(graph instanceof Network)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        super.setGraph(graph);
    }

    public boolean getApplyInputToFlow() {
        if (EDT.isExecutedInEDT()) {
            return this.applyInputToFlow;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return DefaultNetworkView.this.applyInputToFlow;
            }
        });
    }

    public void setApplyInputToFlow(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.applyInputToFlow = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setApplyInputToFlow"){

                @Override
                protected void execute() throws Throwable {
                    DefaultNetworkView.this.applyInputToFlow = bl;
                }
            });
        }
    }

    public boolean getApplyInputToExcess() {
        if (EDT.isExecutedInEDT()) {
            return this.applyInputToExcess;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return DefaultNetworkView.this.applyInputToExcess;
            }
        });
    }

    public void setApplyInputToExcess(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.applyInputToExcess = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setApplyInputToExcess"){

                @Override
                protected void execute() throws Throwable {
                    DefaultNetworkView.this.applyInputToExcess = bl;
                }
            });
        }
    }

    @Override
    protected void loadAdvancedEdgeProperties(PropertiesListModel propertiesListModel, Arc arc) {
        propertiesListModel.add(new NumericProperty(this.arcPropFlow, "", Float.valueOf(arc.getFlow())));
    }

    @Override
    protected void applyAdvancedEdgeProperties(PropertiesListModel propertiesListModel, Arc arc) {
        NumericProperty numericProperty = propertiesListModel.getNumericProperty(this.arcPropFlow);
        if (numericProperty != null && numericProperty.getValue().floatValue() >= 0.0f && numericProperty.getValue().floatValue() <= arc.getWeight()) {
            arc.setFlow(numericProperty.getValue().floatValue());
        }
    }

    @Override
    protected void applyKeyboardInput(Arc arc, String string) {
        if (!this.applyInputToFlow) {
            super.applyKeyboardInput(arc, string);
        } else {
            try {
                arc.setFlow(NumberFormat.getInstance().parse(string).floatValue());
            }
            catch (IllegalArgumentException | ParseException exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void applyKeyboardInput(Node node, String string) {
        if (!this.applyInputToExcess) {
            super.applyKeyboardInput(node, string);
        } else {
            try {
                node.setExcess(NumberFormat.getInstance().parse(string).floatValue());
            }
            catch (IllegalArgumentException | ParseException exception) {
                // empty catch block
            }
        }
    }
}

