/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.util.List;
import lavesdk.algorithm.plugin.views.GraphLayout;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.utils.GraphUtils;

public class BipartiteGraphLayout
extends GraphLayout {
    private final boolean nonIncidentVerticesToSubset1;
    private static final int DEF_VERTEXPADDING = 25;
    private static final int DEF_SUBSETPADDING = 150;
    private static final int DEF_OFFSETLEFT = 50;
    private static final int DEF_OFFSETTOP = 30;

    public BipartiteGraphLayout() {
        this(true);
    }

    public BipartiteGraphLayout(boolean bl) {
        this.nonIncidentVerticesToSubset1 = bl;
    }

    @Override
    public <V extends Vertex, E extends Edge> void layout(Graph<V, E> graph, GraphView<V, E> graphView) {
        int n;
        List<List<V>> list = GraphUtils.getBipartiteVertexSets(graph, this.nonIncidentVerticesToSubset1);
        if (list == null) {
            return;
        }
        int n2 = Math.max(list.get(0).size(), list.get(1).size());
        int n3 = graph.getOrder() > 5 ? 25 + 5 * (n2 / 5) : 25;
        int n4 = (int)((float)n3 / 100.0f * (float)graphView.getZoom());
        int n5 = (int)(1.5f * (float)graphView.getZoom());
        int n6 = (int)(0.5f * (float)graphView.getZoom());
        int n7 = (int)(0.3f * (float)graphView.getZoom());
        int n8 = 0;
        for (n = 0; n < graph.getOrder(); ++n) {
            int n9 = graphView.getScaledVertexRadius(graphView.getVisualVertex((Vertex)graph.getVertex(n)));
            if (n9 <= n8) continue;
            n8 = n9;
        }
        n = n8 * 2;
        List<V> list2 = null;
        for (List<V> list3 : list) {
            if (list2 == null) {
                list2 = list3;
                continue;
            }
            if (list3.size() <= list2.size()) continue;
            list2 = list3;
        }
        int n10 = n7 + (list2 != null ? this.calculateSubsetCenter(list2, n, n4) : 0);
        int n11 = n6 + n8;
        for (List<V> list4 : list) {
            int n12 = n10 - this.calculateSubsetCenter(list4, n, n4) + n8;
            for (Vertex vertex : list4) {
                GraphView.VisualVertex visualVertex = graphView.getVisualVertex(vertex);
                if (visualVertex != null) {
                    visualVertex.setPosition(n11, n12);
                }
                n12 += n + n4;
            }
            n11 += n + n5;
        }
    }

    private <V extends Vertex> int calculateSubsetCenter(List<V> list, int n, int n2) {
        return (list.size() * n + (list.size() - 1) * n2) / 2;
    }
}

