/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.views.FontHeaderBarExtension;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.AlgorithmTextListener;
import lavesdk.algorithm.text.Annotation;
import lavesdk.configuration.Configuration;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.dialogs.AnnotationDialog;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;
import org.scilab.forge.jlatexmath.TeXIcon;

public class AlgorithmTextView
extends View {
    private static final long serialVersionUID = 1L;
    private final PluginHost host;
    private final AlgorithmText text;
    private final JScrollPane scrollPane;
    private final AlgorithmTextDrawingPanel textPanel;
    private final EventController eventController;
    private final List<VisualParagraph> visualParagraphs;
    private int executingParagraphID;
    private Color highlightBGColor;
    private Color highlightFGColor;
    private Color haltedBGColor;
    private Color haltedFGColor;
    private Font highlightFont;
    private int paragraphColumnWidth;
    private AlgorithmStep selectedStep;
    private final Color selectionBGColor;
    private final Color selectionFGColor;
    private final JPopupMenu popupMenu;
    private final JMenuItem pmimAddBreakpoint;
    private final JMenuItem pmimRemoveBreakpoint;
    private final JMenuItem pmimSetAllBreakpoints;
    private final JMenuItem pmimRemoveAllBreakpoints;
    private final JMenuItem pmimShowAnnotation;
    private final JToggleButton toggleBreakpointBtn;
    private final JButton showAnnotationBtn;
    private static Image breakpointIcon;
    private static Image activeBreakpointIcon;
    private static final int BREAKPOINT_WIDTH;
    private static final int BREAKPOINT_HEIGHT;
    private static final int BREAKPOINT_HSPACE;
    private static final int PARAGRAPHCOL_RIGHT_PADDING = 10;
    private static final int TEXT_PADDING = 2;
    private static final Color DEF_HIGHLIGHTBGCOLOR;
    private static final Color DEF_HIGHLIGHTFGCOLOR;
    private static final Color DEF_HALTEDBGCOLOR;
    private static final Color DEF_HALTEDFGCOLOR;

    public AlgorithmTextView(PluginHost pluginHost, String string, AlgorithmText algorithmText) throws IllegalArgumentException {
        this(pluginHost, string, algorithmText, true);
    }

    public AlgorithmTextView(PluginHost pluginHost, String string, AlgorithmText algorithmText, boolean bl) throws IllegalArgumentException {
        this(pluginHost, string, algorithmText, bl, null, null);
    }

    public AlgorithmTextView(PluginHost pluginHost, String string, AlgorithmText algorithmText, boolean bl, LanguageFile languageFile, String string2) throws IllegalArgumentException {
        super(string, bl, languageFile, string2);
        if (pluginHost == null || algorithmText == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.host = pluginHost;
        this.text = algorithmText;
        this.textPanel = new AlgorithmTextDrawingPanel();
        this.scrollPane = new JScrollPane(this.textPanel);
        this.eventController = new EventController();
        this.visualParagraphs = new ArrayList<VisualParagraph>();
        this.executingParagraphID = this.getExecutingParagraphID();
        this.highlightBGColor = DEF_HIGHLIGHTBGCOLOR;
        this.highlightFGColor = DEF_HIGHLIGHTFGCOLOR;
        this.haltedBGColor = DEF_HALTEDBGCOLOR;
        this.haltedFGColor = DEF_HALTEDFGCOLOR;
        this.selectionBGColor = SystemColor.textHighlight;
        this.selectionFGColor = SystemColor.textHighlightText;
        this.selectedStep = null;
        this.popupMenu = new JPopupMenu();
        this.pmimAddBreakpoint = new JMenuItem(LanguageFile.getLabel(languageFile, "TEXTVIEW_ADD_BREAKPOINT", string2, "Add Breakpoint"), Resources.getInstance().BREAKPOINT_ICON);
        this.pmimRemoveBreakpoint = new JMenuItem(LanguageFile.getLabel(languageFile, "TEXTVIEW_REMOVE_BREAKPOINT", string2, "Remove Breakpoint"));
        this.pmimSetAllBreakpoints = new JMenuItem(LanguageFile.getLabel(languageFile, "TEXTVIEW_SET_ALL_BREAKPOINTS", string2, "Set All Breakpoints"));
        this.pmimRemoveAllBreakpoints = new JMenuItem(LanguageFile.getLabel(languageFile, "TEXTVIEW_REMOVE_ALL_BREAKPOINTS", string2, "Remove All Breakpoints"));
        this.pmimShowAnnotation = new JMenuItem(LanguageFile.getLabel(languageFile, "TEXTVIEW_SHOW_ANNOTATION", string2, "Show Annotation"), Resources.getInstance().ANNOTATION_ICON);
        this.toggleBreakpointBtn = new JToggleButton(Resources.getInstance().BREAKPOINT_ICON);
        this.showAnnotationBtn = new JButton(Resources.getInstance().ANNOTATION_ICON);
        this.popupMenu.add(this.pmimAddBreakpoint);
        this.popupMenu.add(this.pmimRemoveBreakpoint);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.pmimSetAllBreakpoints);
        this.popupMenu.add(this.pmimRemoveAllBreakpoints);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.pmimShowAnnotation);
        new FontHeaderBarExtension(this, 12.0f, true, languageFile, string2).apply();
        this.addHeaderBarComponent(this.toggleBreakpointBtn);
        this.addHeaderBarSeparator();
        this.addHeaderBarComponent(this.showAnnotationBtn);
        if (bl) {
            this.addHeaderBarSeparator();
        }
        this.toggleBreakpointBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "TEXTVIEW_TOGGLE_BREAKPOINT_BTN_TOOLTIP", string2, "Toggle Breakpoint") + "</html>");
        this.showAnnotationBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "TEXTVIEW_SHOW_ANNOTATION", string2, "Show Annotation") + "</html>");
        this.updateToolBarButtonsState();
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)this.scrollPane, "Center");
        this.textPanel.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        Font font = UIManager.getFont("TextPane.font");
        super.setFont(font.deriveFont(algorithmText.getFontSize()));
        this.updateHighlightFont();
        this.setForeground(Color.black);
        this.createTextStructure();
        this.addComponentListener(this.eventController);
        algorithmText.addTextListener(this.eventController);
        this.textPanel.addMouseListener(this.eventController);
        this.textPanel.addMouseMotionListener(this.eventController);
        this.pmimAddBreakpoint.addActionListener(this.eventController);
        this.pmimRemoveBreakpoint.addActionListener(this.eventController);
        this.pmimSetAllBreakpoints.addActionListener(this.eventController);
        this.pmimRemoveAllBreakpoints.addActionListener(this.eventController);
        this.pmimShowAnnotation.addActionListener(this.eventController);
        this.toggleBreakpointBtn.addActionListener(this.eventController);
        this.showAnnotationBtn.addActionListener(this.eventController);
    }

    @Override
    public boolean getAutoRepaint() {
        return super.getAutoRepaint();
    }

    @Override
    public void setAutoRepaint(boolean bl) {
        super.setAutoRepaint(bl);
    }

    public AlgorithmText getText() {
        if (EDT.isExecutedInEDT()) {
            return this.text;
        }
        return EDT.execute(new GuiRequest<AlgorithmText>(){

            @Override
            protected AlgorithmText execute() throws Throwable {
                return AlgorithmTextView.this.text;
            }
        });
    }

    public Color getHighlightForeground() {
        if (EDT.isExecutedInEDT()) {
            return this.highlightFGColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return AlgorithmTextView.this.highlightFGColor;
            }
        });
    }

    public void setHighlightForeground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.highlightFGColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setHeighlightForeground"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.highlightFGColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    public Color getHighlightBackground() {
        if (EDT.isExecutedInEDT()) {
            return this.highlightBGColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return AlgorithmTextView.this.highlightBGColor;
            }
        });
    }

    public void setHighlightBackground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.highlightBGColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setHighlightBackground"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.highlightBGColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    public Color getHaltedForeground() {
        if (EDT.isExecutedInEDT()) {
            return this.haltedFGColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return AlgorithmTextView.this.haltedFGColor;
            }
        });
    }

    public void setHaltedForeground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.haltedFGColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setHaltedForeground"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.haltedFGColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    public Color getHaltedBackground() {
        if (EDT.isExecutedInEDT()) {
            return this.haltedBGColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return AlgorithmTextView.this.haltedBGColor;
            }
        });
    }

    public void setHaltedBackground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.haltedBGColor = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setHaltedBackground"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.haltedBGColor = color;
                }
            });
        }
        this.autoRepaint();
    }

    @Override
    public void reset() {
        if (EDT.isExecutedInEDT()) {
            this.deselectStep(true);
            this.computeTextLayout();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".reset"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.deselectStep(true);
                    AlgorithmTextView.this.computeTextLayout();
                }
            });
        }
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetFont(font);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.internalSetFont(font);
                }
            });
        }
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        this.textPanel.repaint();
    }

    @Override
    protected void autoRepaint() {
        if (this.getAutoRepaint()) {
            this.textPanel.repaint();
        }
    }

    @Override
    protected void readConfigurationData(Configuration configuration) {
        super.readConfigurationData(configuration);
        this.setHighlightBackground(configuration.getColor("highlightBG", DEF_HIGHLIGHTBGCOLOR));
        this.setHighlightForeground(configuration.getColor("highlightFG", DEF_HIGHLIGHTFGCOLOR));
        this.setHaltedBackground(configuration.getColor("haltedBG", DEF_HALTEDBGCOLOR));
        this.setHaltedForeground(configuration.getColor("haltedFG", DEF_HALTEDFGCOLOR));
        this.setFont(this.getFont().deriveFont(configuration.getFloat("fontSize", 12.0f)));
        Collection collection = configuration.getCollection("breakpoints", null);
        if (collection != null) {
            for (Integer n : collection) {
                AlgorithmStep algorithmStep = this.text.getStepByID(n);
                if (algorithmStep == null) continue;
                algorithmStep.setBreakpoint(true);
            }
        }
    }

    @Override
    protected void writeConfigurationData(Configuration configuration) {
        super.writeConfigurationData(configuration);
        configuration.addColor("highlightBG", this.getHighlightBackground());
        configuration.addColor("highlightFG", this.getHighlightForeground());
        configuration.addColor("haltedBG", this.getHaltedBackground());
        configuration.addColor("haltedFG", this.getHaltedForeground());
        configuration.addFloat("fontSize", this.getFont().getSize2D());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.text.getStepCount(); ++i) {
            if (!this.text.getStep(i).hasBreakpoint()) continue;
            arrayList.add(this.text.getStep(i).getID());
        }
        configuration.addCollection("breakpoints", arrayList);
    }

    private void mouseDown(MouseEvent mouseEvent) {
        VisualToken visualToken = this.getTokenFromPosition(mouseEvent.getX(), mouseEvent.getY());
        if (visualToken != null) {
            this.selectStep(visualToken, true);
        } else {
            this.deselectStep(true);
        }
    }

    private void mouseUp(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.pmimAddBreakpoint.setEnabled(this.selectedStep != null && !this.selectedStep.hasBreakpoint());
            this.pmimRemoveBreakpoint.setEnabled(this.selectedStep != null && this.selectedStep.hasBreakpoint());
            this.pmimShowAnnotation.setEnabled(this.selectedStep != null && this.selectedStep.getAnnotation() != null);
            this.popupMenu.show(this.textPanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        if (this.getTokenFromPosition(mouseEvent.getX(), mouseEvent.getY()) != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void mouseDblClicked(MouseEvent mouseEvent) {
        this.doToggleBreakpoint();
    }

    private void internalSetFont(Font font) {
        super.setFont(font);
        this.text.setFontSize(font.getSize());
        this.updateHighlightFont();
    }

    private void doAddBreakpoint() {
        if (this.selectedStep == null) {
            return;
        }
        this.selectedStep.setBreakpoint(true);
        this.updateToolBarButtonsState();
        this.computeTextLayout();
    }

    private void doRemoveBreakpoint() {
        if (this.selectedStep == null) {
            return;
        }
        this.selectedStep.setBreakpoint(false);
        this.updateToolBarButtonsState();
        this.computeTextLayout();
    }

    private void doSetAllBreakpoints(boolean bl) {
        for (int i = 0; i < this.text.getStepCount(); ++i) {
            this.text.getStep(i).setBreakpoint(bl);
        }
        this.updateToolBarButtonsState();
        this.computeTextLayout();
    }

    private void doShowAnnotation() {
        if (this.selectedStep == null) {
            return;
        }
        Annotation annotation = this.selectedStep.getAnnotation();
        new AnnotationDialog(this.host, annotation, this.langFile, this.langID).setVisible(true);
    }

    private void doToggleBreakpoint() {
        if (this.selectedStep == null) {
            return;
        }
        this.selectedStep.setBreakpoint(!this.selectedStep.hasBreakpoint());
        this.toggleBreakpointBtn.setSelected(this.selectedStep.hasBreakpoint());
        this.computeTextLayout();
    }

    private void updateToolBarButtonsState() {
        this.toggleBreakpointBtn.setSelected(this.selectedStep != null && this.selectedStep.hasBreakpoint());
        this.toggleBreakpointBtn.setEnabled(this.selectedStep != null);
        this.showAnnotationBtn.setEnabled(this.selectedStep != null && this.selectedStep.getAnnotation() != null);
    }

    private void selectStep(VisualToken visualToken, boolean bl) {
        this.deselectStep(false);
        this.selectedStep = visualToken.getStep();
        block0: for (VisualParagraph visualParagraph : this.visualParagraphs) {
            if (visualParagraph.getParagraph().getID() != this.selectedStep.getParagraph().getID()) continue;
            boolean bl2 = false;
            for (VisualToken visualToken2 : visualParagraph.getTokens()) {
                if (visualToken2.getStep().getID() == this.selectedStep.getID()) {
                    visualToken2.setSelected(true);
                    bl2 = true;
                    continue;
                }
                if (!bl2) continue;
                continue block0;
            }
        }
        this.updateToolBarButtonsState();
        if (bl) {
            this.textPanel.repaint();
        }
    }

    private void deselectStep(boolean bl) {
        if (this.selectedStep == null) {
            return;
        }
        block0: for (VisualParagraph visualParagraph : this.visualParagraphs) {
            if (visualParagraph.getParagraph().getID() != this.selectedStep.getParagraph().getID()) continue;
            boolean bl2 = false;
            for (VisualToken visualToken : visualParagraph.getTokens()) {
                if (visualToken.isSelected()) {
                    visualToken.setSelected(false);
                    bl2 = true;
                    continue;
                }
                if (!bl2) continue;
                continue block0;
            }
        }
        this.selectedStep = null;
        this.updateToolBarButtonsState();
        if (bl) {
            this.textPanel.repaint();
        }
    }

    private int getExecutingParagraphID() {
        AlgorithmStep algorithmStep = this.text.getStepByID(this.text.getExecutingStepID());
        return algorithmStep != null ? algorithmStep.getParagraph().getID() : -1;
    }

    private VisualToken getTokenFromPosition(int n, int n2) {
        for (VisualParagraph visualParagraph : this.visualParagraphs) {
            if (n2 < visualParagraph.getY() || n2 > visualParagraph.getY() + visualParagraph.getHeight()) continue;
            for (VisualTokenLine visualTokenLine : visualParagraph.getLines()) {
                if (n2 < visualTokenLine.getY() || n2 > visualTokenLine.getY() + visualTokenLine.getHeight() || n < visualTokenLine.getX() || n > visualTokenLine.getX() + visualTokenLine.getWidth()) continue;
                int n3 = visualTokenLine.getX();
                for (int i = 0; i < visualTokenLine.getTokenCount(); ++i) {
                    VisualToken visualToken = visualTokenLine.getToken(i);
                    if (n >= n3 && n <= n3 + visualToken.getWidth()) {
                        return visualToken;
                    }
                    n3 += visualToken.getWidth();
                }
            }
        }
        return null;
    }

    private void updateTextLayout() {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        int n = this.executingParagraphID;
        this.executingParagraphID = this.getExecutingParagraphID();
        if (this.selectedStep != null && this.selectedStep.getID() == this.text.getExecutingStepID()) {
            this.deselectStep(false);
        }
        if (this.executingParagraphID != n) {
            this.computeTextLayout();
        }
        if (this.executingParagraphID >= 0) {
            boolean bl = false;
            for (VisualParagraph visualParagraph : this.visualParagraphs) {
                if (visualParagraph.getParagraph().getID() == this.executingParagraphID) {
                    for (VisualToken visualToken : visualParagraph.getTokens()) {
                        if (visualToken.getStep().getID() != this.text.getExecutingStepID() || !visualToken.isFirstToken()) continue;
                        if (visualToken.getLine() != null) {
                            Point point = new Point();
                            if (visualToken.getLine().getY() < rectangle.y || visualToken.getLine().getY() > rectangle.y + rectangle.height || visualToken.getLine().getX() < rectangle.x || visualToken.getLine().getX() > rectangle.x + rectangle.width) {
                                point.y = visualToken.getLine().getY();
                                point.x = visualToken.getLine().getX() > rectangle.x + rectangle.width ? visualToken.getLine().getX() : rectangle.x;
                                this.scrollPane.getViewport().setViewPosition(point);
                            }
                        }
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                break;
            }
        }
        this.textPanel.repaint();
    }

    private void updateHighlightFont() {
        Font font = this.getFont();
        this.highlightFont = font.deriveFont(1);
        for (VisualParagraph visualParagraph : this.visualParagraphs) {
            for (VisualToken visualToken : visualParagraph.getTokens()) {
                visualToken.updatePossibleExtents(this.getFont(), this.highlightFont);
            }
        }
        this.computeParagraphColWidth();
        this.computeTextLayout();
    }

    private void computeTextLayout() {
        Rectangle rectangle = this.scrollPane.getBounds();
        FontMetrics fontMetrics = this.getFontMetrics(this.highlightFont);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.getFont());
        int n = 2 + this.paragraphColumnWidth;
        int n2 = fontMetrics2.stringWidth(" ");
        int n3 = 2;
        int n4 = n;
        int n5 = n3;
        VisualTokenLine visualTokenLine = null;
        for (VisualParagraph visualParagraph : this.visualParagraphs) {
            visualParagraph.setX(2);
            visualParagraph.setY(n3);
            visualParagraph.setNameMetrics(visualParagraph.getParagraph().getID() == this.executingParagraphID ? fontMetrics : fontMetrics2);
            visualParagraph.getLines().clear();
            boolean bl = false;
            boolean bl2 = false;
            int n6 = 0;
            for (VisualToken visualToken : visualParagraph.getTokens()) {
                int n7 = visualToken.getStep().getIndent();
                bl2 = bl && n7 != n6;
                n6 = n7;
                if (!bl) {
                    visualTokenLine = new VisualTokenLine();
                    visualParagraph.getLines().add(visualTokenLine);
                    visualTokenLine.setX(n + n7 * n2);
                    visualTokenLine.setY(n3);
                    bl = true;
                }
                visualToken.computeExtent(visualParagraph.getParagraph().getID() == this.executingParagraphID);
                if (visualToken.getToken().type == AlgorithmStep.TextTokenType.LINEBREAK) {
                    visualTokenLine.addToken(visualToken);
                    visualToken.setLine(visualTokenLine);
                    bl2 = true;
                }
                if (bl2 || visualTokenLine.hasTokens() && visualTokenLine.getX() + visualTokenLine.getWidth() + visualToken.getWidth() >= rectangle.x + rectangle.width - 2 - 1) {
                    visualTokenLine = new VisualTokenLine();
                    visualParagraph.getLines().add(visualTokenLine);
                    visualTokenLine.setX(n + n7 * n2);
                    visualTokenLine.setY(n3 += visualTokenLine.getHeight());
                }
                if (visualToken.getToken().type != AlgorithmStep.TextTokenType.LINEBREAK) {
                    visualTokenLine.addToken(visualToken);
                    visualToken.setLine(visualTokenLine);
                }
                if (visualTokenLine.getX() + visualTokenLine.getWidth() <= n4) continue;
                n4 = visualTokenLine.getX() + visualTokenLine.getWidth();
            }
            visualParagraph.computeHeight();
            n5 += visualParagraph.getHeight();
            n3 += visualTokenLine.getHeight();
        }
        this.textPanel.setPreferredSize(new Dimension(n4 += 2, n5 += 2));
        this.textPanel.revalidate();
        this.textPanel.repaint();
    }

    private void computeParagraphColWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.highlightFont);
        this.paragraphColumnWidth = 0;
        for (int i = 0; i < this.text.getParagraphCount(); ++i) {
            int n = fontMetrics.stringWidth(this.text.getParagraph(i).getName());
            if (n > 0) {
                n += 10;
            }
            if (n <= this.paragraphColumnWidth) continue;
            this.paragraphColumnWidth = n;
        }
    }

    private void createTextStructure() {
        this.visualParagraphs.clear();
        for (int i = 0; i < this.text.getParagraphCount(); ++i) {
            AlgorithmParagraph algorithmParagraph = this.text.getParagraph(i);
            VisualParagraph visualParagraph = new VisualParagraph(algorithmParagraph);
            this.visualParagraphs.add(visualParagraph);
            for (int j = 0; j < algorithmParagraph.getStepCount(); ++j) {
                AlgorithmStep algorithmStep = algorithmParagraph.getStep(j);
                for (int k = 0; k < algorithmStep.getTextTokenCount(); ++k) {
                    VisualToken visualToken = new VisualToken(algorithmStep, algorithmStep.getTextToken(k), k == 0);
                    visualToken.updatePossibleExtents(this.getFont(), this.highlightFont);
                    visualParagraph.getTokens().add(visualToken);
                }
            }
        }
        this.computeParagraphColWidth();
    }

    private void paint(Graphics2D graphics2D) {
        for (VisualParagraph visualParagraph : this.visualParagraphs) {
            boolean bl = visualParagraph.getParagraph().getID() == this.executingParagraphID;
            graphics2D.setFont(bl ? this.highlightFont : this.getFont());
            graphics2D.setColor(Color.black);
            graphics2D.drawString(visualParagraph.getParagraph().getName(), visualParagraph.getX(), visualParagraph.getNameY());
            for (VisualTokenLine visualTokenLine : visualParagraph.getLines()) {
                int n = visualTokenLine.getX();
                for (int i = 0; i < visualTokenLine.getTokenCount(); ++i) {
                    VisualToken visualToken = visualTokenLine.getToken(i);
                    visualToken.draw(graphics2D, n, visualTokenLine.getY(), visualTokenLine.getBaseline(), bl, visualToken.getStep().getID() == this.text.getExecutingStepID(), this.getFont(), this.highlightFont);
                    n += visualToken.getWidth();
                }
            }
        }
    }

    static {
        DEF_HIGHLIGHTBGCOLOR = Color.white;
        DEF_HIGHLIGHTFGCOLOR = new Color(0, 115, 200);
        DEF_HALTEDBGCOLOR = new Color(255, 242, 242);
        DEF_HALTEDFGCOLOR = new Color(0, 127, 127);
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        if (Resources.getInstance().BREAKPOINT_ICON != null) {
            breakpointIcon = Resources.getInstance().BREAKPOINT_ICON.getImage();
            dimension.width = Resources.getInstance().BREAKPOINT_ICON.getIconWidth();
            dimension.height = Resources.getInstance().BREAKPOINT_ICON.getIconHeight();
        } else {
            breakpointIcon = new BufferedImage(16, 16, 1);
            dimension.height = 16;
            dimension.width = 16;
        }
        if (Resources.getInstance().BREAKPOINT_ACTIVE_ICON != null) {
            activeBreakpointIcon = Resources.getInstance().BREAKPOINT_ACTIVE_ICON.getImage();
            dimension2.width = Resources.getInstance().BREAKPOINT_ACTIVE_ICON.getIconWidth();
            dimension2.height = Resources.getInstance().BREAKPOINT_ACTIVE_ICON.getIconHeight();
        } else {
            activeBreakpointIcon = new BufferedImage(16, 16, 1);
            dimension2.height = 16;
            dimension2.width = 16;
        }
        BREAKPOINT_WIDTH = Math.max(dimension.width, dimension2.width);
        BREAKPOINT_HEIGHT = Math.max(dimension.height, dimension2.height);
        BREAKPOINT_HSPACE = BREAKPOINT_WIDTH + 1;
    }

    private class EventController
    implements AlgorithmTextListener,
    ComponentListener,
    MouseListener,
    MouseMotionListener,
    ActionListener {
        private EventController() {
        }

        @Override
        public void structureChanged() {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".structureChanged"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.createTextStructure();
                    AlgorithmTextView.this.computeTextLayout();
                }
            });
        }

        @Override
        public void executingStepChanged() {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".executingStepChanged"){

                @Override
                protected void execute() throws Throwable {
                    AlgorithmTextView.this.updateTextLayout();
                }
            });
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            AlgorithmTextView.this.computeTextLayout();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                AlgorithmTextView.this.mouseDblClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AlgorithmTextView.this.mouseExited(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AlgorithmTextView.this.mouseDown(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            AlgorithmTextView.this.mouseUp(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            AlgorithmTextView.this.mouseMoved(mouseEvent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AlgorithmTextView.this.pmimAddBreakpoint) {
                AlgorithmTextView.this.doAddBreakpoint();
            } else if (actionEvent.getSource() == AlgorithmTextView.this.pmimRemoveBreakpoint) {
                AlgorithmTextView.this.doRemoveBreakpoint();
            } else if (actionEvent.getSource() == AlgorithmTextView.this.pmimSetAllBreakpoints) {
                AlgorithmTextView.this.doSetAllBreakpoints(true);
            } else if (actionEvent.getSource() == AlgorithmTextView.this.pmimRemoveAllBreakpoints) {
                AlgorithmTextView.this.doSetAllBreakpoints(false);
            } else if (actionEvent.getSource() == AlgorithmTextView.this.pmimShowAnnotation) {
                AlgorithmTextView.this.doShowAnnotation();
            } else if (actionEvent.getSource() == AlgorithmTextView.this.toggleBreakpointBtn) {
                AlgorithmTextView.this.doToggleBreakpoint();
            } else if (actionEvent.getSource() == AlgorithmTextView.this.showAnnotationBtn) {
                AlgorithmTextView.this.doShowAnnotation();
            }
        }
    }

    private class VisualTokenLine {
        private final List<VisualToken> tokens = new ArrayList<VisualToken>();
        private int x = 0;
        private int y = 0;
        private int width = 0;
        private int height = 0;
        private int baseline = 0;

        public final int getTokenCount() {
            return this.tokens.size();
        }

        public final VisualToken getToken(int n) throws IndexOutOfBoundsException {
            return this.tokens.get(n);
        }

        public final void addToken(VisualToken visualToken) throws IllegalArgumentException {
            if (visualToken == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            if (this.tokens.add(visualToken)) {
                if (this.tokens.size() == 1 || visualToken.getHeight() > this.height) {
                    this.height = visualToken.getHeight();
                }
                if (visualToken.getBaseline() > this.baseline) {
                    this.baseline = visualToken.getBaseline();
                }
                this.width += visualToken.getWidth();
            }
        }

        public final boolean hasTokens() {
            return this.tokens.size() > 0;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getBaseline() {
            return this.baseline;
        }
    }

    private class VisualToken {
        private final AlgorithmStep step;
        private final AlgorithmStep.TextToken token;
        private final boolean firstToken;
        private int width;
        private int height;
        private int baseline;
        private int widthNormal;
        private int heightNormal;
        private int widthHighlighted;
        private int heightHighlighted;
        private int baselineNormal;
        private int baselineHighlighted;
        private final int formulaOffsetY;
        private boolean selected;
        private VisualTokenLine line;

        public VisualToken(AlgorithmStep algorithmStep, AlgorithmStep.TextToken textToken, boolean bl) throws IllegalArgumentException {
            if (algorithmStep == null || textToken == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.step = algorithmStep;
            this.token = textToken;
            this.width = 0;
            this.height = 0;
            this.firstToken = bl;
            this.widthNormal = 0;
            this.heightNormal = 0;
            this.widthHighlighted = 0;
            this.heightHighlighted = 0;
            this.baseline = 0;
            this.baselineNormal = 0;
            this.baselineHighlighted = 0;
            this.formulaOffsetY = textToken.type == AlgorithmStep.TextTokenType.FORMULA && textToken.formula.getParameterCount() > 0 ? textToken.formula.getIntParameter(0) : 0;
            this.selected = false;
            this.line = null;
        }

        public final AlgorithmStep getStep() {
            return this.step;
        }

        public final boolean isFirstToken() {
            return this.firstToken;
        }

        public final AlgorithmStep.TextToken getToken() {
            return this.token;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getBaseline() {
            return this.baseline;
        }

        public final VisualTokenLine getLine() {
            return this.line;
        }

        public final boolean isSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public final void setLine(VisualTokenLine visualTokenLine) {
            this.line = visualTokenLine;
        }

        public void updatePossibleExtents(Font font, Font font2) {
            if (this.token.type == AlgorithmStep.TextTokenType.FORMULA) {
                this.widthNormal = this.token.formula.getNormal().getIconWidth();
                this.heightNormal = this.token.formula.getNormal().getIconHeight();
                this.baselineNormal = (int)(this.token.formula.getNormal().getBaseLine() * (float)this.heightNormal);
                this.widthHighlighted = this.token.formula.getHighlighted().getIconWidth();
                this.heightHighlighted = this.token.formula.getHighlighted().getIconHeight();
                this.baselineHighlighted = (int)(this.token.formula.getHighlighted().getBaseLine() * (float)this.heightHighlighted);
            } else if (this.token.type == AlgorithmStep.TextTokenType.STRING) {
                FontMetrics fontMetrics = AlgorithmTextView.this.getFontMetrics(font);
                FontMetrics fontMetrics2 = AlgorithmTextView.this.getFontMetrics(font2);
                this.widthNormal = fontMetrics.stringWidth(this.token.string);
                this.heightNormal = fontMetrics.getHeight();
                this.baselineNormal = fontMetrics.getAscent();
                this.widthHighlighted = fontMetrics2.stringWidth(this.token.string);
                this.heightHighlighted = fontMetrics2.getHeight();
                this.baselineHighlighted = fontMetrics2.getAscent();
            } else {
                FontMetrics fontMetrics = AlgorithmTextView.this.getFontMetrics(font);
                this.widthHighlighted = 0;
                this.widthNormal = 0;
                this.heightNormal = this.heightHighlighted = fontMetrics.getHeight();
                this.baselineNormal = this.baselineHighlighted = fontMetrics.getAscent();
            }
        }

        public void computeExtent(boolean bl) {
            this.width = bl ? this.widthHighlighted : this.widthNormal;
            this.height = bl ? this.heightHighlighted : this.heightNormal;
            int n = this.baseline = bl ? this.baselineHighlighted : this.baselineNormal;
            if (this.firstToken && this.step.hasBreakpoint()) {
                this.width += BREAKPOINT_HSPACE;
            }
        }

        public void draw(Graphics2D graphics2D, int n, int n2, int n3, boolean bl, boolean bl2, Font font, Font font2) {
            graphics2D.setFont(bl ? font2 : font);
            if (bl2) {
                graphics2D.setColor(this.step.hasBreakpoint() ? AlgorithmTextView.this.haltedBGColor : AlgorithmTextView.this.highlightBGColor);
                graphics2D.fillRect(n, this.line.getY(), this.width, this.line.getHeight());
                graphics2D.setColor(this.step.hasBreakpoint() ? AlgorithmTextView.this.haltedFGColor : AlgorithmTextView.this.highlightFGColor);
            } else if (this.selected) {
                graphics2D.setColor(AlgorithmTextView.this.selectionBGColor);
                graphics2D.fillRect(n, n2 + n3 - this.baseline + this.formulaOffsetY, this.width, this.height);
                graphics2D.setColor(AlgorithmTextView.this.selectionFGColor);
            } else {
                graphics2D.setColor(AlgorithmTextView.this.getForeground());
            }
            if (this.firstToken && this.step.hasBreakpoint()) {
                graphics2D.drawImage(bl2 ? activeBreakpointIcon : breakpointIcon, n, n2 + n3 - BREAKPOINT_HEIGHT + 3, null);
                n += BREAKPOINT_HSPACE;
            }
            if (this.token.type == AlgorithmStep.TextTokenType.STRING) {
                graphics2D.drawString(this.token.string, n, n2 + n3);
            } else if (this.token.type == AlgorithmStep.TextTokenType.FORMULA) {
                TeXIcon teXIcon = bl ? this.token.formula.getHighlighted() : this.token.formula.getNormal();
                teXIcon.setForeground(graphics2D.getColor());
                teXIcon.paintIcon(null, graphics2D, n, n2 + n3 - this.baseline + this.formulaOffsetY);
            }
        }
    }

    private class VisualParagraph {
        private final AlgorithmParagraph paragraph;
        private final List<VisualToken> tokens;
        private final List<VisualTokenLine> lines;
        private int x;
        private int y;
        private int height;
        private int nameHeight;
        private int nameAscent;

        public VisualParagraph(AlgorithmParagraph algorithmParagraph) throws IllegalArgumentException {
            if (algorithmParagraph == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.paragraph = algorithmParagraph;
            this.tokens = new ArrayList<VisualToken>();
            this.lines = new ArrayList<VisualTokenLine>();
            this.x = 0;
            this.y = 0;
            this.height = 0;
            this.nameHeight = 0;
            this.nameAscent = 0;
        }

        public final AlgorithmParagraph getParagraph() {
            return this.paragraph;
        }

        public final List<VisualToken> getTokens() {
            return this.tokens;
        }

        public final List<VisualTokenLine> getLines() {
            return this.lines;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void computeHeight() {
            this.height = 0;
            for (VisualTokenLine visualTokenLine : this.lines) {
                this.height += visualTokenLine.getHeight();
            }
            if (this.height < this.nameHeight) {
                this.height = this.nameHeight;
            }
        }

        public final int getNameY() {
            if (this.lines.size() > 0) {
                return this.y + this.lines.get(0).getBaseline();
            }
            return this.y + this.nameAscent;
        }

        public final void setNameMetrics(FontMetrics fontMetrics) {
            this.nameHeight = fontMetrics.getHeight();
            this.nameAscent = fontMetrics.getAscent();
        }
    }

    private class AlgorithmTextDrawingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private AlgorithmTextDrawingPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            AlgorithmTextView.this.paint((Graphics2D)graphics);
        }
    }
}

