/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public abstract class ToolBarExtension {
    private final List<JComponent> components = new ArrayList<JComponent>();
    private boolean enabled = true;

    public ToolBarExtension(boolean bl) {
        if (bl) {
            this.addSeparator();
        }
    }

    public final void apply(JToolBar jToolBar) {
        for (JComponent jComponent : this.components) {
            jToolBar.add(jComponent);
        }
    }

    public final void remove(JToolBar jToolBar) {
        for (JComponent jComponent : this.components) {
            jToolBar.remove(jComponent);
        }
    }

    protected final void addButton(JButton jButton) throws IllegalArgumentException {
        if (jButton == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!this.components.contains(jButton)) {
            this.components.add(jButton);
        }
        jButton.setEnabled(this.enabled);
    }

    protected final void addSeparator() {
        this.components.add(new JToolBar.Separator());
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        for (JComponent jComponent : this.components) {
            jComponent.setEnabled(bl);
        }
    }

    public boolean getShowInMenu() {
        return false;
    }

    public String getMenuOptionText() {
        return "NONE";
    }

    public Icon getMenuOptionIcon() {
        return null;
    }

    public void showMenuOption() {
    }
}

