/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.gui.dialogs.AdjacencyMatrixDialog;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;
import lavesdk.utils.GraphUtils;

public class MatrixToGraphToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final PluginHost host;
    private final LanguageFile langFile;
    private final String langID;
    private final GraphView<V, E> graphView;
    private final JButton matrixToGraph;
    private AllowedGraphType type;

    public MatrixToGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType) throws IllegalArgumentException {
        this(pluginHost, graphView, allowedGraphType, null, "");
    }

    public MatrixToGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(pluginHost, graphView, allowedGraphType, languageFile, string, true);
    }

    public MatrixToGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType, LanguageFile languageFile, String string, boolean bl) throws IllegalArgumentException {
        super(bl);
        if (graphView == null || allowedGraphType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.host = pluginHost;
        this.langFile = languageFile;
        this.langID = string;
        this.graphView = graphView;
        this.type = allowedGraphType;
        this.matrixToGraph = new JButton(Resources.getInstance().MATRIX_TO_GRAPH_ICON);
        this.matrixToGraph.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_MATRIXTOGRAPH", string, "Create a Graph by use of an Adjacency Matrix") + "</html>");
        this.addButton(this.matrixToGraph);
        this.matrixToGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatrixToGraphToolBarExtension.this.showCreateDialog();
            }
        });
    }

    public AllowedGraphType getAllowedGraphType() {
        return this.type;
    }

    public void setAllowedGraphType(AllowedGraphType allowedGraphType) throws IllegalArgumentException {
        if (allowedGraphType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.type = allowedGraphType;
    }

    @Override
    public boolean getShowInMenu() {
        return true;
    }

    @Override
    public String getMenuOptionText() {
        return this.matrixToGraph.getToolTipText();
    }

    @Override
    public Icon getMenuOptionIcon() {
        return this.matrixToGraph.getIcon();
    }

    @Override
    public void showMenuOption() {
        this.showCreateDialog();
    }

    private void showCreateDialog() {
        AdjacencyMatrixDialog adjacencyMatrixDialog = new AdjacencyMatrixDialog(this.host, this.langFile, this.langID, this.type);
        adjacencyMatrixDialog.setVisible(true);
        if (adjacencyMatrixDialog.getAdjacencyMatrix() != null) {
            this.graphView.setGraph(GraphUtils.createGraph(adjacencyMatrixDialog.getAdjacencyMatrix(), this.graphView.getGraphFactory(), adjacencyMatrixDialog.getDirectedGraphChecked(), adjacencyMatrixDialog.getAllowZeroWeights()));
            this.graphView.layoutGraph(this.graphView.createCircleGraphLayout());
            this.graphView.repaint();
        }
    }
}

