/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.extensions.StatePopup;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.gui.dialogs.OptionDialog;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;
import lavesdk.utils.GraphUtils;

public class CompleteGraphToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final PluginHost host;
    private final GraphView<V, E> graphView;
    private final LanguageFile langFile;
    private final String langID;
    private AllowedGraphType type;
    private final JButton isCompleteGraphBtn;
    private final JButton createCompleteGraphBtn;
    private final String stateYes;
    private final String stateNo;
    private final String dlgTitle;
    private final String labelNumberOfVertices;
    private final String labelMaxWeight;

    public CompleteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType) throws IllegalArgumentException {
        this(pluginHost, graphView, allowedGraphType, null, "");
    }

    public CompleteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(pluginHost, graphView, allowedGraphType, languageFile, string, true);
    }

    public CompleteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, AllowedGraphType allowedGraphType, LanguageFile languageFile, String string, boolean bl) throws IllegalArgumentException {
        super(bl);
        if (graphView == null || allowedGraphType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.host = pluginHost;
        this.graphView = graphView;
        this.langFile = languageFile;
        this.langID = string;
        this.type = allowedGraphType;
        this.isCompleteGraphBtn = new JButton(Resources.getInstance().COMPLETE_GRAPH_ICON);
        this.createCompleteGraphBtn = new JButton(Resources.getInstance().CREATE_COMPLETE_GRAPH_ICON);
        this.isCompleteGraphBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_IS_COMPLETE", string, "Is Graph complete?") + "</html>");
        this.createCompleteGraphBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE", string, "Create complete Graph") + "</html>");
        this.stateYes = LanguageFile.getLabel(languageFile, "STATE_YES", string, "Yes");
        this.stateNo = LanguageFile.getLabel(languageFile, "STATE_NO", string, "No");
        this.dlgTitle = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_DLG_TITLE", string, "Create complete Graph");
        this.labelNumberOfVertices = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_DLG_NOV", string, "Number of vertices:");
        this.labelMaxWeight = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_DLG_MAXWEIGHT", string, "Max. weight of edges:");
        this.addButton(this.isCompleteGraphBtn);
        this.addButton(this.createCompleteGraphBtn);
        this.isCompleteGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GraphUtils.isComplete(CompleteGraphToolBarExtension.this.graphView.getGraph());
                StatePopup.showState(bl, CompleteGraphToolBarExtension.this.isCompleteGraphBtn, bl ? CompleteGraphToolBarExtension.this.stateYes : CompleteGraphToolBarExtension.this.stateNo);
            }
        });
        this.createCompleteGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompleteGraphToolBarExtension.this.showCreateDialog();
            }
        });
    }

    public AllowedGraphType getAllowedGraphType() {
        return this.type;
    }

    public void setAllowedGraphType(AllowedGraphType allowedGraphType) throws IllegalArgumentException {
        if (allowedGraphType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.type = allowedGraphType;
    }

    @Override
    public boolean getShowInMenu() {
        return true;
    }

    @Override
    public String getMenuOptionText() {
        return this.createCompleteGraphBtn.getToolTipText();
    }

    @Override
    public Icon getMenuOptionIcon() {
        return this.createCompleteGraphBtn.getIcon();
    }

    @Override
    public void showMenuOption() {
        this.showCreateDialog();
    }

    private void showCreateDialog() {
        Dialog dialog = new Dialog();
        dialog.setVisible(true);
        if (!dialog.isCanceled() && dialog.getNOV() > 0) {
            this.graphView.setGraph(GraphUtils.createCompleteGraph(dialog.getNOV(), dialog.getDirectedGraphChecked(), this.graphView.getGraphFactory(), dialog.getMaxEdgeWeight()));
            this.graphView.layoutGraph(this.graphView.createCircleGraphLayout());
            this.graphView.repaint();
        }
    }

    private class Dialog
    extends OptionDialog {
        private static final long serialVersionUID = 1L;
        private final JTextField txtNOV;
        private final JCheckBox cbDirectedGraph;
        private final JTextField txtMaxEdgeWeight;
        private int nov;
        private float maxEdgeWeight;

        public Dialog() {
            super(CompleteGraphToolBarExtension.this.host, "", CompleteGraphToolBarExtension.this.langFile, CompleteGraphToolBarExtension.this.langID, true);
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.add((Component)new JLabel(CompleteGraphToolBarExtension.this.dlgTitle), "Center");
            this.txtNOV = new JTextField();
            this.cbDirectedGraph = new JCheckBox(LanguageFile.getLabel(CompleteGraphToolBarExtension.this.langFile, "DLG_CB_CREATEDIRECTEDGRAPH", CompleteGraphToolBarExtension.this.langID, "Create a directed graph?"));
            this.txtMaxEdgeWeight = new JTextField();
            this.nov = -1;
            this.maxEdgeWeight = 0.0f;
            this.cbDirectedGraph.setSelected(CompleteGraphToolBarExtension.this.type == AllowedGraphType.DIRECTED_ONLY);
            this.cbDirectedGraph.setEnabled(CompleteGraphToolBarExtension.this.type == AllowedGraphType.BOTH);
            this.centerPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)new JLabel(CompleteGraphToolBarExtension.this.labelNumberOfVertices), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.txtNOV, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.cbDirectedGraph, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)new JLabel(CompleteGraphToolBarExtension.this.labelMaxWeight), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.txtMaxEdgeWeight, gridBagConstraints);
            this.pack();
            this.setSize(300, this.getHeight());
        }

        public int getNOV() {
            return this.nov;
        }

        public float getMaxEdgeWeight() {
            return this.maxEdgeWeight;
        }

        public boolean getDirectedGraphChecked() {
            return this.cbDirectedGraph.isSelected();
        }

        @Override
        protected void doOk() {
            try {
                this.nov = new Integer(this.txtNOV.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nov = -1;
            }
            try {
                this.maxEdgeWeight = new Float(this.txtMaxEdgeWeight.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.maxEdgeWeight = 0.0f;
            }
        }
    }
}

