/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.extensions.StatePopup;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.BipartiteGraphLayout;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.gui.dialogs.OptionDialog;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;
import lavesdk.utils.GraphUtils;

public class CompleteBipartiteGraphToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final PluginHost host;
    private final GraphView<V, E> graphView;
    private final LanguageFile langFile;
    private final String langID;
    private final JButton isCompleteBipartiteGraphBtn;
    private final JButton createCompleteBipartiteGraphBtn;
    private final String stateYes;
    private final String stateNo;
    private final String dlgTitle;
    private final String labelSubset1;
    private final String labelSubset2;
    private final String labelMaxWeight;

    public CompleteBipartiteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView) throws IllegalArgumentException {
        this(pluginHost, graphView, null, "");
    }

    public CompleteBipartiteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(pluginHost, graphView, languageFile, string, true);
    }

    public CompleteBipartiteGraphToolBarExtension(PluginHost pluginHost, GraphView<V, E> graphView, LanguageFile languageFile, String string, boolean bl) throws IllegalArgumentException {
        super(bl);
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.host = pluginHost;
        this.graphView = graphView;
        this.langFile = languageFile;
        this.langID = string;
        this.isCompleteBipartiteGraphBtn = new JButton(Resources.getInstance().COMPLETE_BIPARTITE_GRAPH_ICON);
        this.createCompleteBipartiteGraphBtn = new JButton(Resources.getInstance().CREATE_COMPLETE_BIPARTITE_GRAPH_ICON);
        this.isCompleteBipartiteGraphBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_IS_COMPLETE_BIPARTITE", string, "Is Graph complete bipartite?") + "</html>");
        this.createCompleteBipartiteGraphBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_BIPARTITE", string, "Create complete bipartite Graph") + "</html>");
        this.stateYes = LanguageFile.getLabel(languageFile, "STATE_YES", string, "Yes");
        this.stateNo = LanguageFile.getLabel(languageFile, "STATE_NO", string, "No");
        this.dlgTitle = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_BIPARTITE_DLG_TITLE", string, "Create complete bipartite Graph");
        this.labelSubset1 = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_BIPARTITE_DLG_SUBSET1", string, "Number of vertices in subset 1:");
        this.labelSubset2 = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_BIPARTITE_DLG_SUBSET2", string, "Number of vertices in subset 2:");
        this.labelMaxWeight = LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CREATE_COMPLETE_BIPARTITE_DLG_MAXWEIGHT", string, "Max. weight of edges:");
        this.addButton(this.isCompleteBipartiteGraphBtn);
        this.addButton(this.createCompleteBipartiteGraphBtn);
        this.isCompleteBipartiteGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GraphUtils.isCompleteBipartite(CompleteBipartiteGraphToolBarExtension.this.graphView.getGraph());
                StatePopup.showState(bl, CompleteBipartiteGraphToolBarExtension.this.isCompleteBipartiteGraphBtn, bl ? CompleteBipartiteGraphToolBarExtension.this.stateYes : CompleteBipartiteGraphToolBarExtension.this.stateNo);
            }
        });
        this.createCompleteBipartiteGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompleteBipartiteGraphToolBarExtension.this.showCreateDialog();
            }
        });
    }

    @Override
    public boolean getShowInMenu() {
        return true;
    }

    @Override
    public String getMenuOptionText() {
        return this.createCompleteBipartiteGraphBtn.getToolTipText();
    }

    @Override
    public Icon getMenuOptionIcon() {
        return this.createCompleteBipartiteGraphBtn.getIcon();
    }

    @Override
    public void showMenuOption() {
        this.showCreateDialog();
    }

    private void showCreateDialog() {
        Dialog dialog = new Dialog();
        dialog.setVisible(true);
        if (!dialog.isCanceled() && dialog.getN() > 0 && dialog.getM() > 0) {
            this.graphView.setGraph(GraphUtils.createCompleteBipartiteGraph(dialog.getN(), dialog.getM(), this.graphView.getGraphFactory(), dialog.getMaxEdgeWeight()));
            this.graphView.layoutGraph(new BipartiteGraphLayout());
            this.graphView.repaint();
        }
    }

    private class Dialog
    extends OptionDialog {
        private static final long serialVersionUID = 1L;
        private final JTextField txtSubset1;
        private final JTextField txtSubset2;
        private final JTextField txtMaxEdgeWeight;
        private int n;
        private int m;
        private float maxEdgeWeight;

        public Dialog() {
            super(CompleteBipartiteGraphToolBarExtension.this.host, "", CompleteBipartiteGraphToolBarExtension.this.langFile, CompleteBipartiteGraphToolBarExtension.this.langID, true);
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.add((Component)new JLabel(CompleteBipartiteGraphToolBarExtension.this.dlgTitle), "Center");
            this.txtSubset1 = new JTextField();
            this.txtSubset2 = new JTextField();
            this.txtMaxEdgeWeight = new JTextField();
            this.n = -1;
            this.m = -1;
            this.maxEdgeWeight = 0.0f;
            this.centerPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)new JLabel(CompleteBipartiteGraphToolBarExtension.this.labelSubset1), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.txtSubset1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)new JLabel(CompleteBipartiteGraphToolBarExtension.this.labelSubset2), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.txtSubset2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)new JLabel(CompleteBipartiteGraphToolBarExtension.this.labelMaxWeight), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.centerPanel.add((Component)this.txtMaxEdgeWeight, gridBagConstraints);
            this.pack();
            this.setSize(300, this.getHeight());
        }

        public int getN() {
            return this.n;
        }

        public int getM() {
            return this.m;
        }

        public float getMaxEdgeWeight() {
            return this.maxEdgeWeight;
        }

        @Override
        protected void doOk() {
            try {
                this.n = new Integer(this.txtSubset1.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.n = -1;
            }
            try {
                this.m = new Integer(this.txtSubset2.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.m = -1;
            }
            try {
                this.maxEdgeWeight = new Float(this.txtMaxEdgeWeight.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.maxEdgeWeight = 0.0f;
            }
        }
    }
}

