/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;

public class CircleLayoutToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final GraphView<V, E> graphView;
    private final JButton circleLayoutBtn;

    public CircleLayoutToolBarExtension(GraphView<V, E> graphView) throws IllegalArgumentException {
        this(graphView, null, "");
    }

    public CircleLayoutToolBarExtension(GraphView<V, E> graphView, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(graphView, languageFile, string, true);
    }

    public CircleLayoutToolBarExtension(GraphView<V, E> graphView, LanguageFile languageFile, String string, boolean bl) throws IllegalArgumentException {
        super(bl);
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphView = graphView;
        this.circleLayoutBtn = new JButton(Resources.getInstance().CIRCLE_LAYOUT_ICON);
        this.circleLayoutBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_CIRCLE_LAYOUT", string, "Apply Circle Layout to Graph") + "</html>");
        this.addButton(this.circleLayoutBtn);
        this.circleLayoutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircleLayoutToolBarExtension.this.graphView.layoutGraph(CircleLayoutToolBarExtension.this.graphView.createCircleGraphLayout());
                CircleLayoutToolBarExtension.this.graphView.repaint();
            }
        });
    }
}

