/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.BipartiteGraphLayout;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;

public class BipartiteLayoutToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final GraphView<V, E> graphView;
    private final JButton bipartiteLayoutBtn;

    public BipartiteLayoutToolBarExtension(GraphView<V, E> graphView) throws IllegalArgumentException {
        this(graphView, true, null, "");
    }

    public BipartiteLayoutToolBarExtension(GraphView<V, E> graphView, boolean bl) throws IllegalArgumentException {
        this(graphView, bl, null, "");
    }

    public BipartiteLayoutToolBarExtension(GraphView<V, E> graphView, boolean bl, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(graphView, bl, languageFile, string, true);
    }

    public BipartiteLayoutToolBarExtension(GraphView<V, E> graphView, final boolean bl, LanguageFile languageFile, String string, boolean bl2) throws IllegalArgumentException {
        super(bl2);
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphView = graphView;
        this.bipartiteLayoutBtn = new JButton(Resources.getInstance().BIPARTITE_LAYOUT_ICON);
        this.bipartiteLayoutBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_BIPARTITE_LAYOUT", string, "Apply Bipartite Layout to Graph (<b>only possible if graph is bipartite</b>)") + "</html>");
        this.addButton(this.bipartiteLayoutBtn);
        this.bipartiteLayoutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BipartiteLayoutToolBarExtension.this.graphView.layoutGraph(new BipartiteGraphLayout(bl));
                BipartiteLayoutToolBarExtension.this.graphView.repaint();
            }
        });
    }
}

