/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin.extensions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.extensions.StatePopup;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.resources.Resources;
import lavesdk.utils.GraphUtils;

public class BipartiteGraphToolBarExtension<V extends Vertex, E extends Edge>
extends ToolBarExtension {
    private final GraphView<V, E> graphView;
    private final JButton isBipartiteGraphBtn;
    private final String stateYes;
    private final String stateNo;

    public BipartiteGraphToolBarExtension(GraphView<V, E> graphView) throws IllegalArgumentException {
        this(graphView, null, "");
    }

    public BipartiteGraphToolBarExtension(GraphView<V, E> graphView, LanguageFile languageFile, String string) throws IllegalArgumentException {
        this(graphView, languageFile, string, true);
    }

    public BipartiteGraphToolBarExtension(GraphView<V, E> graphView, LanguageFile languageFile, String string, boolean bl) throws IllegalArgumentException {
        super(bl);
        if (graphView == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graphView = graphView;
        this.isBipartiteGraphBtn = new JButton(Resources.getInstance().BIPARTITE_GRAPH_ICON);
        this.isBipartiteGraphBtn.setToolTipText("<html>" + LanguageFile.getLabel(languageFile, "GRAPHTOOLBAR_IS_BIPARTITE", string, "Is Graph bipartite?") + "</html>");
        this.stateYes = LanguageFile.getLabel(languageFile, "STATE_YES", string, "Yes");
        this.stateNo = LanguageFile.getLabel(languageFile, "STATE_NO", string, "No");
        this.addButton(this.isBipartiteGraphBtn);
        this.isBipartiteGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GraphUtils.isBipartite(BipartiteGraphToolBarExtension.this.graphView.getGraph());
                StatePopup.showState(bl, BipartiteGraphToolBarExtension.this.isBipartiteGraphBtn, bl ? BipartiteGraphToolBarExtension.this.stateYes : BipartiteGraphToolBarExtension.this.stateNo);
            }
        });
    }
}

