/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResourceLoader {
    private final ClassLoader clsl;
    private final URLClassLoader urlClsl;

    public ResourceLoader(ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.clsl = classLoader;
        this.urlClsl = classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : null;
    }

    public URL getResource(String string) {
        return this.clsl.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        return this.clsl.getResourceAsStream(string);
    }

    public URL findResource(String string) {
        return this.urlClsl != null ? this.urlClsl.findResource(string) : null;
    }

    public Icon getResourceAsIcon(String string) {
        try {
            return new ImageIcon(this.getResource(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Image getResourceAsImage(String string) {
        try {
            return Toolkit.getDefaultToolkit().getImage(this.getResource(string));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

