/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.exceptions.InvalidPluginException;
import lavesdk.utils.ProgressListener;

public class PluginLoader {
    private static PluginLoader instance;

    private PluginLoader() {
    }

    public static final PluginLoader getInstance() {
        if (instance == null) {
            instance = new PluginLoader();
        }
        return instance;
    }

    public final List<PluginBundle> loadPlugins(String string) throws IllegalArgumentException {
        return this.loadPlugins(string, null);
    }

    public final List<PluginBundle> loadPlugins(String string, ProgressListener progressListener) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The given path is not a directory!");
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar");
            }
        });
        ArrayList<PluginBundle> arrayList = new ArrayList<PluginBundle>(fileArray.length);
        int n = 1;
        if (progressListener != null) {
            progressListener.totalProgress(fileArray.length);
        }
        for (File file2 : fileArray) {
            try {
                arrayList.add(this.loadPlugin(file2));
            }
            catch (InvalidPluginException invalidPluginException) {
                // empty catch block
            }
            if (progressListener == null) continue;
            progressListener.currentProgress(n++);
        }
        return arrayList;
    }

    public final PluginBundle loadPlugin(File file) throws IllegalArgumentException, InvalidPluginException {
        if (file == null || !file.getName().toLowerCase().endsWith(".jar")) {
            throw new IllegalArgumentException("No valid argument!");
        }
        URLClassLoader uRLClassLoader = null;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        PluginBundle pluginBundle = null;
        try {
            JarEntry jarEntry;
            uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            fileInputStream = new FileInputStream(file);
            zipInputStream = new JarInputStream(fileInputStream);
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                String string;
                Class<?> clazz;
                String string2 = jarEntry.getName();
                if (!string2.toLowerCase().endsWith(".class") || !AlgorithmPlugin.class.isAssignableFrom(clazz = uRLClassLoader.loadClass(string = string2.substring(0, string2.length() - ".class".length()).replace('/', '.')))) continue;
                pluginBundle = new PluginBundle((AlgorithmPlugin)clazz.newInstance(), new ResourceLoader(uRLClassLoader), file);
                break;
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            throw new InvalidPluginException(exception.getMessage());
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    zipInputStream = null;
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    fileInputStream = null;
                }
            }
        }
        if (pluginBundle == null) {
            throw new InvalidPluginException("The plugin " + file.getName() + " could not be loaded. Entry point is missing!");
        }
        return pluginBundle;
    }
}

