/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm.plugin;

import java.io.File;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.utils.FileUtils;

public class PluginBundle {
    private final AlgorithmPlugin plugin;
    private final ResourceLoader resLoader;
    private final File file;
    private final String name;
    private final String simpleName;
    private final String path;

    public PluginBundle(AlgorithmPlugin algorithmPlugin, ResourceLoader resourceLoader, File file) throws IllegalArgumentException {
        if (algorithmPlugin == null || resourceLoader == null || file == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.plugin = algorithmPlugin;
        this.resLoader = resourceLoader;
        this.file = file;
        this.name = file.getName();
        this.simpleName = this.name.substring(0, this.name.length() - ".jar".length());
        this.path = FileUtils.getDirFromFilePath(file.getAbsolutePath());
    }

    public final AlgorithmPlugin getPlugin() {
        return this.plugin;
    }

    public final ResourceLoader getResourceLoader() {
        return this.resLoader;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final String getPath() {
        return this.path;
    }
}

