/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm;

import lavesdk.algorithm.AlgorithmRTE;

public abstract class RTTransition<T> {
    private final AlgorithmRTE rte;
    protected final long duration;
    protected final int steps;
    protected final long frame;
    public static final long DEF_DURATION = 300L;
    public static final int DEF_STEPS = 10;

    public RTTransition(AlgorithmRTE algorithmRTE) throws IllegalArgumentException {
        this(algorithmRTE, 300L, 10);
    }

    public RTTransition(AlgorithmRTE algorithmRTE, long l, int n) throws IllegalArgumentException {
        if (algorithmRTE == null || l < (long)n || n < 2) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.rte = algorithmRTE;
        this.duration = l;
        this.steps = n;
        this.frame = l / (long)n;
    }

    public final void run() {
        this.beforeRun();
        for (int i = 1; i < this.steps; ++i) {
            this.apply(this.runStep(i));
            this.rte.sleep(this.frame);
        }
        this.afterRun();
    }

    protected abstract T runStep(int var1);

    protected abstract void apply(T var1);

    protected void beforeRun() {
    }

    protected void afterRun() {
    }
}

