/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.exceptions.IllegalInvocationException;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.views.GraphScene;
import lavesdk.math.Matrix;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.TrailByID;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.WalkByID;
import lavesdk.math.graph.matching.MatchingByID;
import lavesdk.serialization.Serializer;

public class AlgorithmState
extends Serializer
implements AlgorithmStateAttachment {
    private final AlgorithmPlugin plugin;
    private final int stepID;
    private byte[] state;
    private final Map<String, Object> attachment;
    private static final long serialVersionUID = 1L;

    public AlgorithmState(AlgorithmPlugin algorithmPlugin, int n) throws IllegalArgumentException {
        super(1, "AlgorithmState");
        if (algorithmPlugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.plugin = algorithmPlugin;
        this.stepID = n;
        this.state = null;
        this.attachment = new HashMap<String, Object>();
    }

    public final int getStepID() {
        return this.stepID;
    }

    public final <E extends Serializable> Set<E> addSet(String string, Set<E> set) throws IllegalArgumentException {
        return this.addData(string, set);
    }

    public final <E extends Serializable> Set<E> getSet(String string) {
        return this.getSet(string, null);
    }

    public final <E extends Serializable> Set<E> getSet(String string, Set<E> set) {
        Object v = this.data.get(string);
        if (v == null) {
            return set;
        }
        try {
            Set set2 = (Set)v;
            return set2;
        }
        catch (ClassCastException classCastException) {
            return set;
        }
    }

    public final <E extends Serializable> Matrix<E> addMatrix(String string, Matrix<E> matrix) throws IllegalArgumentException {
        return this.addData(string, matrix);
    }

    public final <E extends Serializable> Matrix<E> getMatrix(String string) {
        return this.getMatrix(string, null);
    }

    public final <E extends Serializable> Matrix<E> getMatrix(String string, Matrix<E> matrix) {
        Object v = this.data.get(string);
        if (v == null) {
            return matrix;
        }
        try {
            Matrix matrix2 = (Matrix)v;
            return matrix2;
        }
        catch (ClassCastException classCastException) {
            return matrix;
        }
    }

    public final <K extends Serializable, V extends Serializable> Map<K, V> addMap(String string, Map<K, V> map) throws IllegalArgumentException {
        return this.addData(string, map);
    }

    public final <K, V> Map<K, V> getMap(String string) {
        return this.getMap(string, null);
    }

    public final <K, V> Map<K, V> getMap(String string, Map<K, V> map) {
        Object v = this.data.get(string);
        if (v == null) {
            return map;
        }
        try {
            Map map2 = (Map)v;
            return map2;
        }
        catch (ClassCastException classCastException) {
            return map;
        }
    }

    public final <E extends Edge> MatchingByID<E> addMatching(String string, MatchingByID<E> matchingByID) throws IllegalArgumentException {
        return this.addData(string, matchingByID);
    }

    public final <V extends Vertex, E extends Edge> MatchingByID<E> getMatching(String string, Graph<V, E> graph) throws IllegalArgumentException {
        return this.getMatching(string, graph, null);
    }

    public final <V extends Vertex, E extends Edge> MatchingByID<E> getMatching(String string, Graph<V, E> graph, MatchingByID<E> matchingByID) throws IllegalArgumentException {
        Object v = this.data.get(string);
        if (v == null) {
            return matchingByID;
        }
        try {
            MatchingByID matchingByID2 = (MatchingByID)v;
            matchingByID2.setGraph(graph);
            return matchingByID2;
        }
        catch (ClassCastException classCastException) {
            return matchingByID;
        }
    }

    public final <V extends Vertex> WalkByID<V> addWalk(String string, WalkByID<V> walkByID) throws IllegalArgumentException {
        return this.addData(string, walkByID);
    }

    public final <V extends Vertex, E extends Edge> WalkByID<V> getWalk(String string, Graph<V, E> graph) throws IllegalArgumentException {
        return this.getWalk(string, graph, null);
    }

    public final <V extends Vertex, E extends Edge> WalkByID<V> getWalk(String string, Graph<V, E> graph, WalkByID<V> walkByID) throws IllegalArgumentException {
        Object v = this.data.get(string);
        if (v == null) {
            return walkByID;
        }
        try {
            WalkByID walkByID2 = (WalkByID)v;
            walkByID2.setGraph(graph);
            return walkByID2;
        }
        catch (ClassCastException classCastException) {
            return walkByID;
        }
    }

    public final <V extends Vertex> PathByID<V> addPath(String string, PathByID<V> pathByID) throws IllegalArgumentException {
        return this.addData(string, pathByID);
    }

    public final <V extends Vertex, E extends Edge> PathByID<V> getPath(String string, Graph<V, E> graph) throws IllegalArgumentException {
        return this.getPath(string, graph, null);
    }

    public final <V extends Vertex, E extends Edge> PathByID<V> getPath(String string, Graph<V, E> graph, PathByID<V> pathByID) throws IllegalArgumentException {
        Object v = this.data.get(string);
        if (v == null) {
            return pathByID;
        }
        try {
            PathByID pathByID2 = (PathByID)v;
            pathByID2.setGraph(graph);
            return pathByID2;
        }
        catch (ClassCastException classCastException) {
            return pathByID;
        }
    }

    public final <V extends Vertex> TrailByID<V> addTrail(String string, TrailByID<V> trailByID) throws IllegalArgumentException {
        return this.addData(string, trailByID);
    }

    public final <V extends Vertex, E extends Edge> TrailByID<V> getTrail(String string, Graph<V, E> graph) throws IllegalArgumentException {
        return this.getTrail(string, graph, null);
    }

    public final <V extends Vertex, E extends Edge> TrailByID<V> getTrail(String string, Graph<V, E> graph, TrailByID<V> trailByID) throws IllegalArgumentException {
        Object v = this.data.get(string);
        if (v == null) {
            return trailByID;
        }
        try {
            TrailByID trailByID2 = (TrailByID)v;
            trailByID2.setGraph(graph);
            return trailByID2;
        }
        catch (ClassCastException classCastException) {
            return trailByID;
        }
    }

    @Override
    public <T> T addAttachment(String string, T t) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.attachment.put(string, t);
        return t;
    }

    @Override
    public <T> T getAttachment(String string) {
        return this.getAttachment(string, null);
    }

    @Override
    public <T> T getAttachment(String string, T t) {
        Object object = this.attachment.get(string);
        if (object == null) {
            return t;
        }
        try {
            Object object2 = object;
            return (T)object2;
        }
        catch (ClassCastException classCastException) {
            return t;
        }
    }

    public final <V extends Vertex, E extends Edge> GraphScene<V, E> getScene(String string, GraphScene<V, E> graphScene) {
        Object object = this.attachment.get(string);
        if (object == null) {
            return graphScene;
        }
        try {
            GraphScene graphScene2 = (GraphScene)object;
            return graphScene2;
        }
        catch (ClassCastException classCastException) {
            return graphScene;
        }
    }

    @Override
    public boolean equals(Serializer serializer) {
        if (serializer instanceof AlgorithmState) {
            return this.equals((AlgorithmState)serializer);
        }
        return false;
    }

    public boolean equals(AlgorithmState algorithmState) {
        if (algorithmState == null) {
            return false;
        }
        return this.stepID == algorithmState.stepID && super.equals(algorithmState);
    }

    final void freeze() {
        StringBuilder stringBuilder = new StringBuilder();
        this.state = this.freezeData();
        if (this.state == null) {
            System.err.println("Algorithm state could not be frozen!\n" + stringBuilder.toString());
        }
    }

    final void unfreeze() throws IllegalInvocationException {
        if (this.state == null) {
            throw new IllegalInvocationException("State is unfrozen! Please invoke freeze() first.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.unfreezeData(this.state, stringBuilder)) {
            System.err.println("Algorithm state could not be unfrozen!\n" + stringBuilder.toString());
        }
    }

    @Override
    protected ObjectInputStream createObjectInputStream(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return new StateInputStream(this.plugin.getClass().getClassLoader(), byteArrayInputStream);
    }

    private class StateInputStream
    extends ObjectInputStream {
        private final ClassLoader clsl;

        public StateInputStream(ClassLoader classLoader, InputStream inputStream) throws IllegalArgumentException, IOException {
            super(inputStream);
            if (classLoader == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.clsl = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(objectStreamClass.getName(), false, this.clsl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }
}

