/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmExerciseController;
import lavesdk.algorithm.AlgorithmExerciseProvider;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEListener;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.enums.AlgorithmStartOption;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.security.HostSecurity;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.logging.enums.LogType;

public abstract class AlgorithmRTE
extends HostSecurity {
    private Thread thread;
    private final RuntimeEnvironment rte;
    private final AlgorithmPlugin plugin;
    private final AlgorithmState initialState;
    private final List<RTEListener> listeners;
    private final AlgorithmExerciseProvider customExerciseProvider;
    private static final short RTEVENT_BEFORESTART = 1;
    private static final short RTEVENT_BEFORERESUME = 2;
    private static final short RTEVENT_BEFOREPAUSE = 3;
    private static final short RTEVENT_ONSTOP = 4;
    private static final short RTEVENT_ONRUNNING = 5;
    private static final short RTEVENT_ONPAUSE = 6;

    public AlgorithmRTE(AlgorithmPlugin algorithmPlugin, AlgorithmText algorithmText) throws IllegalArgumentException {
        this(algorithmPlugin, algorithmText, null);
    }

    public AlgorithmRTE(AlgorithmPlugin algorithmPlugin, AlgorithmText algorithmText, AlgorithmExerciseProvider algorithmExerciseProvider) throws IllegalArgumentException {
        if (algorithmPlugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.thread = null;
        this.rte = new RuntimeEnvironment(algorithmText);
        this.plugin = algorithmPlugin;
        this.listeners = new ArrayList<RTEListener>();
        this.customExerciseProvider = algorithmExerciseProvider;
        this.initialState = new AlgorithmState(algorithmPlugin, -1);
        this.createInitialState(this.initialState);
        this.initialState.freeze();
        this.listeners.add(algorithmPlugin);
    }

    public final void addListener(RTEListener rTEListener) {
        if (rTEListener == null || this.listeners.contains(rTEListener)) {
            return;
        }
        this.listeners.add(rTEListener);
    }

    public final void removeListener(RTEListener rTEListener) {
        if (rTEListener == null || rTEListener == this.plugin) {
            return;
        }
        this.listeners.remove(rTEListener);
    }

    public final void start() {
        this.start(AlgorithmStartOption.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(AlgorithmStartOption algorithmStartOption) throws IllegalArgumentException {
        if (algorithmStartOption == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!this.isActivePlugin(this.plugin)) {
            this.writeLogMessage(this.plugin, "Plugin tries to start its algorithm runtime environment but is not active!", LogType.WARNING);
            return;
        }
        if (this.isRunning()) {
            return;
        }
        if (!this.isStarted()) {
            if (!this.fireRuntimeEvent(1)) {
                return;
            }
            this.rte.restart(algorithmStartOption);
            this.initialState.unfreeze();
            this.restoreState(this.initialState);
            AlgorithmRTE algorithmRTE = this;
            synchronized (algorithmRTE) {
                this.thread = new Thread(this.rte);
                this.thread.start();
            }
        } else if (this.rte.isPaused()) {
            if (!this.fireRuntimeEvent(2)) {
                return;
            }
            this.rte.resume(algorithmStartOption);
        }
        this.fireRuntimeEvent(5);
    }

    public final void pause() {
        if (!this.isActivePlugin(this.plugin)) {
            this.writeLogMessage(this.plugin, "Plugin tries to pause its algorithm runtime environment but is not active!", LogType.WARNING);
            return;
        }
        if (this.isStarted() && !this.isExerciseModeEnabled()) {
            if (!this.fireRuntimeEvent(3)) {
                return;
            }
            this.rte.pause();
            this.fireRuntimeEvent(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (!this.isActivePlugin(this.plugin)) {
            this.writeLogMessage(this.plugin, "Plugin tries to stop its algorithm runtime environment but is not active!", LogType.WARNING);
            return;
        }
        if (!this.isStarted()) {
            return;
        }
        AlgorithmRTE algorithmRTE = this;
        synchronized (algorithmRTE) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public final void nextStep() {
        if (!this.isActivePlugin(this.plugin)) {
            this.writeLogMessage(this.plugin, "Plugin tries to go to the next step in its algorithm runtime environment but is not active!", LogType.WARNING);
            return;
        }
        if (!this.isStarted()) {
            return;
        }
        this.rte.skipStep();
    }

    public final void prevStep() {
        if (!this.isActivePlugin(this.plugin)) {
            this.writeLogMessage(this.plugin, "Plugin tries to go to the previous step in its algorithm runtime environment but is not active!", LogType.WARNING);
            return;
        }
        if (!this.isStarted()) {
            return;
        }
        this.rte.goStepBack();
    }

    public final boolean isStarted() {
        return this.rte.isStarted();
    }

    public final boolean isRunning() {
        return this.isStarted() && !this.rte.isPaused();
    }

    public final float getExecSpeedFactor() {
        return this.rte.getExecSpeedFactor();
    }

    public final void setExecSpeedFactor(float f) {
        this.rte.setExecSpeedFactor(f);
    }

    public final long getMinStepDwellTime() {
        return this.rte.getMinDwellTime();
    }

    public final void setMinStepDwellTime(long l) throws IllegalArgumentException {
        this.rte.setMinDwellTime(l);
    }

    public final boolean getSkipBreakpoints() {
        return this.rte.getSkipBreakpoints();
    }

    public final void setSkipBreakpoints(boolean bl) {
        this.rte.setSkipBreakpoints(bl);
    }

    public final boolean getPauseBeforeStop() {
        return this.rte.getPauseBeforeTerminate();
    }

    public final void setPauseBeforeTerminate(boolean bl) {
        this.rte.setPauseBeforeTerminate(bl);
    }

    public final boolean isExerciseModeEnabled() {
        return this.rte.isExerciseModeEnabled();
    }

    public final void setExerciseModeEnabled(boolean bl) {
        if (!this.plugin.hasExerciseMode()) {
            return;
        }
        this.rte.setExerciseModeEnabled(bl);
    }

    protected final void sleep(long l) {
        if (!this.isStarted() || l <= 0L) {
            return;
        }
        this.rte.sleep(l);
    }

    protected abstract int executeStep(int var1, AlgorithmStateAttachment var2) throws Exception;

    protected abstract void storeState(AlgorithmState var1);

    protected abstract void restoreState(AlgorithmState var1);

    protected abstract void createInitialState(AlgorithmState var1);

    protected abstract void rollBackStep(int var1, int var2);

    protected abstract void adoptState(int var1, AlgorithmState var2);

    protected abstract View[] getViews();

    @Override
    protected final void hostAccepted() {
        this.rte.setExerciseProvider(this.customExerciseProvider != null ? this.customExerciseProvider : this.getDefaultExerciseProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStop() {
        AlgorithmRTE algorithmRTE = this;
        synchronized (algorithmRTE) {
            this.thread = null;
        }
        this.fireRuntimeEvent(4);
    }

    private boolean fireRuntimeEvent(final int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            final RTEListener rTEListener = this.listeners.get(i);
            final RTEvent rTEvent = new RTEvent(this.rte.getExecutingStepID());
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".fireRuntimeEvent", true){

                @Override
                protected void execute() throws Throwable {
                    switch (n) {
                        case 1: {
                            rTEListener.beforeStart(rTEvent);
                            break;
                        }
                        case 2: {
                            rTEListener.beforeResume(rTEvent);
                            break;
                        }
                        case 3: {
                            rTEListener.beforePause(rTEvent);
                            break;
                        }
                        case 4: {
                            rTEListener.onStop();
                            break;
                        }
                        case 5: {
                            rTEListener.onRunning();
                            break;
                        }
                        case 6: {
                            rTEListener.onPause();
                        }
                    }
                }
            });
            if (rTEvent.doit) continue;
            return false;
        }
        return true;
    }

    private final class RuntimeEnvironment
    implements Runnable,
    AlgorithmExerciseController {
        private final Object monitor;
        private final AlgorithmText text;
        private final Stack<AlgorithmState> stateHistory;
        private AlgorithmExerciseProvider exerciseProvider;
        private boolean exerciseModeEnabled;
        private boolean started;
        private int executingStepID;
        private boolean paused;
        private boolean terminateRTE;
        private boolean skipCurrStep;
        private boolean stepBack;
        private float sleepFactor;
        private boolean skipBreakpoints;
        private long minDwellTime;
        private AlgorithmStartOption currStartOpt;
        private boolean pauseBeforeTerminate;
        private static final int INITIALSTATE_STEPID = -1;

        public RuntimeEnvironment(AlgorithmText algorithmText) throws IllegalArgumentException {
            if (algorithmText == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.monitor = new Object();
            this.text = algorithmText;
            this.stateHistory = new Stack();
            this.exerciseProvider = null;
            this.exerciseModeEnabled = false;
            this.started = false;
            this.executingStepID = -1;
            this.paused = false;
            this.terminateRTE = false;
            this.skipCurrStep = false;
            this.stepBack = false;
            this.sleepFactor = 1.0f;
            this.skipBreakpoints = false;
            this.minDwellTime = 500L;
            this.currStartOpt = AlgorithmStartOption.NORMAL;
            this.pauseBeforeTerminate = false;
            algorithmText.setExecutingStepID(this.executingStepID);
        }

        public synchronized void restart(AlgorithmStartOption algorithmStartOption) {
            if (this.started) {
                return;
            }
            this.currStartOpt = !this.exerciseModeEnabled ? algorithmStartOption : AlgorithmStartOption.NORMAL;
            this.started = true;
            this.executingStepID = this.text.getFirstStepID();
            this.paused = false;
            this.terminateRTE = false;
            this.skipCurrStep = false;
            this.stepBack = false;
            this.stateHistory.clear();
        }

        public boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume(AlgorithmStartOption algorithmStartOption) {
            if (!this.started || this.exerciseModeEnabled) {
                return;
            }
            RuntimeEnvironment runtimeEnvironment = this;
            synchronized (runtimeEnvironment) {
                this.currStartOpt = !this.exerciseModeEnabled ? algorithmStartOption : AlgorithmStartOption.NORMAL;
                this.paused = false;
            }
            this.wakeUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeUp() {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
        }

        @Override
        public AlgorithmExerciseProvider getExerciseProvider() {
            return this.exerciseProvider;
        }

        public synchronized void setExerciseProvider(AlgorithmExerciseProvider algorithmExerciseProvider) {
            this.exerciseProvider = algorithmExerciseProvider;
        }

        public synchronized void pause() {
            if (this.exerciseModeEnabled) {
                return;
            }
            this.paused = true;
        }

        public boolean isPaused() {
            return this.paused;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sleep(long l) {
            if (this.skipCurrStep || this.terminateRTE) {
                return;
            }
            try {
                if (this.sleepFactor > 0.0f) {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.wait((long)((float)l * this.sleepFactor));
                    }
                }
                this.checkPause();
            }
            catch (InterruptedException interruptedException) {
                this.terminateRTE = true;
                this.enableSkipStepFlag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void skipStep() {
            RuntimeEnvironment runtimeEnvironment = this;
            synchronized (runtimeEnvironment) {
                if (this.exerciseModeEnabled) {
                    return;
                }
                this.enableSkipStepFlag();
            }
            this.wakeUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void goStepBack() {
            RuntimeEnvironment runtimeEnvironment = this;
            synchronized (runtimeEnvironment) {
                if (this.exerciseModeEnabled) {
                    return;
                }
                this.stepBack = true;
            }
            this.skipStep();
        }

        public int getExecutingStepID() {
            return this.executingStepID;
        }

        public boolean getSkipBreakpoints() {
            return this.skipBreakpoints;
        }

        public synchronized void setSkipBreakpoints(boolean bl) {
            this.skipBreakpoints = bl;
        }

        public float getExecSpeedFactor() {
            return 1.0f / this.sleepFactor;
        }

        public synchronized void setExecSpeedFactor(float f) {
            if (f > 0.0f) {
                this.sleepFactor = 1.0f / f;
            }
        }

        public long getMinDwellTime() {
            return this.minDwellTime;
        }

        public synchronized void setMinDwellTime(long l) throws IllegalArgumentException {
            if (l < 0L) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.minDwellTime = l;
        }

        public boolean getPauseBeforeTerminate() {
            return this.pauseBeforeTerminate;
        }

        public synchronized void setPauseBeforeTerminate(boolean bl) {
            this.pauseBeforeTerminate = bl;
        }

        @Override
        public boolean isExerciseModeEnabled() {
            return this.exerciseModeEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExerciseModeEnabled(boolean bl) {
            AlgorithmExerciseProvider algorithmExerciseProvider = null;
            Object object = this;
            synchronized (object) {
                if (this.started || this.exerciseModeEnabled == bl) {
                    return;
                }
                this.exerciseModeEnabled = bl;
                algorithmExerciseProvider = this.exerciseProvider;
            }
            if (algorithmExerciseProvider != null) {
                algorithmExerciseProvider.setHandler(this);
            }
            if (this.getHost() != null) {
                this.getHost().rteModeChanged();
            }
            if (algorithmExerciseProvider != null) {
                object = algorithmExerciseProvider;
                EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setExerciseModeEnabled", (AlgorithmExerciseProvider)object, bl){
                    final /* synthetic */ AlgorithmExerciseProvider val$ep;
                    final /* synthetic */ boolean val$enabled;
                    {
                        this.val$ep = algorithmExerciseProvider;
                        this.val$enabled = bl;
                        super(string);
                    }

                    @Override
                    protected void execute() throws Throwable {
                        this.val$ep.setVisible(this.val$enabled);
                    }
                });
            }
        }

        @Override
        public PluginHost getHost() {
            return AlgorithmRTE.this.getHost();
        }

        @Override
        public void run() {
            Thread thread = AlgorithmRTE.this.thread;
            int n = -1;
            boolean bl = false;
            AlgorithmExercise<?> algorithmExercise = null;
            boolean bl2 = false;
            this.terminateRTE = false;
            if (this.exerciseModeEnabled) {
                EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".run"){

                    @Override
                    protected void execute() throws Throwable {
                        if (RuntimeEnvironment.this.exerciseProvider != null) {
                            RuntimeEnvironment.this.exerciseProvider.beginExam();
                        }
                    }
                });
            }
            while (!bl && !thread.isInterrupted()) {
                try {
                    this.text.setExecutingStepID(this.executingStepID);
                    this.pushStateHistory(this.executingStepID);
                    if (!this.checkBreakpoint(this.executingStepID) && bl2 && this.currStartOpt == AlgorithmStartOption.PLAY_AND_PAUSE) {
                        AlgorithmRTE.this.pause();
                        this.checkPause();
                    }
                    if (this.currStartOpt == AlgorithmStartOption.START_TO_FINISH) {
                        this.enableSkipStepFlag();
                    }
                    algorithmExercise = this.getCurrentExercise();
                    if (!this.exerciseModeEnabled || algorithmExercise == null) {
                        long l = System.currentTimeMillis();
                        n = this.executeCurrentStep();
                        long l2 = System.currentTimeMillis() - l;
                        if (l2 < this.minDwellTime) {
                            this.sleep(this.minDwellTime - l2);
                        }
                    } else {
                        n = this.processExercise(algorithmExercise, this.text.getStepByID(this.executingStepID));
                    }
                    if (n > 0 && !this.terminateRTE) {
                        this.checkPause();
                        if (this.stepBack) {
                            n = this.popStateHistory(this.executingStepID, n);
                            this.stepBack = false;
                        }
                    } else {
                        bl = true;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.terminateRTE = true;
                }
                this.disableSkipStepFlag();
                this.stepBack = false;
                if (bl && !this.terminateRTE) {
                    algorithmExercise = this.text.getFinalExercise();
                    try {
                        if (this.exerciseModeEnabled && algorithmExercise != null) {
                            this.processExercise(algorithmExercise, null);
                        }
                        if (!this.exerciseModeEnabled && this.pauseBeforeTerminate) {
                            AlgorithmRTE.this.pause();
                            this.checkPause();
                            if (this.stepBack) {
                                n = this.popStateHistory(this.executingStepID, n);
                                this.disableSkipStepFlag();
                                this.stepBack = false;
                                bl = false;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminateRTE = true;
                    }
                }
                if (this.terminateRTE) {
                    thread.interrupt();
                }
                this.executingStepID = n;
                bl2 = true;
            }
            if (!thread.isInterrupted()) {
                thread.interrupt();
            }
            if (this.exerciseModeEnabled) {
                EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".run"){

                    @Override
                    protected void execute() throws Throwable {
                        if (RuntimeEnvironment.this.exerciseProvider != null) {
                            RuntimeEnvironment.this.exerciseProvider.endExam(RuntimeEnvironment.this.terminateRTE);
                        }
                    }
                });
            }
            this.done();
        }

        private void enableSkipStepFlag() {
            View[] viewArray;
            boolean bl = this.skipCurrStep;
            this.skipCurrStep = true;
            if (this.skipCurrStep != bl && (viewArray = AlgorithmRTE.this.getViews()) != null) {
                for (View view : viewArray) {
                    if (view == null) continue;
                    view.setRepaintDisabled(true);
                }
            }
        }

        private void disableSkipStepFlag() {
            View[] viewArray;
            boolean bl = this.skipCurrStep;
            this.skipCurrStep = false;
            if (this.skipCurrStep != bl && (viewArray = AlgorithmRTE.this.getViews()) != null) {
                for (View view : viewArray) {
                    if (view == null) continue;
                    view.setRepaintDisabled(false);
                }
            }
        }

        private int processExercise(final AlgorithmExercise<?> algorithmExercise, AlgorithmStep algorithmStep) throws InterruptedException {
            final AlgorithmState algorithmState = this.stateHistory.peek();
            AlgorithmExercise.ExamResult examResult = AlgorithmExercise.ExamResult.FAILED;
            int n = -1;
            InterruptedException interruptedException = null;
            algorithmExercise.enter(this, algorithmStep);
            try {
                do {
                    algorithmState.unfreeze();
                    EDT.execute(new GuiJob(){

                        @Override
                        protected void execute() throws Throwable {
                            algorithmExercise.beforeRequestSolution(algorithmState);
                        }
                    });
                    try {
                        this.sleep();
                        if (!algorithmExercise.isOmitted()) {
                            this.enableSkipStepFlag();
                        }
                    }
                    catch (InterruptedException interruptedException2) {
                        interruptedException = interruptedException2;
                    }
                    final boolean bl = algorithmExercise.isOmitted();
                    EDT.execute(new GuiJob(){

                        @Override
                        protected void execute() throws Throwable {
                            algorithmExercise.afterRequestSolution(bl);
                        }
                    });
                    if (interruptedException != null) {
                        throw interruptedException;
                    }
                    if (algorithmExercise.getApplySolutionToAlgorithm() && !algorithmExercise.isOmitted()) {
                        examResult = algorithmExercise.examine(algorithmState);
                        if (examResult == AlgorithmExercise.ExamResult.SUCCEEDED) {
                            AlgorithmState algorithmState2 = new AlgorithmState(AlgorithmRTE.this.plugin, this.executingStepID);
                            algorithmExercise.transferSolution(algorithmState2);
                            AlgorithmRTE.this.adoptState(this.executingStepID, algorithmState2);
                            n = this.executeCurrentStep();
                        }
                    } else {
                        n = this.executeCurrentStep();
                    }
                    if (!(this.terminateRTE || algorithmExercise.getApplySolutionToAlgorithm() || (examResult = algorithmExercise.examine(this.requestState(this.executingStepID))) != AlgorithmExercise.ExamResult.FAILED || algorithmExercise.isOmitted())) {
                        algorithmState.unfreeze();
                        AlgorithmRTE.this.restoreState(algorithmState);
                        AlgorithmRTE.this.rollBackStep(this.executingStepID, n);
                    }
                    this.disableSkipStepFlag();
                } while (examResult != AlgorithmExercise.ExamResult.SUCCEEDED && !this.terminateRTE && !algorithmExercise.isOmitted());
            }
            catch (InterruptedException interruptedException3) {
                throw interruptedException3;
            }
            finally {
                algorithmExercise.exit(examResult);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkPause() throws InterruptedException {
            if (this.exerciseModeEnabled || this.skipCurrStep || this.terminateRTE) {
                return false;
            }
            if (this.paused) {
                Object object = this.monitor;
                synchronized (object) {
                    while (this.paused && !this.skipCurrStep) {
                        this.monitor.wait();
                    }
                }
                return true;
            }
            return false;
        }

        private boolean checkBreakpoint(int n) throws InterruptedException {
            if (this.exerciseModeEnabled || this.skipBreakpoints || this.terminateRTE) {
                return false;
            }
            AlgorithmStep algorithmStep = this.text.getStepByID(n);
            if (algorithmStep != null && algorithmStep.hasBreakpoint()) {
                AlgorithmRTE.this.pause();
            }
            return this.checkPause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sleep() throws InterruptedException {
            if (this.skipCurrStep || this.terminateRTE) {
                return;
            }
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }

        private AlgorithmState requestState(int n) {
            AlgorithmState algorithmState = new AlgorithmState(AlgorithmRTE.this.plugin, n);
            AlgorithmRTE.this.storeState(algorithmState);
            algorithmState.freeze();
            return algorithmState;
        }

        private void pushStateHistory(int n) {
            this.stateHistory.push(this.requestState(n));
        }

        private int popStateHistory(int n, int n2) {
            AlgorithmState algorithmState = null;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = n2;
            while (this.stateHistory.size() > 0 && !bl) {
                algorithmState = this.stateHistory.pop();
                bl2 = bl2 || algorithmState.getStepID() == n;
                bl = bl2 && algorithmState.getStepID() != n;
                algorithmState.unfreeze();
                AlgorithmRTE.this.restoreState(algorithmState);
                AlgorithmRTE.this.rollBackStep(algorithmState.getStepID(), n3);
                n3 = algorithmState.getStepID();
            }
            if (algorithmState == null) {
                return this.text.getFirstStepID();
            }
            return algorithmState.getStepID();
        }

        private int executeCurrentStep() {
            try {
                return AlgorithmRTE.this.executeStep(this.executingStepID, this.stateHistory.peek());
            }
            catch (Exception exception) {
                AlgorithmRTE.this.writeLogMessage(AlgorithmRTE.this.plugin, "execution of step id " + this.executingStepID + " failed", exception, LogType.ERROR);
                this.terminateRTE = true;
                return -1;
            }
        }

        private AlgorithmExercise<?> getCurrentExercise() {
            if (!this.exerciseModeEnabled) {
                return null;
            }
            AlgorithmStep algorithmStep = this.text.getStepByID(this.executingStepID);
            return algorithmStep != null ? algorithmStep.getExercise() : null;
        }

        private void done() {
            this.started = false;
            this.skipCurrStep = false;
            this.stateHistory.clear();
            this.text.setExecutingStepID(-1);
            AlgorithmRTE.this.onStop();
        }
    }
}

