/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.algorithm;

import lavesdk.algorithm.AlgorithmExerciseController;
import lavesdk.algorithm.AlgorithmExerciseProvider;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.exceptions.IllegalInvocationException;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.Annotation;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.language.LanguageFile;

public abstract class AlgorithmExercise<T> {
    private final String text;
    private final float credits;
    private final View[] views;
    private T[] currSolutions;
    private AlgorithmExerciseController controller;
    private boolean processing;
    private boolean givenUp;
    private String lastSolution;

    public AlgorithmExercise(String string) throws IllegalArgumentException {
        this(string, 0.0f);
    }

    public AlgorithmExercise(String string, float f) throws IllegalArgumentException {
        this(string, f, (View)null);
    }

    public AlgorithmExercise(String string, float f, View view) throws IllegalArgumentException {
        View[] viewArray;
        if (view != null) {
            View[] viewArray2 = new View[1];
            viewArray = viewArray2;
            viewArray2[0] = view;
        } else {
            viewArray = null;
        }
        this(string, f, viewArray);
    }

    public AlgorithmExercise(String string, float f, View[] viewArray) throws IllegalArgumentException {
        if (string == null || string.isEmpty() || f < 0.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.text = string;
        this.credits = f;
        this.views = viewArray;
        this.currSolutions = null;
        this.controller = null;
        this.processing = false;
        this.givenUp = false;
    }

    public final String getText() {
        return this.text;
    }

    public final float getCredits() {
        return this.credits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean solve() {
        T[] TArray = this.requestSolution();
        boolean bl = false;
        if (TArray == null) {
            return false;
        }
        AlgorithmExercise algorithmExercise = this;
        synchronized (algorithmExercise) {
            if (!this.givenUp) {
                this.currSolutions = TArray;
                bl = true;
            }
        }
        if (bl) {
            this.controller.wakeUp();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void giveUp() {
        boolean bl = false;
        AlgorithmExercise algorithmExercise = this;
        synchronized (algorithmExercise) {
            if (!this.givenUp) {
                this.currSolutions = null;
                this.givenUp = true;
                bl = true;
            }
        }
        if (bl) {
            this.controller.wakeUp();
        }
    }

    public Annotation getInputHintMessage(LanguageFile languageFile, String string) {
        String string2 = LanguageFile.getLabel(languageFile, "EXERCISE_INPUTHINT_DEFMSG", string, "Enter your solution of the task in the highlighted view(s) \"&views&\".<br>Click on the \"Solve Exercise\"-button only after you have made the input.");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.views != null) {
            boolean bl = false;
            for (View view : this.views) {
                if (view == null) continue;
                if (bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(view.getTitle());
                bl = true;
            }
        }
        return new Annotation(string2.replaceAll("&views&", stringBuilder.toString()));
    }

    public boolean hasInputHint() {
        return this.views != null && this.views.length > 0;
    }

    public Annotation getLastFailedHintMessage() {
        return null;
    }

    public final boolean hasLastFailedHint() {
        return !this.givenUp && this.getLastFailedHintMessage() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getSolutionAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        AlgorithmExercise algorithmExercise = this;
        synchronized (algorithmExercise) {
            if (this.currSolutions == null) {
                stringBuilder.append("");
            } else {
                for (int i = 0; i < this.currSolutions.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.getResultAsString(this.currSolutions[i], i));
                }
            }
        }
        return stringBuilder.toString();
    }

    protected String getResultAsString(T t, int n) {
        if (t == null) {
            return "";
        }
        return t.toString();
    }

    protected abstract T[] requestSolution();

    protected abstract boolean examine(T[] var1, AlgorithmState var2);

    protected final boolean doAutoExamine(AlgorithmState algorithmState, String[] stringArray, T[] TArray) throws IllegalArgumentException {
        if (algorithmState == null || stringArray == null || TArray == null || TArray.length != stringArray.length) {
            throw new IllegalArgumentException("No valid argument!");
        }
        boolean bl = false;
        for (int i = 0; i < TArray.length; ++i) {
            boolean bl2 = bl = TArray[i] != null && TArray[i].equals(algorithmState.getObject(stringArray[i]));
            if (!bl) break;
        }
        return bl;
    }

    protected void beforeRequestSolution(AlgorithmState algorithmState) {
    }

    protected void afterRequestSolution(boolean bl) {
    }

    protected boolean getApplySolutionToAlgorithm() {
        return false;
    }

    protected void applySolutionToAlgorithm(AlgorithmState algorithmState, T[] TArray) {
    }

    protected void entered() {
    }

    protected void exited() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter(AlgorithmExerciseController algorithmExerciseController, final AlgorithmStep algorithmStep) throws IllegalArgumentException {
        if (algorithmExerciseController == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (this.processing) {
            return;
        }
        AlgorithmExercise object = this;
        synchronized (object) {
            this.controller = algorithmExerciseController;
            this.processing = true;
            this.givenUp = false;
            this.lastSolution = "";
        }
        if (this.views != null) {
            for (View view : this.views) {
                if (view == null) continue;
                view.setVisible(true);
                view.highlight(true);
            }
        }
        this.entered();
        final AlgorithmExerciseProvider algorithmExerciseProvider = algorithmExerciseController.getExerciseProvider();
        if (algorithmExerciseProvider != null) {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".enter"){

                @Override
                protected void execute() throws Throwable {
                    if (algorithmExerciseProvider.isVisible()) {
                        algorithmExerciseProvider.beforeProcessingExercise(AlgorithmExercise.this, algorithmStep);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exit(final ExamResult examResult) {
        if (!this.processing) {
            return;
        }
        if (this.views != null) {
            for (View view : this.views) {
                if (view == null) continue;
                view.highlight(false);
            }
        }
        final String string = this.lastSolution;
        final AlgorithmExerciseProvider algorithmExerciseProvider = this.controller.getExerciseProvider();
        if (algorithmExerciseProvider != null) {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".exit"){

                @Override
                protected void execute() throws Throwable {
                    if (algorithmExerciseProvider.isVisible()) {
                        algorithmExerciseProvider.afterProcessingExercise(AlgorithmExercise.this, examResult, string);
                    }
                }
            });
        }
        AlgorithmExercise algorithmExercise = this;
        synchronized (algorithmExercise) {
            this.currSolutions = null;
            this.controller = null;
            this.processing = false;
            this.givenUp = false;
            this.lastSolution = null;
        }
        this.exited();
    }

    ExamResult examine(AlgorithmState algorithmState) throws IllegalArgumentException, IllegalInvocationException {
        if (algorithmState == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!this.processing) {
            throw new IllegalInvocationException("exercise was not entered before");
        }
        if (this.givenUp) {
            return ExamResult.FAILED;
        }
        algorithmState.unfreeze();
        final boolean bl = this.examine(this.currSolutions, algorithmState);
        this.lastSolution = this.getSolutionAsString();
        final AlgorithmExerciseProvider algorithmExerciseProvider = this.controller.getExerciseProvider();
        if (algorithmExerciseProvider != null) {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".examine"){

                @Override
                protected void execute() throws Throwable {
                    if (algorithmExerciseProvider.isVisible()) {
                        algorithmExerciseProvider.afterSolvingExercise(AlgorithmExercise.this, bl, AlgorithmExercise.this.lastSolution);
                    }
                }
            });
        }
        return bl ? ExamResult.SUCCEEDED : ExamResult.FAILED;
    }

    void transferSolution(AlgorithmState algorithmState) throws IllegalArgumentException {
        if (algorithmState == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (this.currSolutions != null) {
            this.applySolutionToAlgorithm(algorithmState, this.currSolutions);
        }
    }

    boolean isOmitted() {
        return this.givenUp;
    }

    boolean isInProcess() {
        return this.processing;
    }

    public static enum ExamResult {
        SUCCEEDED,
        FAILED;

    }
}

