/*
 * Decompiled with CFR 0.152.
 */
package lavesdk;

import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.resources.Resources;

public class LAVESDKV
implements Comparable<LAVESDKV> {
    private final int major;
    private final int minor;
    public static final LAVESDKV CURRENT;
    public static final LAVESDKV MINIMUM;

    public LAVESDKV(int n, int n2) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.major = n;
        this.minor = n2;
    }

    public static boolean checkCompatibility(LAVESDKV lAVESDKV) {
        if (lAVESDKV == null) {
            return false;
        }
        return lAVESDKV.compareTo(MINIMUM) >= 0 && lAVESDKV.compareTo(CURRENT) <= 0;
    }

    public static boolean checkCompatibility(AlgorithmPlugin algorithmPlugin) {
        return LAVESDKV.checkCompatibility(algorithmPlugin.getUsedSDKVersion());
    }

    @Override
    public int compareTo(LAVESDKV lAVESDKV) {
        if (lAVESDKV == null) {
            return 1;
        }
        int n = this.major - lAVESDKV.major;
        int n2 = this.minor - lAVESDKV.minor;
        if (n == 0) {
            return n2;
        }
        return n;
    }

    public String toString() {
        return "" + this.major + "." + this.minor;
    }

    static {
        Integer n = new Integer(Resources.getInstance().LAVESDK_PROPERTIES.getProperty("version_major", "1"));
        Integer n2 = new Integer(Resources.getInstance().LAVESDK_PROPERTIES.getProperty("version_minor", "0"));
        Integer n3 = new Integer(Resources.getInstance().LAVESDK_PROPERTIES.getProperty("min_version_major", "1"));
        Integer n4 = new Integer(Resources.getInstance().LAVESDK_PROPERTIES.getProperty("min_version_minor", "0"));
        if (n < 1) {
            n = new Integer(1);
        }
        if (n2 < 0) {
            n2 = new Integer(0);
        }
        if (n3 < 1) {
            n3 = new Integer(1);
        }
        if (n4 < 0) {
            n4 = new Integer(0);
        }
        CURRENT = new LAVESDKV(n, n2);
        MINIMUM = new LAVESDKV(n3, n4);
    }
}

